/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.except;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMException;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@ExportLibrary(value=InteropLibrary.class, delegateTo="unwindHeader")
public final class LLVMUserException
extends LLVMException {
    public static final String FRAME_SLOT_ID = "<function exception value>";
    private static final long serialVersionUID = 1L;
    final LLVMPointer unwindHeader;

    public LLVMUserException(Node location, LLVMPointer unwindHeader) {
        super(location);
        this.unwindHeader = unwindHeader;
    }

    public LLVMPointer getUnwindHeader() {
        return this.unwindHeader;
    }

    public String getMessage() {
        return "LLVMException:" + this.unwindHeader.toString();
    }

    @ExportMessage
    boolean isException() {
        return true;
    }

    @ExportMessage
    RuntimeException throwException() {
        throw this;
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return ExceptionType.RUNTIME_ERROR;
    }

    @ExportMessage
    boolean hasExceptionMessage() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    String getExceptionMessage() {
        return this.getMessage();
    }
}

