/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugObject;
import java.util.function.Supplier;

@ExportLibrary(value=InteropLibrary.class)
public abstract class LLVMSourceType
extends LLVMDebuggerValue {
    public static final LLVMSourceType UNSUPPORTED = new LLVMSourceType(() -> "<unsupported>", 0L, 0L, 0L, null){

        @Override
        public LLVMSourceType getOffset(long newOffset) {
            return this;
        }
    };
    public static final LLVMSourceType UNKNOWN = new LLVMSourceType(() -> "<unknown>", 0L, 0L, 0L, null){

        @Override
        public LLVMSourceType getOffset(long newOffset) {
            return this;
        }
    };
    public static final LLVMSourceType VOID = new LLVMSourceType(() -> "void", 0L, 0L, 0L, null){

        @Override
        public LLVMSourceType getOffset(long newOffset) {
            return this;
        }
    };
    private final LLVMSourceLocation location;
    private final long size;
    private final long align;
    private final long offset;
    @CompilerDirectives.CompilationFinal
    private Supplier<String> nameSupplier;

    public LLVMSourceType(Supplier<String> nameSupplier, long size, long align, long offset, LLVMSourceLocation location) {
        this.nameSupplier = nameSupplier;
        this.size = size;
        this.align = align;
        this.offset = offset;
        this.location = location;
    }

    LLVMSourceType(long size, long align, long offset, LLVMSourceLocation location) {
        this(UNKNOWN::getName, size, align, offset, location);
    }

    @ExportMessage
    final boolean isMetaObject() {
        return true;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="getMetaSimpleName"), @ExportMessage(name="getMetaQualifiedName")})
    final Object getMetaSimpleName() {
        return this.getName();
    }

    @ExportMessage
    final boolean isMetaInstance(Object instance) {
        if (instance instanceof LLVMDebugObject) {
            return ((LLVMDebugObject)instance).getType() == this;
        }
        return false;
    }

    @ExportMessage
    final boolean hasSourceLocation() {
        return this.location != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    final SourceSection getSourceLocation() {
        return this.location.getSourceSection();
    }

    @CompilerDirectives.TruffleBoundary
    public String getName() {
        return this.nameSupplier.get();
    }

    public void setName(Supplier<String> nameSupplier) {
        CompilerAsserts.neverPartOfCompilation();
        this.nameSupplier = nameSupplier;
    }

    public long getSize() {
        return this.size;
    }

    public long getAlign() {
        return this.align;
    }

    public long getOffset() {
        return this.offset;
    }

    public abstract LLVMSourceType getOffset(long var1);

    public LLVMSourceType getActualType() {
        return this;
    }

    @ExportMessage.Ignore
    public boolean isPointer() {
        return false;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isAggregate() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public int getElementCount() {
        return 0;
    }

    public String getElementName(long i) {
        return null;
    }

    public LLVMSourceType getElementType(long i) {
        return null;
    }

    public LLVMSourceType getElementType(String name) {
        return null;
    }

    public LLVMSourceLocation getElementDeclaration(long i) {
        return null;
    }

    public LLVMSourceLocation getElementDeclaration(String name) {
        return null;
    }

    public LLVMSourceLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    protected int getElementCountForDebugger() {
        return this.getElementCount();
    }

    @Override
    protected String[] getKeysForDebugger() {
        if (this.getElementCount() == 0) {
            return NO_KEYS;
        }
        String[] keys = new String[this.getElementCount()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = this.getElementName(i);
        }
        return keys;
    }

    @Override
    protected Object getElementForDebugger(String key) {
        return this.getElementType(key);
    }
}

