/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceMethodType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStaticMemberType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceStructLikeType;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public final class LLVMSourceClassLikeType
extends LLVMSourceStructLikeType {
    private final List<LLVMSourceMethodType> methods;

    @CompilerDirectives.TruffleBoundary
    public LLVMSourceClassLikeType(String name, long size, long align, long offset, LLVMSourceLocation location) {
        super(name, size, align, offset, location);
        this.methods = new ArrayList<LLVMSourceMethodType>();
    }

    private LLVMSourceClassLikeType(Supplier<String> name, long size, long align, long offset, List<LLVMSourceMemberType> dynamicMembers, LLVMSourceStaticMemberType.CollectionType staticMembers, List<LLVMSourceMethodType> methods, LLVMSourceLocation location) {
        super(name, size, align, offset, dynamicMembers, staticMembers, location);
        this.methods = methods;
    }

    public void addMethod(String name, String linkageName, LLVMSourceFunctionType function) {
        CompilerAsserts.neverPartOfCompilation();
        LLVMSourceMethodType method = new LLVMSourceMethodType(function.getParameterTypes(), name, linkageName, this);
        this.methods.add(method);
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        return new LLVMSourceClassLikeType(this::getName, this.getSize(), this.getAlign(), newOffset, this.dynamicMembers, this.staticMembers, this.methods, this.getLocation());
    }

    @Override
    public boolean isAggregate() {
        return true;
    }

    public int getMethodCount() {
        return this.methods.size();
    }

    public LLVMSourceFunctionType getMethod(int i) {
        return this.methods.get(i);
    }

    public String getMethodName(int i) {
        return this.methods.get(i).getName();
    }

    public String getMethodLinkageName(int i) {
        return this.methods.get(i).getLinkageName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public int getElementCount() {
        return super.getElementCount() + this.methods.size();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getElementName(long i) {
        int index;
        String elementName = super.getElementName(i);
        if (elementName == null && 0 <= (index = (int)(i - (long)super.getElementCount())) && index < this.methods.size()) {
            return this.methods.get(index).getName();
        }
        return elementName;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getElementNameByOffset(long offset) {
        String elementName = super.getElementNameByOffset(offset);
        if (elementName == null) {
            for (LLVMSourceFunctionType lLVMSourceFunctionType : this.methods) {
                if (lLVMSourceFunctionType.getOffset() != offset) continue;
                return lLVMSourceFunctionType.getName();
            }
        }
        return elementName;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMSourceType getElementType(long i) {
        int index;
        LLVMSourceType llvmSourceType = super.getElementType(i);
        if (llvmSourceType == null && 0 <= (index = (int)(i - (long)super.getElementCount())) && index < this.methods.size()) {
            return this.methods.get(index).getReturnType();
        }
        return llvmSourceType;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMSourceType getElementType(String name) {
        int idx;
        LLVMSourceType llvmSourceType = super.getElementType(name);
        if (llvmSourceType == null && (idx = this.getMethodIndexByName(name)) >= 0) {
            return this.methods.get(idx).getReturnType();
        }
        return llvmSourceType;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMSourceLocation getElementDeclaration(long i) {
        int index;
        LLVMSourceLocation llvmSourceLocation = super.getElementDeclaration(i);
        if (llvmSourceLocation == null && 0 <= (index = (int)(i - (long)super.getElementCount())) && index < this.methods.size()) {
            return this.methods.get(index).getLocation();
        }
        return llvmSourceLocation;
    }

    private int getMethodIndexByName(String name) {
        if (name == null) {
            return -1;
        }
        for (int i = 0; i < this.methods.size(); ++i) {
            LLVMSourceMethodType method = this.methods.get(i);
            if (!name.contentEquals(method.getLinkageName()) && !name.contentEquals(method.getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public LLVMSourceLocation getElementDeclaration(String name) {
        int idx;
        LLVMSourceLocation llvmSourceLocation = super.getElementDeclaration(name);
        if (llvmSourceLocation == null && (idx = this.getMethodIndexByName(name)) >= 0) {
            return this.methods.get(idx).getLocation();
        }
        return llvmSourceLocation;
    }
}

