/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprSizeofNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;

public abstract class DebugExprSizeofNode
extends LLVMExpressionNode {
    private final long typeSize;

    public static DebugExprSizeofNode create(DebugExprType type) throws Type.TypeOverflowException {
        DataLayout datalayout = LLVMLanguage.getContext().getLibsulongDataLayout();
        return DebugExprSizeofNodeGen.create(type.getLLVMRuntimeType().getSize(datalayout));
    }

    DebugExprSizeofNode(long typeSize) {
        this.typeSize = typeSize;
    }

    @Specialization
    public long getSize() {
        if (this.typeSize < 0L) {
            CompilerDirectives.transferToInterpreter();
            throw DebugExprException.create(this, "Error while finding type size", new Object[0]);
        }
        return this.typeSize;
    }
}

