/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.SulongLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=SulongLibrary.class)
public final class SulongLibraryFactory {

    @GeneratedBy(value=SulongLibrary.LookupNode.class)
    static final class LookupNodeGen
    extends SulongLibrary.LookupNode {
        private static final Uncached UNCACHED = new Uncached();
        @CompilerDirectives.CompilationFinal
        private volatile int state_0_;
        @CompilerDirectives.CompilationFinal
        private volatile int exclude_;
        @CompilerDirectives.CompilationFinal
        private CachedData cached_cache;

        private LookupNodeGen() {
        }

        @Override
        @ExplodeLoop
        LLVMFunctionDescriptor execute(SulongLibrary arg0Value, String arg1Value) {
            int state_0 = this.state_0_;
            if (state_0 != 0) {
                if ((state_0 & 1) != 0) {
                    CachedData s1_ = this.cached_cache;
                    while (s1_ != null) {
                        if (!Assumption.isValidAssumption((Assumption)s1_.assumption0_)) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            this.removeCached_(s1_);
                            return this.executeAndSpecialize(arg0Value, arg1Value);
                        }
                        if (arg0Value == s1_.cachedLibrary_ && arg1Value.equals(s1_.cachedName_)) {
                            return this.doCached(arg0Value, arg1Value, s1_.cachedLibrary_, s1_.cachedName_, s1_.cachedDescriptor_);
                        }
                        s1_ = s1_.next_;
                    }
                }
                if ((state_0 & 2) != 0) {
                    return SulongLibrary.LookupNode.doGeneric(arg0Value, arg1Value);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(arg0Value, arg1Value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LLVMFunctionDescriptor executeAndSpecialize(SulongLibrary arg0Value, String arg1Value) {
            Lock lock = this.getLock();
            boolean hasLock = true;
            lock.lock();
            int state_0 = this.state_0_;
            int exclude = this.exclude_;
            try {
                if (exclude == 0) {
                    Assumption assumption0;
                    int count1_ = 0;
                    CachedData s1_ = this.cached_cache;
                    if ((state_0 & 1) != 0) {
                        while (s1_ != null && (arg0Value != s1_.cachedLibrary_ || !arg1Value.equals(s1_.cachedName_) || s1_.assumption0_ != null && !Assumption.isValidAssumption((Assumption)s1_.assumption0_))) {
                            s1_ = s1_.next_;
                            ++count1_;
                        }
                    }
                    if (s1_ == null && Assumption.isValidAssumption((Assumption)(assumption0 = LLVMNode.singleContextAssumption())) && count1_ < 3) {
                        s1_ = new CachedData(this.cached_cache);
                        s1_.cachedLibrary_ = arg0Value;
                        s1_.cachedName_ = arg1Value;
                        s1_.cachedDescriptor_ = SulongLibrary.LookupNode.lookupFunctionDescriptor(s1_.cachedLibrary_, s1_.cachedName_);
                        s1_.assumption0_ = assumption0;
                        this.cached_cache = s1_;
                        this.state_0_ = state_0 |= 1;
                    }
                    if (s1_ != null) {
                        lock.unlock();
                        hasLock = false;
                        LLVMFunctionDescriptor lLVMFunctionDescriptor = this.doCached(arg0Value, arg1Value, s1_.cachedLibrary_, s1_.cachedName_, s1_.cachedDescriptor_);
                        return lLVMFunctionDescriptor;
                    }
                }
                this.exclude_ = exclude |= 1;
                this.cached_cache = null;
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 2;
                lock.unlock();
                hasLock = false;
                LLVMFunctionDescriptor lLVMFunctionDescriptor = SulongLibrary.LookupNode.doGeneric(arg0Value, arg1Value);
                return lLVMFunctionDescriptor;
            }
            finally {
                if (hasLock) {
                    lock.unlock();
                }
            }
        }

        public NodeCost getCost() {
            CachedData s1_;
            int state_0 = this.state_0_;
            if (state_0 == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & state_0 - 1) == 0 && ((s1_ = this.cached_cache) == null || s1_.next_ == null)) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeCached_(Object s1_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                CachedData prev = null;
                CachedData cur = this.cached_cache;
                while (cur != null) {
                    if (cur == s1_) {
                        if (prev == null) {
                            this.cached_cache = cur.next_;
                            break;
                        }
                        prev.next_ = cur.next_;
                        break;
                    }
                    prev = cur;
                    cur = cur.next_;
                }
                if (this.cached_cache == null) {
                    this.state_0_ &= 0xFFFFFFFE;
                }
            }
            finally {
                lock.unlock();
            }
        }

        public static SulongLibrary.LookupNode create() {
            return new LookupNodeGen();
        }

        public static SulongLibrary.LookupNode getUncached() {
            return UNCACHED;
        }

        @GeneratedBy(value=SulongLibrary.LookupNode.class)
        private static final class Uncached
        extends SulongLibrary.LookupNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            LLVMFunctionDescriptor execute(SulongLibrary arg0Value, String arg1Value) {
                return SulongLibrary.LookupNode.doGeneric(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            public boolean isAdoptable() {
                return false;
            }
        }

        @GeneratedBy(value=SulongLibrary.LookupNode.class)
        private static final class CachedData {
            @CompilerDirectives.CompilationFinal
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            SulongLibrary cachedLibrary_;
            @CompilerDirectives.CompilationFinal
            String cachedName_;
            @CompilerDirectives.CompilationFinal
            LLVMFunctionDescriptor cachedDescriptor_;
            @CompilerDirectives.CompilationFinal
            Assumption assumption0_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }
        }
    }
}

