/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;

public abstract class LLVMSymbol {
    public static final LLVMSymbol[] EMPTY = new LLVMSymbol[0];
    private final String name;
    private final int moduleId;
    private final int symbolIndex;
    private final boolean exported;
    public static final int INVALID_INDEX = -1;
    public static final int INVALID_ID = -1;

    public LLVMSymbol(String name, int bitcodeID, int symbolIndex, boolean exported) {
        this.name = name;
        this.moduleId = bitcodeID;
        this.symbolIndex = symbolIndex;
        this.exported = exported;
    }

    public final String getName() {
        return this.name;
    }

    public final String getKind() {
        CompilerAsserts.neverPartOfCompilation();
        return this.getClass().getSimpleName();
    }

    public final boolean isExported() {
        return this.exported;
    }

    public final int getSymbolIndex(boolean illegalOK) {
        if (this.symbolIndex >= 0 || illegalOK) {
            return this.symbolIndex;
        }
        CompilerDirectives.transferToInterpreter();
        throw new LLVMIllegalSymbolIndexException("Invalid function index: " + this.symbolIndex);
    }

    public final int getBitcodeID(boolean illegalOK) {
        if (this.moduleId >= 0 || illegalOK) {
            return this.moduleId;
        }
        CompilerDirectives.transferToInterpreter();
        throw new LLVMIllegalSymbolIndexException("Invalid function ID: " + this.moduleId);
    }

    public final boolean hasValidIndexAndID() {
        return this.symbolIndex >= 0 && this.moduleId >= 0;
    }

    public abstract boolean isGlobalVariable();

    public abstract boolean isFunction();

    public abstract boolean isAlias();

    public abstract LLVMFunction asFunction();

    public abstract LLVMGlobal asGlobalVariable();
}

