/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Scope;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.debug.DebuggerTags;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProvidedTags;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExecutableNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFileDetector;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguageFactory;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;
import com.oracle.truffle.llvm.runtime.ToolchainImpl;
import com.oracle.truffle.llvm.runtime.config.Configuration;
import com.oracle.truffle.llvm.runtime.config.Configurations;
import com.oracle.truffle.llvm.runtime.config.LLVMCapability;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprExecutableNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr.DebugExprParser;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebuggerScopeFactory;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.collections.EconomicMap;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionValues;

@TruffleLanguage.Registration(id="llvm", name="LLVM", internal=false, interactive=false, defaultMimeType="application/x-llvm-ir-bitcode", byteMimeTypes={"application/x-llvm-ir-bitcode", "application/x-sharedlib", "application/x-executable", "application/x-mach-binary"}, fileTypeDetectors={LLVMFileDetector.class}, services={Toolchain.class}, version="10.0.0", contextPolicy=TruffleLanguage.ContextPolicy.SHARED)
@ProvidedTags(value={StandardTags.StatementTag.class, StandardTags.CallTag.class, StandardTags.RootTag.class, StandardTags.RootBodyTag.class, DebuggerTags.AlwaysHalt.class})
public class LLVMLanguage
extends TruffleLanguage<LLVMContext> {
    static final String LLVM_BITCODE_MIME_TYPE = "application/x-llvm-ir-bitcode";
    static final String LLVM_BITCODE_EXTENSION = "bc";
    static final String LLVM_ELF_SHARED_MIME_TYPE = "application/x-sharedlib";
    static final String LLVM_ELF_EXEC_MIME_TYPE = "application/x-executable";
    static final String LLVM_ELF_LINUX_EXTENSION = "so";
    static final String LLVM_MACHO_MIME_TYPE = "application/x-mach-binary";
    static final String MAIN_ARGS_KEY = "Sulong Main Args";
    static final String PARSE_ONLY_KEY = "Parse only";
    public static final String ID = "llvm";
    static final String NAME = "LLVM";
    private final AtomicInteger nextID = new AtomicInteger(0);
    public final Assumption singleContextAssumption = Truffle.getRuntime().createAssumption("Only a single context is active");
    @CompilerDirectives.CompilationFinal
    private Configuration activeConfiguration = null;
    private ContextExtensionKey<?>[] contextExtensions;
    @CompilerDirectives.CompilationFinal
    private LLVMMemory cachedLLVMMemory;
    private final EconomicMap<String, LLVMScope> internalFileScopes = EconomicMap.create();
    private final EconomicMap<String, CallTarget> libraryCache = EconomicMap.create();
    private final Object libraryCacheLock = new Object();
    private final EconomicMap<String, Source> librarySources = EconomicMap.create();
    private final LLDBSupport lldbSupport = new LLDBSupport(this);
    private final Assumption noCommonHandleAssumption = Truffle.getRuntime().createAssumption("no common handle");
    private final Assumption noDerefHandleAssumption = Truffle.getRuntime().createAssumption("no deref handle");
    private final LLVMInteropType.InteropTypeRegistry interopTypeRegistry = new LLVMInteropType.InteropTypeRegistry();
    @CompilerDirectives.CompilationFinal
    private LLVMFunctionCode sulongInitContextCode;
    @CompilerDirectives.CompilationFinal
    private LLVMFunction sulongDisposeContext;
    @CompilerDirectives.CompilationFinal
    private LLVMFunctionCode startFunctionCode;
    private CallTarget freeGlobalBlocks;

    public LLVMLanguage() {
        this.noCommonHandleAssumption.isValid();
    }

    protected void initializeContext(LLVMContext context) {
        ContextExtension[] ctxExts = new ContextExtension[this.contextExtensions.length];
        for (int i = 0; i < this.contextExtensions.length; ++i) {
            ContextExtensionKey<?> key = this.contextExtensions[i];
            Object ext = ((ContextExtensionKey)key).factory.create(context.getEnv());
            ctxExts[i] = (ContextExtension)((ContextExtensionKey)key).clazz.cast(ext);
        }
        context.initialize(ctxExts);
    }

    public static LLVMContext getContext() {
        CompilerAsserts.neverPartOfCompilation((String)"Use faster context lookup methods for the fast-path.");
        return (LLVMContext)LLVMLanguage.getCurrentContext(LLVMLanguage.class);
    }

    public static LLVMLanguage getLanguage() {
        return (LLVMLanguage)LLVMLanguage.getCurrentLanguage(LLVMLanguage.class);
    }

    public static LLDBSupport getLLDBSupport() {
        return LLVMLanguage.getLanguage().lldbSupport;
    }

    public <C extends LLVMCapability> C getCapability(Class<C> type) {
        CompilerAsserts.partialEvaluationConstant(type);
        if (type == LLVMMemory.class) {
            return (C)((LLVMCapability)type.cast(this.getLLVMMemory()));
        }
        C ret = this.activeConfiguration.getCapability(type);
        if (CompilerDirectives.isPartialEvaluationConstant((Object)((Object)this))) {
            CompilerAsserts.partialEvaluationConstant(ret);
        }
        return ret;
    }

    public Assumption getNoCommonHandleAssumption() {
        return this.noCommonHandleAssumption;
    }

    public Assumption getNoDerefHandleAssumption() {
        return this.noDerefHandleAssumption;
    }

    public final String getLLVMLanguageHome() {
        return this.getLanguageHome();
    }

    public Configuration getActiveConfiguration() {
        if (this.activeConfiguration != null) {
            return this.activeConfiguration;
        }
        throw new IllegalStateException("No context, please create the context before accessing the configuration.");
    }

    public LLVMMemory getLLVMMemory() {
        assert (this.cachedLLVMMemory != null);
        return this.cachedLLVMMemory;
    }

    public LLVMScope getInternalFileScopes(String libraryName) {
        return (LLVMScope)this.internalFileScopes.get((Object)libraryName);
    }

    public void addInternalFileScope(String libraryName, LLVMScope scope) {
        this.internalFileScopes.put((Object)libraryName, (Object)scope);
    }

    public Source getLibrarySource(String path) {
        return (Source)this.librarySources.get((Object)path);
    }

    public void addLibrarySource(String path, Source source) {
        this.librarySources.put((Object)path, (Object)source);
    }

    public boolean containsLibrarySource(String path) {
        return this.librarySources.containsKey((Object)path);
    }

    protected LLVMContext createContext(TruffleLanguage.Env env) {
        if (this.activeConfiguration == null) {
            final ArrayList ctxExts = new ArrayList();
            ContextExtension.Registry r = new ContextExtension.Registry(){
                private int count;

                @Override
                public <C extends ContextExtension> ContextExtension.Key<C> register(Class<C> type, ContextExtension.Factory<C> factory) {
                    ContextExtensionKey<C> key = new ContextExtensionKey<C>(type, this.count++, factory);
                    ctxExts.add(key);
                    assert (this.count == ctxExts.size());
                    return key;
                }
            };
            this.activeConfiguration = Configurations.createConfiguration(this, r, env.getOptions());
            this.cachedLLVMMemory = this.activeConfiguration.getCapability(LLVMMemory.class);
            this.contextExtensions = ctxExts.toArray(ContextExtensionKey.EMPTY);
        }
        ToolchainImpl toolchain = new ToolchainImpl(this.activeConfiguration.getCapability(ToolchainConfig.class), this);
        env.registerService((Object)toolchain);
        LLVMContext context = new LLVMContext(this, env, toolchain);
        return context;
    }

    public <C extends ContextExtension> ContextExtension.Key<C> lookupContextExtension(Class<C> type) {
        CompilerAsserts.neverPartOfCompilation();
        for (ContextExtensionKey<?> key : this.contextExtensions) {
            if (type != ((ContextExtensionKey)key).clazz) continue;
            return ((ContextExtensionKey)key).cast(type);
        }
        return null;
    }

    protected ExecutableNode parse(TruffleLanguage.InlineParsingRequest request) {
        Object globalScope = this.getScope((LLVMContext)LLVMLanguage.getCurrentContext(LLVMLanguage.class));
        DebugExprParser d = new DebugExprParser(request, globalScope, (LLVMContext)LLVMLanguage.getCurrentContext(LLVMLanguage.class));
        try {
            return new DebugExprExecutableNode(d.parse());
        }
        catch (DebugExprException | LLVMParserException e) {
            final String errorMessage = ((Throwable)e).getMessage();
            return new ExecutableNode(this){

                public Object execute(VirtualFrame frame) {
                    return errorMessage;
                }
            };
        }
    }

    protected boolean patchContext(LLVMContext context, TruffleLanguage.Env newEnv) {
        boolean compatible = Configurations.areOptionsCompatible(context.getEnv().getOptions(), newEnv.getOptions());
        if (!compatible) {
            return false;
        }
        return context.patchContext(newEnv);
    }

    protected boolean areOptionsCompatible(OptionValues firstOptions, OptionValues newOptions) {
        return Configurations.areOptionsCompatible(firstOptions, newOptions);
    }

    protected void finalizeContext(LLVMContext context) {
        context.finalizeContext(this.sulongDisposeContext);
    }

    protected void disposeContext(LLVMContext context) {
        LLVMMemory memory = this.getLLVMMemory();
        context.dispose(memory);
    }

    public void setSulongInitContext(LLVMFunction function) {
        this.sulongInitContextCode = new LLVMFunctionCode(function);
    }

    public void setSulongDisposeContext(LLVMFunction function) {
        this.sulongDisposeContext = function;
    }

    public void setStartFunctionCode(LLVMFunctionCode startFunctionCode) {
        this.startFunctionCode = startFunctionCode;
    }

    public LLVMFunctionCode getStartFunctionCode() {
        assert (this.startFunctionCode != null);
        return this.startFunctionCode;
    }

    protected void initFreeGlobalBlocks(NodeFactory nodeFactory) {
        if (this.freeGlobalBlocks == null) {
            this.freeGlobalBlocks = Truffle.getRuntime().createCallTarget((RootNode)new FreeGlobalsNode(this, nodeFactory));
        }
    }

    public CallTarget getFreeGlobalBlocks() {
        return this.freeGlobalBlocks;
    }

    public AtomicInteger getRawRunnerID() {
        return this.nextID;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMInteropType getInteropType(LLVMSourceType sourceType) {
        return this.interopTypeRegistry.get(sourceType);
    }

    public LLVMStatementNode createInitializeContextNode() {
        if (this.sulongInitContextCode == null) {
            throw new IllegalStateException("Context cannot be initialized:__sulong_init_context was not found");
        }
        return LLVMLanguageFactory.InitializeContextNodeGen.create(this.sulongInitContextCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CallTarget parse(TruffleLanguage.ParsingRequest request) {
        Object object = this.libraryCacheLock;
        synchronized (object) {
            Source source = request.getSource();
            String path = source.getPath();
            if (source.isCached()) {
                CallTarget prev;
                CallTarget callTarget = (CallTarget)this.libraryCache.get((Object)path);
                if (callTarget == null && (prev = (CallTarget)this.libraryCache.putIfAbsent((Object)path, (Object)(callTarget = this.getCapability(Loader.class).load(LLVMLanguage.getContext(), source, this.nextID)))) != null) {
                    callTarget = prev;
                }
                return callTarget;
            }
            return this.getCapability(Loader.class).load(LLVMLanguage.getContext(), source, this.nextID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLibraryCached(String path) {
        Object object = this.libraryCacheLock;
        synchronized (object) {
            return this.libraryCache.get((Object)path) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CallTarget getCachedLibrary(String path) {
        Object object = this.libraryCacheLock;
        synchronized (object) {
            return (CallTarget)this.libraryCache.get((Object)path);
        }
    }

    protected Object getScope(LLVMContext context) {
        return context.getGlobalScope();
    }

    protected OptionDescriptors getOptionDescriptors() {
        return Configurations.getOptionDescriptors();
    }

    protected boolean isThreadAccessAllowed(Thread thread, boolean singleThreaded) {
        return true;
    }

    protected void disposeThread(LLVMContext context, Thread thread) {
        super.disposeThread((Object)context, thread);
        if (context.isInitialized()) {
            context.getThreadingStack().freeStack(this.getLLVMMemory(), thread);
        }
    }

    protected Iterable<Scope> findLocalScopes(LLVMContext context, Node node, Frame frame) {
        if (((Boolean)context.getEnv().getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
            return LLVMDebuggerScopeFactory.createIRLevelScope(node, frame, context);
        }
        return LLVMDebuggerScopeFactory.createSourceLevelScope(node, frame, context);
    }

    protected void initializeMultipleContexts() {
        super.initializeMultipleContexts();
        this.singleContextAssumption.invalidate();
    }

    static abstract class InitializeContextNode
    extends LLVMStatementNode {
        @CompilerDirectives.CompilationFinal
        private TruffleLanguage.ContextReference<LLVMContext> ctxRef;
        @Node.Child
        private DirectCallNode initContext;

        InitializeContextNode(LLVMFunctionCode initContextFunctionCode) {
            RootCallTarget initContextFunction = initContextFunctionCode.getLLVMIRFunctionSlowPath();
            this.initContext = DirectCallNode.create((CallTarget)initContextFunction);
        }

        @Specialization
        public void doInit() {
            if (this.ctxRef == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ctxRef = this.lookupContextReference(LLVMLanguage.class);
            }
            LLVMContext ctx = (LLVMContext)this.ctxRef.get();
            if (!ctx.initialized) {
                assert (!ctx.cleanupNecessary);
                ctx.initialized = true;
                ctx.cleanupNecessary = true;
                Object[] args = new Object[]{ctx.getThreadingStack().getStack(), ctx.getApplicationArguments(), LLVMContext.getEnvironmentVariables(), LLVMContext.getRandomValues()};
                this.initContext.call(args);
            }
        }
    }

    static class FreeGlobalsNode
    extends RootNode {
        @Node.Child
        LLVMMemoryOpNode freeRo;
        @Node.Child
        LLVMMemoryOpNode freeRw;
        final TruffleLanguage.ContextReference<LLVMContext> ctx = this.lookupContextReference(LLVMLanguage.class);

        FreeGlobalsNode(LLVMLanguage language, NodeFactory nodeFactory) {
            super((TruffleLanguage)language);
            this.freeRo = nodeFactory.createFreeGlobalsBlock(true);
            this.freeRw = nodeFactory.createFreeGlobalsBlock(false);
        }

        public Object execute(VirtualFrame frame) {
            LLVMContext context = (LLVMContext)this.ctx.get();
            for (LLVMPointer store : context.globalsReadOnlyStore.getValues()) {
                if (store == null) continue;
                this.freeRo.execute(store);
            }
            for (int i = 0; i < context.globalsNonPointerStore.size(); ++i) {
                LLVMPointer store;
                store = FreeGlobalsNode.getElement(context.globalsNonPointerStore, i);
                if (store == null) continue;
                this.freeRw.execute(store);
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static LLVMPointer getElement(ArrayList<LLVMPointer> list, int idx) {
            return list.get(idx);
        }
    }

    public static abstract class Loader
    implements LLVMCapability {
        public abstract CallTarget load(LLVMContext var1, Source var2, AtomicInteger var3);
    }

    private static final class ContextExtensionKey<C extends ContextExtension>
    extends ContextExtension.Key<C> {
        private static final ContextExtensionKey<?>[] EMPTY = new ContextExtensionKey[0];
        private final Class<? extends C> clazz;
        private final int index;
        private final ContextExtension.Factory<C> factory;

        ContextExtensionKey(Class<C> clazz, int index, ContextExtension.Factory<C> factory) {
            this.clazz = clazz;
            this.index = index;
            this.factory = factory;
        }

        @Override
        public C get(LLVMContext ctx) {
            CompilerAsserts.compilationConstant(this.clazz);
            return (C)((ContextExtension)this.clazz.cast(ctx.getContextExtension(this.index)));
        }

        private <U extends ContextExtension> ContextExtensionKey<U> cast(Class<U> target) {
            Class<U> c = this.clazz.asSubclass(target);
            assert (c == this.clazz);
            return this;
        }
    }
}

