/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

public final class LLVMFunction
extends LLVMSymbol {
    public static final LLVMFunction[] EMPTY = new LLVMFunction[0];
    private final FunctionType type;
    private final LLVMFunctionCode.Function function;
    private final String path;
    private final Assumption fixedCodeAssumption = Truffle.getRuntime().createAssumption();
    @CompilerDirectives.CompilationFinal
    private LLVMFunctionCode fixedCode;

    public static LLVMFunction create(String name, LLVMFunctionCode.Function function, FunctionType type, int bitcodeID, int symbolIndex, boolean exported, String path) {
        return new LLVMFunction(name, function, type, bitcodeID, symbolIndex, exported, path);
    }

    public LLVMFunction(String name, LLVMFunctionCode.Function function, FunctionType type, int bitcodeID, int symbolIndex, boolean exported, String path) {
        super(name, bitcodeID, symbolIndex, exported);
        this.type = type;
        this.function = function;
        this.path = path;
    }

    public String getStringPath() {
        return this.path;
    }

    public FunctionType getType() {
        return this.type;
    }

    public LLVMFunctionCode.Function getFunction() {
        return this.function;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public boolean isGlobalVariable() {
        return false;
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public LLVMFunction asFunction() {
        return this;
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        throw new IllegalStateException("Function " + this.getName() + " is not a global variable.");
    }

    public Assumption getFixedCodeAssumption() {
        return this.fixedCodeAssumption;
    }

    public LLVMFunctionCode getFixedCode() {
        return this.fixedCode;
    }

    public void setValue(LLVMPointer pointer) {
        if (this.fixedCodeAssumption.isValid()) {
            Object value;
            if (LLVMManagedPointer.isInstance(pointer) && (value = LLVMManagedPointer.cast(pointer).getObject()) instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor descriptor = (LLVMFunctionDescriptor)value;
                LLVMFunctionCode code = descriptor.getFunctionCode();
                if (this.fixedCode == null) {
                    this.fixedCode = code;
                    return;
                }
                if (this.fixedCode == code) {
                    return;
                }
            }
            this.fixedCode = null;
            this.fixedCodeAssumption.invalidate();
        }
    }
}

