/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.profiles.BranchProfile;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMArgumentBuffer
implements TruffleObject {
    private final byte[] bytes;

    public LLVMArgumentBuffer(String str) {
        this.bytes = LLVMArgumentBuffer.encodeFromString(str);
    }

    public LLVMArgumentBuffer(byte[] bytes) {
        this.bytes = bytes;
    }

    @ExportMessage
    boolean hasArrayElements() {
        assert (this.bytes != null);
        return true;
    }

    @ExportMessage
    long getArraySize() {
        return this.bytes.length;
    }

    @ExportMessage
    boolean isArrayElementReadable(long idx) {
        return Long.compareUnsigned(idx, this.bytes.length) < 0;
    }

    @ExportMessage
    byte readArrayElement(long idx, @Cached BranchProfile oob) {
        if (this.isArrayElementReadable(idx)) {
            return this.bytes[(int)idx];
        }
        oob.enter();
        return 0;
    }

    @ExportMessage
    boolean isString() {
        return true;
    }

    @ExportMessage
    String asString() {
        return LLVMArgumentBuffer.decodeToString(this.bytes);
    }

    @CompilerDirectives.TruffleBoundary
    private static String decodeToString(byte[] bytes) {
        return new String(bytes);
    }

    @CompilerDirectives.TruffleBoundary
    protected static byte[] encodeFromString(String str) {
        return str.getBytes();
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class LLVMArgumentArray
    implements TruffleObject {
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final LLVMArgumentBuffer[] args;

        LLVMArgumentArray(LLVMArgumentBuffer[] args) {
            this.args = args;
        }

        @ExportMessage
        boolean hasArrayElements() {
            assert (this.args != null);
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.args.length;
        }

        @ExportMessage
        boolean isArrayElementReadable(long idx) {
            return Long.compareUnsigned(idx, this.args.length) < 0;
        }

        @ExportMessage
        Object readArrayElement(long idx, @Cached BranchProfile exception) {
            if (this.isArrayElementReadable(idx)) {
                return this.args[(int)idx];
            }
            exception.enter();
            return InvalidArrayIndexException.create((long)idx);
        }
    }
}

