/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.util;

import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class LLVMControlFlowGraph {
    private CFGBlock[] blocks;
    private List<CFGLoop> cfgLoops;
    private int nextLoop = 0;
    private boolean reducible = true;

    public LLVMControlFlowGraph(InstructionBlock[] blocks) {
        this.blocks = new CFGBlock[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            this.blocks[i] = new CFGBlock(blocks[i]);
        }
        this.cfgLoops = new ArrayList<CFGLoop>();
    }

    private void resolveEdges() {
        for (CFGBlock block : this.blocks) {
            TerminatingInstruction term = block.instructionBlock.getTerminatingInstruction();
            for (int i = 0; i < term.getSuccessorCount(); ++i) {
                int sucId = term.getSuccessor(i).getBlockIndex();
                block.sucs.add(this.blocks[sucId]);
                this.blocks[sucId].preds.add(block);
            }
        }
    }

    public List<CFGLoop> getCFGLoops() {
        return this.cfgLoops;
    }

    public boolean isReducible() {
        return this.reducible;
    }

    public void build() {
        this.reducible = true;
        this.resolveEdges();
        if (!this.openLoops(this.blocks[0]).isEmpty()) {
            this.reducible = false;
            return;
        }
        try {
            this.sortLoops();
        }
        catch (ControlFlowBailoutException e) {
            this.reducible = false;
            return;
        }
        for (CFGLoop l : this.getCFGLoops()) {
            l.calculateSuccessors();
        }
    }

    private boolean sortLoops() throws ControlFlowBailoutException {
        ArrayList<CFGLoop> sorted = new ArrayList<CFGLoop>();
        ArrayList<CFGLoop> active = new ArrayList<CFGLoop>();
        for (CFGLoop l : this.getCFGLoops()) {
            this.sortLoop(sorted, active, l);
        }
        this.cfgLoops = sorted;
        return true;
    }

    private void sortLoop(List<CFGLoop> sorted, List<CFGLoop> active, CFGLoop loop) throws ControlFlowBailoutException {
        if (sorted.contains(loop)) {
            return;
        }
        active.add(loop);
        for (CFGBlock b : loop.body) {
            if (!b.isLoopHeader) continue;
            CFGLoop inner = this.cfgLoops.get(b.loopId);
            if (active.contains(inner)) {
                throw new ControlFlowBailoutException("Irreducible nestedness!");
            }
            this.sortLoop(sorted, active, inner);
            loop.innerLoops.add(inner);
        }
        loop.body.sort(new Comparator<CFGBlock>(){

            @Override
            public int compare(CFGBlock o1, CFGBlock o2) {
                return o2.id - o1.id;
            }
        });
        sorted.add(loop);
        active.remove(loop);
    }

    private BitSet openLoops(CFGBlock block) {
        if (block.visited) {
            if (block.active) {
                this.makeLoopHeader(block);
                return block.loops;
            }
            if (block.isLoopHeader) {
                BitSet outerLoops = new BitSet();
                outerLoops.or(block.loops);
                outerLoops.clear(block.loopId);
                return outerLoops;
            }
            return block.loops;
        }
        block.visited = true;
        block.active = true;
        BitSet loops = new BitSet();
        for (CFGBlock successor : block.sucs) {
            loops.or(this.openLoops(successor));
            if (!successor.active) continue;
            loops.set(successor.loopId);
        }
        block.loops = loops;
        if (block.isLoopHeader) {
            loops.clear(block.loopId);
        }
        block.active = false;
        for (int i = 0; i < this.nextLoop; ++i) {
            if (!loops.get(i)) continue;
            this.cfgLoops.get(i).body.add(block);
        }
        return loops;
    }

    private void makeLoopHeader(CFGBlock block) {
        if (!block.isLoopHeader) {
            block.isLoopHeader = true;
            assert (block.loops.isEmpty());
            block.loops.set(this.nextLoop);
            this.cfgLoops.add(new CFGLoop(this.nextLoop));
            this.cfgLoops.get(this.nextLoop).loopHeader = block;
            block.loopId = this.nextLoop++;
        }
        assert (block.loops.cardinality() == 1);
    }

    private class ControlFlowBailoutException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ControlFlowBailoutException(String string) {
            super(string);
        }
    }

    public final class CFGLoop {
        private CFGBlock loopHeader;
        private List<CFGBlock> body;
        private List<CFGLoop> innerLoops;
        private Set<CFGBlock> successors;
        private final int id;

        public CFGLoop(int id) {
            this.id = id;
            this.body = new ArrayList<CFGBlock>();
            this.innerLoops = new ArrayList<CFGLoop>();
        }

        public List<CFGBlock> getBody() {
            return this.body;
        }

        public List<CFGLoop> getInnerLoops() {
            return this.innerLoops;
        }

        public Set<CFGBlock> getSuccessors() {
            if (this.successors == null) {
                this.calculateSuccessors();
            }
            return this.successors;
        }

        private void calculateSuccessors() {
            this.successors = new HashSet<CFGBlock>();
            for (CFGBlock s : this.loopHeader.sucs) {
                if (this.isInLoop(s)) continue;
                this.successors.add(s);
            }
            for (CFGBlock b : this.body) {
                if (b.isLoopHeader) {
                    for (CFGLoop l : this.innerLoops) {
                        if (!l.getHeader().equals(b)) continue;
                        for (CFGBlock ib : l.getSuccessors()) {
                            if (this.isInLoop(ib)) continue;
                            this.successors.add(ib);
                        }
                    }
                    continue;
                }
                for (CFGBlock s : b.sucs) {
                    if (this.isInLoop(s)) continue;
                    this.successors.add(s);
                }
            }
        }

        public int[] getSuccessorIDs() {
            if (this.successors == null) {
                this.calculateSuccessors();
            }
            int[] sucIDs = new int[this.successors.size()];
            int i = 0;
            for (CFGBlock b : this.successors) {
                sucIDs[i++] = b.id;
            }
            return sucIDs;
        }

        public boolean isInLoop(CFGBlock block) {
            return block == this.loopHeader || this.body.contains(block);
        }

        public CFGBlock getHeader() {
            return this.loopHeader;
        }

        public String toString() {
            return "Loop: " + this.id + " - Header: " + this.loopHeader.toString();
        }
    }

    public final class CFGBlock {
        private final InstructionBlock instructionBlock;
        public int id;
        public List<CFGBlock> sucs = new ArrayList<CFGBlock>();
        public List<CFGBlock> preds = new ArrayList<CFGBlock>();
        public boolean visited = false;
        public boolean active = false;
        public boolean isLoopHeader = false;
        public BitSet loops;
        public int loopId;

        public CFGBlock(InstructionBlock block) {
            this.instructionBlock = block;
            this.id = block.getBlockIndex();
            this.loops = new BitSet(64);
        }

        public String toString() {
            return this.instructionBlock.toString();
        }
    }
}

