/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.text;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.text.LLSourceMap;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceFileReference;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.options.TargetStream;
import com.oracle.truffle.llvm.runtime.types.symbols.LLVMIdentifier;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

final class LLScanner {
    static final LLSourceMap NOT_FOUND = new LLSourceMap(null);
    private final LLSourceMap map;
    private int currentLine;
    private LLSourceMap.Function function;
    private final EconomicSet<LLVMSourceFileReference> sourceFileReferences;
    private static final Pattern DIFILE_PATTERN = Pattern.compile("!\\d+ = !DIFile\\((?:filename: \"([^\"]*)\", )?(?:directory: \"([^\"]*)\", )?(?:checksumkind: (.*), )?checksum: \"(\\w+)\"\\)");
    private static final Pattern FUNCTION_NAME_REGEX = Pattern.compile("define .* @((?<functionNameUnquoted>[^\\s(\"]+)|\"(?<functionNameQuoted>[^\"]+)\")\\(.*");
    private static final Pattern VALUE_NAME_REGEX = Pattern.compile("\\s*\"?(?<instructionName>\\S+)\"? .*");
    private static final Pattern OP_NAME_REGEX = Pattern.compile("\\s*(?<instructionName>\\S+).*");
    private static final Pattern GLOBAL_NAME_REGEX = Pattern.compile("@\"?(?<globalName>\\S+)\"? =.*");

    private static TruffleFile findMapping(Path canonicalBCPath, String pathMappings, LLVMContext context) {
        String[] mappings;
        if (pathMappings.isEmpty()) {
            return null;
        }
        for (String mapping : mappings = pathMappings.split(":")) {
            String[] splittedMapping = mapping.split("=");
            if (splittedMapping.length != 2) {
                throw new LLVMParserException("Malformed path mapping for *.ll files: " + pathMappings);
            }
            Path mappedBCFile = Paths.get(splittedMapping[0], new String[0]).normalize().toAbsolutePath();
            if (!mappedBCFile.equals(canonicalBCPath)) continue;
            Path mappedLLFile = Paths.get(splittedMapping[1], new String[0]).normalize().toAbsolutePath();
            return context.getEnv().getInternalTruffleFile(mappedLLFile.toUri());
        }
        return null;
    }

    private static TruffleFile findLLPathMapping(String bcPath, String pathMappings, LLVMContext context) {
        if (bcPath == null) {
            return null;
        }
        Path canonicalBCPath = Paths.get(bcPath, new String[0]).normalize().toAbsolutePath();
        TruffleFile mappedFile = LLScanner.findMapping(canonicalBCPath, pathMappings, context);
        if (mappedFile != null) {
            return mappedFile;
        }
        return context.getEnv().getInternalTruffleFile(LLScanner.getLLPath(canonicalBCPath.toString()));
    }

    private static String getLLPath(String canonicalBCPath) {
        if (canonicalBCPath.endsWith(".bc")) {
            return canonicalBCPath.substring(0, canonicalBCPath.length() - ".bc".length()) + ".ll";
        }
        return canonicalBCPath + ".ll";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LLSourceMap findAndScanLLFile(String bcPath, String pathMappings, LLVMContext context, List<LLVMSourceFileReference> sourceFileReferences) {
        if (bcPath == null) {
            return NOT_FOUND;
        }
        TruffleFile llFile = LLScanner.findLLPathMapping(bcPath, pathMappings, context);
        if (llFile == null || !llFile.exists(new LinkOption[0]) || !llFile.isReadable()) {
            LLScanner.printWarning(context, "Cannot find .ll file for %s (set %s to \"false\" to disable this message)\n", bcPath, "llvm.llDebug.verbose");
            return NOT_FOUND;
        }
        try (BufferedReader llReader = llFile.newBufferedReader();){
            Source llSource = Source.newBuilder((String)"llvm", (TruffleFile)llFile).mimeType("text/x-llvmir").build();
            LLSourceMap sourceMap = new LLSourceMap(llSource);
            EconomicSet<LLVMSourceFileReference> sourceFileWorkset = LLScanner.createSourceFileSet(sourceFileReferences);
            if (sourceFileWorkset == null) {
                LLScanner.printWarning(context, "No source file checksums found in %s\n", bcPath);
            }
            LLScanner scanner = new LLScanner(sourceMap, sourceFileWorkset);
            String line = llReader.readLine();
            while (line != null && scanner.continueAfter(line)) {
                line = llReader.readLine();
            }
            if (sourceFileWorkset != null && !sourceFileWorkset.isEmpty()) {
                LLScanner.printWarning(context, "Checksums in the .ll file (%s) and the .bc file (%s) do not match!\n", llFile, bcPath);
                LLScanner.printWarning(context, "The following files have changed in the .bc file:\n", new Object[0]);
                for (LLVMSourceFileReference sourceFileReference : sourceFileWorkset) {
                    LLScanner.printWarning(context, "  %s\n", LLVMSourceFileReference.toString(sourceFileReference));
                }
            }
            LLSourceMap lLSourceMap = sourceMap;
            return lLSourceMap;
        }
        catch (IOException e) {
            throw new LLVMParserException("Error while reading from file: " + llFile.getPath());
        }
    }

    private static void printWarning(LLVMContext context, String format, Object ... args) {
        TargetStream stream = context.llDebugVerboseStream();
        if (stream != null) {
            stream.format(format, args);
        }
    }

    private static EconomicSet<LLVMSourceFileReference> createSourceFileSet(List<LLVMSourceFileReference> sourceFileReferences) {
        if (sourceFileReferences == null || sourceFileReferences.isEmpty()) {
            return null;
        }
        EconomicSet units = EconomicSet.create((Equivalence)LLVMSourceFileReference.EQUIVALENCE);
        units.addAll(sourceFileReferences);
        return units;
    }

    private LLScanner(LLSourceMap map, EconomicSet<LLVMSourceFileReference> sourceFileReferences) {
        this.map = map;
        this.currentLine = 0;
        this.function = null;
        this.sourceFileReferences = sourceFileReferences;
    }

    private boolean continueAfter(String line) {
        ++this.currentLine;
        if (line.isEmpty() || line.charAt(0) == ';') {
            return true;
        }
        if (line.startsWith("define")) {
            this.beginFunction(line);
        } else if (line.startsWith("}")) {
            this.endFunction();
        } else if (this.function != null) {
            this.parseInstruction(line);
        } else if (line.startsWith("@")) {
            this.parseGlobal(line);
        } else if (this.sourceFileReferences == null) {
            if (line.startsWith("!0")) {
                return false;
            }
        } else {
            Matcher matcher = DIFILE_PATTERN.matcher(line);
            if (matcher.matches()) {
                String filename = matcher.group(1);
                String directory = matcher.group(2);
                String checksumKind = matcher.group(3);
                String checksum = matcher.group(4);
                LLVMSourceFileReference unit = LLVMSourceFileReference.create(filename, directory, checksumKind, checksum);
                this.sourceFileReferences.remove((Object)unit);
                if (this.sourceFileReferences.isEmpty()) {
                    return false;
                }
            }
        }
        return true;
    }

    private void beginFunction(String line) {
        String functionName;
        assert (this.function == null);
        Matcher matcher = FUNCTION_NAME_REGEX.matcher(line);
        if (matcher.matches()) {
            functionName = matcher.group("functionNameUnquoted");
            if (functionName == null) {
                functionName = matcher.group("functionNameQuoted");
            }
        } else {
            throw new LLVMParserException(this.getErrorMessage("function", line));
        }
        functionName = LLVMIdentifier.toGlobalIdentifier(functionName);
        this.function = new LLSourceMap.Function(functionName, this.currentLine);
        this.map.registerFunction(functionName, this.function);
    }

    private void parseInstruction(String line) {
        assert (this.function != null);
        String id = null;
        Matcher matcher = VALUE_NAME_REGEX.matcher(line);
        if (matcher.matches()) {
            id = matcher.group("instructionName");
            id = LLVMIdentifier.toLocalIdentifier(id);
        }
        if ((matcher = OP_NAME_REGEX.matcher(line)).matches()) {
            id = matcher.group("instructionName");
        }
        if (id == null) {
            throw new LLVMParserException(this.getErrorMessage("instruction", line));
        }
        this.function.add(id, this.currentLine);
    }

    private void endFunction() {
        assert (this.function != null);
        this.function.setEndLine(this.currentLine);
        this.function = null;
    }

    private void parseGlobal(String line) {
        Matcher matcher = GLOBAL_NAME_REGEX.matcher(line);
        if (!matcher.matches()) {
            throw new LLVMParserException(this.getErrorMessage("global", line));
        }
        String globalName = matcher.group("globalName");
        globalName = LLVMIdentifier.toGlobalIdentifier(globalName);
        this.map.registerGlobal(globalName);
    }

    private String getErrorMessage(String parsing, String line) {
        return String.format("Could not parse %s name in *.ll file: line %d: >>%s<<", parsing, this.currentLine, line);
    }
}

