/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class ExtractValueInstruction
extends ValueInstruction {
    private SymbolImpl aggregate;
    private final int index;

    private ExtractValueInstruction(Type type, int index) {
        super(type);
        this.index = index;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl getAggregate() {
        return this.aggregate;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.aggregate == original) {
            this.aggregate = replacement;
        }
    }

    public static ExtractValueInstruction create(SymbolImpl aggreggate, Type type, int index) {
        ExtractValueInstruction inst = new ExtractValueInstruction(type, index);
        inst.aggregate = aggreggate;
        return inst;
    }

    public static ExtractValueInstruction fromSymbols(SymbolTable symbols, Type type, int aggregate, int index) {
        ExtractValueInstruction inst = new ExtractValueInstruction(type, index);
        inst.aggregate = symbols.getForwardReferenced(aggregate, inst);
        return inst;
    }
}

