/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.functions;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.enums.Linkage;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

public final class FunctionDeclaration
extends FunctionSymbol
implements Constant {
    public FunctionDeclaration(FunctionType type, String name, Linkage linkage, AttributesCodeEntry paramAttr, int index) {
        super(type, name, linkage, paramAttr, index);
    }

    public FunctionDeclaration(FunctionType type, Linkage linkage, AttributesCodeEntry paramAttr, int index) {
        this(type, "<anon>", linkage, paramAttr, index);
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("%s %s ;", this.getType(), this.getName());
    }

    @Override
    public boolean isExported() {
        return true;
    }

    @Override
    public boolean isOverridable() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        LLVMFunction value = runtime.lookupFunction(this.getName());
        return CommonNodeFactory.createLiteral(value, this.getType());
    }
}

