/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDNamedLocation;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDTemplateTypeParameter
extends MDNamedLocation
implements MDBaseNode {
    private final long column;
    private MDBaseNode baseType;
    private static final int ARGINDEX_SCOPE = 1;
    private static final int ARGINDEX_NAME = 2;
    private static final int ARGINDEX_TYPE = 3;
    private static final int ARGINDEX_FILE = 4;
    private static final int ARGINDEX_LINE = 5;
    private static final int ARGINDEX_COLUMN = 6;

    private MDTemplateTypeParameter(long line, long column) {
        super(line);
        this.column = column;
        this.baseType = MDVoidNode.INSTANCE;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public MDBaseNode getBaseType() {
        return this.baseType;
    }

    public long getColumn() {
        return this.column;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.baseType == oldValue) {
            this.baseType = newValue;
        }
    }

    public static MDTemplateTypeParameter create32(long[] args, Metadata md) {
        long line = ParseUtil.asLong(args, 5, md);
        long column = ParseUtil.asLong(args, 6, md);
        MDTemplateTypeParameter parameter = new MDTemplateTypeParameter(line, column);
        parameter.setScope(ParseUtil.resolveReference(args, 1, parameter, md));
        parameter.baseType = ParseUtil.resolveReference(args, 3, parameter, md);
        parameter.setFile(ParseUtil.resolveReference(args, 4, parameter, md));
        parameter.setName(ParseUtil.resolveReference(args, 2, parameter, md));
        return parameter;
    }
}

