/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDNamedLocation;
import com.oracle.truffle.llvm.parser.metadata.MDVoidNode;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;

public final class MDCommonBlock
extends MDNamedLocation
implements MDBaseNode {
    private MDBaseNode declaration = MDVoidNode.INSTANCE;
    private static final int ARGINDEX_SCOPE = 1;
    private static final int ARGINDEX_DECLARATION = 2;
    private static final int ARGINDEX_NAME = 3;
    private static final int ARGINDEX_FILE = 4;
    private static final int ARGINDEX_LINE = 5;

    private MDCommonBlock(long line) {
        super(line);
    }

    public MDBaseNode getDeclaration() {
        return this.declaration;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
        if (this.declaration == oldValue) {
            this.declaration = newValue;
        }
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public static MDCommonBlock create(long[] args, MetadataValueList md) {
        long line = args[5];
        MDCommonBlock commonBlock = new MDCommonBlock(line);
        commonBlock.setScope(md.getNullable(args[1], commonBlock));
        commonBlock.declaration = md.getNullable(args[2], commonBlock);
        commonBlock.setName(md.getNullable(args[3], commonBlock));
        commonBlock.setFile(md.getNullable(args[4], commonBlock));
        return commonBlock;
    }
}

