/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.elf;

import com.oracle.truffle.llvm.parser.elf.ElfHeader;
import com.oracle.truffle.llvm.parser.elf.ElfReader;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.polyglot.io.ByteSequence;

public final class ElfSectionHeaderTable {
    private static final int ELF32_SHTENT_SIZE = 40;
    private static final int ELF64_SHTENT_SIZE = 64;
    private final Entry[] entries;
    private final Map<Integer, String> stringMap;
    private final ByteSequence stringTable;

    private ElfSectionHeaderTable(Entry[] entries, ByteSequence stringTable) {
        this.entries = entries;
        this.stringMap = new HashMap<Integer, String>();
        this.stringTable = stringTable;
    }

    public static ElfSectionHeaderTable create(ElfHeader header, ElfReader buffer) {
        Entry e;
        Entry[] entries = new Entry[header.getShnum()];
        buffer.setPosition((int)header.getShoff());
        for (int cntr = 0; cntr < entries.length; ++cntr) {
            entries[cntr] = ElfSectionHeaderTable.readEntry(header, buffer);
        }
        ByteSequence data = null;
        if (header.getShstrndx() < entries.length && (e = entries[header.getShstrndx()]).getSize() > 0L) {
            data = buffer.getStringTable(e.getOffset(), e.getSize());
        }
        return new ElfSectionHeaderTable(entries, data);
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public Entry getEntry(String name) {
        for (Entry e : this.entries) {
            if (!e.getName(this).equals(name)) continue;
            return e;
        }
        return null;
    }

    private String getString(int ind) {
        if (this.stringTable == null || ind >= this.stringTable.length()) {
            return "";
        }
        String str = this.stringMap.get(ind);
        if (str == null) {
            StringBuilder buf = new StringBuilder();
            int pos = ind;
            byte b = this.stringTable.byteAt(pos++);
            while (b != 0) {
                buf.append((char)b);
                b = this.stringTable.byteAt(pos++);
            }
            str = buf.toString();
            this.stringMap.put(ind, str);
        }
        return str;
    }

    private static Entry readEntry(ElfHeader header, ElfReader buffer) {
        if (buffer.is64Bit()) {
            return ElfSectionHeaderTable.readEntry64(header, buffer);
        }
        return ElfSectionHeaderTable.readEntry32(header, buffer);
    }

    private static Entry readEntry32(ElfHeader header, ElfReader buffer) {
        int shName = buffer.getInt();
        int shType = buffer.getInt();
        long shFlags = buffer.getInt();
        long shAddr = buffer.getInt();
        long shOffset = buffer.getInt();
        long shSize = buffer.getInt();
        int shLink = buffer.getInt();
        int shInfo = buffer.getInt();
        long shAddralign = buffer.getInt();
        long shEntsize = buffer.getInt();
        buffer.skip(header.getShentsize() - 40);
        return new Entry(shName, shType, shFlags, shAddr, shOffset, shSize, shLink, shInfo, shAddralign, shEntsize);
    }

    private static Entry readEntry64(ElfHeader header, ElfReader buffer) {
        int shName = buffer.getInt();
        int shType = buffer.getInt();
        long shFlags = buffer.getLong();
        long shAddr = buffer.getLong();
        long shOffset = buffer.getLong();
        long shSize = buffer.getLong();
        int shLink = buffer.getInt();
        int shInfo = buffer.getInt();
        long shAddralign = buffer.getLong();
        long shEntsize = buffer.getLong();
        buffer.skip(header.getShentsize() - 64);
        return new Entry(shName, shType, shFlags, shAddr, shOffset, shSize, shLink, shInfo, shAddralign, shEntsize);
    }

    public static final class Entry {
        private final int shName;
        private final int shType;
        private final long shFlags;
        private final long shAddr;
        private final long shOffset;
        private final long shSize;
        private final int shLink;
        private final int shInfo;
        private final long shAddralign;
        private final long shEntsize;

        private Entry(int shName, int shType, long shFlags, long shAddr, long shOffset, long shSize, int shLink, int shInfo, long shAddralign, long shEntsize) {
            assert (shSize < Long.MAX_VALUE);
            this.shName = shName;
            this.shType = shType;
            this.shFlags = shFlags;
            this.shAddr = shAddr;
            this.shOffset = shOffset;
            this.shSize = shSize;
            this.shLink = shLink;
            this.shInfo = shInfo;
            this.shAddralign = shAddralign;
            this.shEntsize = shEntsize;
        }

        public int getType() {
            return this.shType;
        }

        protected long getFlags() {
            return this.shFlags;
        }

        public String getName(ElfSectionHeaderTable sht) {
            return sht.getString(this.shName);
        }

        public long getOffset() {
            return this.shOffset;
        }

        public long getSize() {
            return this.shSize;
        }

        public int getLink() {
            return this.shLink;
        }

        public long getEntrySize() {
            return this.shEntsize;
        }

        public long getShAddr() {
            return this.shAddr;
        }

        public long getShAddralign() {
            return this.shAddralign;
        }

        public long getShEntsize() {
            return this.shEntsize;
        }

        public long getShFlags() {
            return this.shFlags;
        }

        public int getShInfo() {
            return this.shInfo;
        }

        public int getShLink() {
            return this.shLink;
        }

        public int getShName() {
            return this.shName;
        }

        public long getShOffset() {
            return this.shOffset;
        }

        public long getShSize() {
            return this.shSize;
        }

        public int getShType() {
            return this.shType;
        }
    }
}

