/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.elf;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.binary.BinaryParser;
import com.oracle.truffle.llvm.parser.elf.ElfDynamicSection;
import com.oracle.truffle.llvm.parser.elf.ElfFile;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ElfLibraryLocator
extends LibraryLocator {
    private final List<String> localPaths;
    private static final Pattern RPATH_PATTERN = Pattern.compile("\\$(ORIGIN|\\{ORIGIN\\})");

    public ElfLibraryLocator(ElfFile elfFile, Source source) {
        List<Object> elfPaths = null;
        ElfDynamicSection dynamicSection = elfFile.getDynamicSection();
        if (dynamicSection != null) {
            elfPaths = dynamicSection.getDTRunPathStream().map(new Replacer(source)::replace).collect(Collectors.toList());
            if (elfPaths.isEmpty()) {
                elfPaths = dynamicSection.getDTRPath();
            }
        }
        this.localPaths = elfPaths;
    }

    @Override
    public TruffleFile locateLibrary(LLVMContext context, String lib, Object reason) {
        Path libPath = Paths.get(lib, new String[0]);
        if (libPath.isAbsolute()) {
            return DefaultLibraryLocator.locateAbsolute(context, libPath);
        }
        TruffleFile path = DefaultLibraryLocator.locateGlobal(context, lib);
        if (path != null) {
            return path;
        }
        if (this.localPaths != null) {
            ElfLibraryLocator.traceSearchPath(context, this.localPaths, reason);
            for (String p : this.localPaths) {
                Path absPath = Paths.get(p, lib);
                ElfLibraryLocator.traceTry(context, absPath);
                TruffleFile file = context.getEnv().getInternalTruffleFile(absPath.toUri());
                if (!file.exists(new LinkOption[0])) continue;
                return file;
            }
        }
        return null;
    }

    private static class Replacer {
        private final Source source;
        private String origin;

        Replacer(Source source) {
            this.source = source;
        }

        public String replace(String e) {
            if (this.origin == null) {
                this.origin = BinaryParser.getOrigin(this.source);
            }
            if (this.origin == null) {
                return e;
            }
            return RPATH_PATTERN.matcher(e).replaceAll(this.origin);
        }
    }
}

