/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceFileReference;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import java.util.List;

public final class LLVMParserRuntime {
    private final LLVMScope fileScope;
    private final NodeFactory nodeFactory;
    private final int bitcodeID;
    private final TruffleFile file;
    private final String libName;
    private final List<LLVMSourceFileReference> sourceFileReferences;

    public LLVMParserRuntime(LLVMScope fileScope, NodeFactory nodeFactory, int bitcodeID, TruffleFile file, String libName, List<LLVMSourceFileReference> sourceFileReferences) {
        this.fileScope = fileScope;
        this.nodeFactory = nodeFactory;
        this.bitcodeID = bitcodeID;
        this.file = file;
        this.libName = libName;
        this.sourceFileReferences = sourceFileReferences;
    }

    public TruffleFile getFile() {
        return this.file;
    }

    public String getLibraryName() {
        return this.libName;
    }

    public LLVMScope getFileScope() {
        return this.fileScope;
    }

    public NodeFactory getNodeFactory() {
        return this.nodeFactory;
    }

    public int getBitcodeID() {
        return this.bitcodeID;
    }

    public List<LLVMSourceFileReference> getSourceFileReferences() {
        return this.sourceFileReferences;
    }

    public LLVMFunction lookupFunction(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null && symbol.isFunction()) {
            return symbol.asFunction();
        }
        throw new IllegalStateException("Retrieving unknown function symbol in LLVMParserRuntime: " + name);
    }

    public LLVMGlobal lookupGlobal(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null && symbol.isGlobalVariable()) {
            return symbol.asGlobalVariable();
        }
        throw new IllegalStateException("Retrieving unknown global symbol in LLVMParserRuntime: " + name);
    }

    public LLVMSymbol lookupSymbol(String name) {
        LLVMSymbol symbol = this.fileScope.get(name);
        if (symbol != null) {
            return symbol;
        }
        throw new IllegalStateException("Unknown symbol: " + name);
    }
}

