/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.functions.FunctionSymbol;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import java.util.List;

public final class LLVMParserResult {
    private final LLVMParserRuntime runtime;
    private final List<FunctionSymbol> definedFunctions;
    private final List<FunctionSymbol> externalFunctions;
    private final List<GlobalVariable> definedGlobals;
    private final List<GlobalVariable> externalGlobals;
    private final DataLayout dataLayout;
    private final int symbolTableSize;

    LLVMParserResult(LLVMParserRuntime runtime, List<FunctionSymbol> definedFunctions, List<FunctionSymbol> externalFunctions, List<GlobalVariable> definedGlobals, List<GlobalVariable> externalGlobals, DataLayout dataLayout) {
        this.runtime = runtime;
        this.definedFunctions = definedFunctions;
        this.externalFunctions = externalFunctions;
        this.definedGlobals = definedGlobals;
        this.externalGlobals = externalGlobals;
        this.dataLayout = dataLayout;
        this.symbolTableSize = definedFunctions.size() + externalFunctions.size() + definedGlobals.size() + externalGlobals.size();
    }

    public LLVMParserRuntime getRuntime() {
        return this.runtime;
    }

    public List<FunctionSymbol> getDefinedFunctions() {
        return this.definedFunctions;
    }

    public List<FunctionSymbol> getExternalFunctions() {
        return this.externalFunctions;
    }

    public List<GlobalVariable> getDefinedGlobals() {
        return this.definedGlobals;
    }

    public List<GlobalVariable> getExternalGlobals() {
        return this.externalGlobals;
    }

    public DataLayout getDataLayout() {
        return this.dataLayout;
    }

    public String toString() {
        return "LLVMParserResult[" + this.runtime.getLibraryName() + "]";
    }

    public int getSymbolTableSize() {
        return this.symbolTableSize;
    }
}

