/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMLocalScope;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import java.util.ArrayList;

public final class InitializeScopeNode
extends LLVMNode {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final LLVMSymbol[] allocScopes;
    private final LLVMScope fileScope;

    public InitializeScopeNode(LLVMParserRuntime runtime) {
        this.fileScope = runtime.getFileScope();
        ArrayList<LLVMSymbol> allocScopesList = new ArrayList<LLVMSymbol>();
        for (LLVMSymbol symbol : this.fileScope.values()) {
            if (!symbol.isExported()) continue;
            allocScopesList.add(symbol);
        }
        this.allocScopes = allocScopesList.toArray(LLVMSymbol.EMPTY);
    }

    public void execute(LLVMContext context, LLVMLocalScope localScope) {
        localScope.addMissingLinkageName(this.fileScope);
        for (int i = 0; i < this.allocScopes.length; ++i) {
            InitializeScopeNode.allocateScope(this.allocScopes[i], context, localScope);
        }
    }

    static void allocateScope(LLVMSymbol symbol, LLVMContext context, LLVMLocalScope localScope) {
        LLVMSymbol exportedSymbolFromLocal;
        LLVMScope globalScope = context.getGlobalScope();
        LLVMSymbol exportedSymbol = globalScope.get(symbol.getName());
        if (exportedSymbol == null) {
            globalScope.register(symbol);
        }
        if ((exportedSymbolFromLocal = localScope.get(symbol.getName())) == null) {
            localScope.register(symbol);
        }
    }
}

