/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.initialization.StaticInitsNode;
import com.oracle.truffle.llvm.initialization.StaticInitsNodeGen;
import com.oracle.truffle.llvm.parser.LLVMParserResult;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.symbols.globals.GlobalVariable;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemoryOpNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.vars.AggregateLiteralInPlaceNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public final class InitializeGlobalNode
extends LLVMNode
implements LLVMHasDatalayoutNode {
    private final DataLayout dataLayout;
    @Node.Child
    private StaticInitsNode globalVarInit;
    @Node.Child
    private LLVMMemoryOpNode protectRoData;

    public InitializeGlobalNode(LLVMParserResult parserResult, String moduleName) {
        this.dataLayout = parserResult.getDataLayout();
        this.globalVarInit = InitializeGlobalNode.createGlobalVariableInitializer(parserResult, moduleName);
        this.protectRoData = parserResult.getRuntime().getNodeFactory().createProtectGlobalsBlock();
    }

    public void execute(VirtualFrame frame, LLVMPointer roDataBase) {
        this.globalVarInit.execute(frame);
        if (roDataBase != null) {
            this.protectRoData.execute(roDataBase);
        }
    }

    @Override
    public DataLayout getDatalayout() {
        return this.dataLayout;
    }

    private static StaticInitsNode createGlobalVariableInitializer(LLVMParserResult parserResult, Object moduleName) {
        LLVMStatementNode initNode;
        LLVMParserRuntime runtime = parserResult.getRuntime();
        GetStackSpaceFactory stackFactory = GetStackSpaceFactory.createAllocaFactory();
        List<GlobalVariable> globals = parserResult.getDefinedGlobals();
        DataLayout dataLayout = parserResult.getDataLayout();
        int totalSize = 0;
        try {
            int[] sizes = new int[globals.size()];
            int nonEmptyGlobals = 0;
            for (int i = 0; i < sizes.length; ++i) {
                GlobalVariable global = globals.get(i);
                if (global == null || global.getValue() == null) continue;
                long size = globals.get(i).getType().getPointeeType().getSize(dataLayout);
                if (size > Integer.MAX_VALUE || (long)totalSize + size > Integer.MAX_VALUE) {
                    throw new Type.TypeOverflowException("globals section > 2GB is not supported");
                }
                if (size == 0L) continue;
                sizes[i] = (int)size;
                totalSize += (int)size;
                ++nonEmptyGlobals;
            }
            int[] bufferOffsets = new int[nonEmptyGlobals];
            LLVMGlobal[] descriptors = new LLVMGlobal[nonEmptyGlobals];
            Buffer buffer = new Buffer(totalSize, runtime, dataLayout);
            int globalIndex = 0;
            totalSize = 0;
            for (int i = 0; i < sizes.length; ++i) {
                if (sizes[i] == 0) continue;
                GlobalVariable global = globals.get(i);
                descriptors[globalIndex] = runtime.getFileScope().getGlobalVariable(global.getName());
                assert (descriptors[globalIndex] != null);
                bufferOffsets[globalIndex] = totalSize;
                global.getValue().addToBuffer(buffer, runtime, dataLayout, stackFactory);
                totalSize += sizes[i];
                ++globalIndex;
            }
            initNode = buffer.createNode(bufferOffsets, descriptors);
        }
        catch (Type.TypeOverflowException e) {
            initNode = Type.handleOverflowStatement(e);
        }
        return StaticInitsNodeGen.create(new LLVMStatementNode[]{initNode}, "global variable initializers", moduleName);
    }

    private static final class Buffer
    implements Constant.Buffer {
        private final ByteBuffer buffer;
        private final LLVMParserRuntime runtime;
        private final DataLayout dataLayout;
        private final ArrayList<LLVMOffsetStoreNode> valueStores = new ArrayList();
        private final ArrayList<Integer> valueOffsets = new ArrayList();
        private final ArrayList<Integer> valueSizes = new ArrayList();

        Buffer(int size, LLVMParserRuntime runtime, DataLayout dataLayout) {
            this.runtime = runtime;
            this.dataLayout = dataLayout;
            this.buffer = ByteBuffer.allocate(size);
            this.buffer.order(ByteOrder.nativeOrder());
        }

        @Override
        public ByteBuffer getBuffer() {
            return this.buffer;
        }

        @Override
        public void addValue(LLVMExpressionNode value, Type type) {
            try {
                int size = (int)type.getSize(this.dataLayout);
                this.valueOffsets.add(this.buffer.position());
                this.valueStores.add(this.runtime.getNodeFactory().createOffsetMemoryStore(type, value));
                this.valueSizes.add(size);
                this.buffer.position(this.buffer.position() + size);
            }
            catch (Type.TypeOverflowException typeOverflowException) {
                // empty catch block
            }
        }

        public LLVMStatementNode createNode(int[] bufferOffsets, LLVMGlobal[] descriptors) {
            assert (!this.buffer.hasRemaining());
            LLVMOffsetStoreNode[] stores = new LLVMOffsetStoreNode[this.valueStores.size()];
            int[] offsets = new int[this.valueStores.size() + 1];
            int[] sizes = new int[this.valueStores.size()];
            for (int i = 0; i < this.valueStores.size(); ++i) {
                offsets[i] = this.valueOffsets.get(i);
                sizes[i] = this.valueSizes.get(i);
                stores[i] = this.valueStores.get(i);
            }
            offsets[offsets.length - 1] = this.buffer.capacity();
            return AggregateLiteralInPlaceNodeGen.create(this.buffer.array(), stores, offsets, sizes, bufferOffsets, descriptors);
        }
    }
}

