/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.initialization;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLocalScope;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class AllocExternalSymbolNode
extends LLVMNode {
    public static final AllocExternalSymbolNode[] EMPTY = new AllocExternalSymbolNode[0];
    final LLVMSymbol symbol;

    public AllocExternalSymbolNode(LLVMSymbol symbol) {
        this.symbol = symbol;
    }

    public abstract LLVMPointer execute(LLVMLocalScope var1, LLVMScope var2, LLVMIntrinsicProvider var3, NativeContextExtension var4, LLVMContext var5);

    @ImportStatic(value={LLVMAlias.class})
    static abstract class AllocExistingLocalSymbolsNode
    extends AllocExternalSymbolNode {
        AllocExistingLocalSymbolsNode(LLVMSymbol symbol) {
            super(symbol);
        }

        @Specialization(guards={"cachedLocalSymbol != null", "localScope.get(symbol.getName()) == cachedLocalSymbol", "!(containsSymbol(cachedLocalSymbol))"})
        LLVMPointer allocateFromLocalScopeCached(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context, @Cached(value="resolveAlias(localScope.get(symbol.getName()))") LLVMSymbol cachedLocalSymbol) {
            LLVMPointer pointer = context.getSymbol(cachedLocalSymbol);
            context.registerSymbol(this.symbol, pointer);
            return pointer;
        }

        @Specialization(replaces={"allocateFromLocalScopeCached"}, guards={"localScope.get(symbol.getName()) != null", "!(containsSymbol(localScope.get(symbol.getName())))"})
        LLVMPointer allocateFromLocalScope(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context) {
            LLVMSymbol function = LLVMAlias.resolveAlias(localScope.get(this.symbol.getName()));
            LLVMPointer pointer = context.getSymbol(function);
            context.registerSymbol(this.symbol, pointer);
            return pointer;
        }

        @CompilerDirectives.TruffleBoundary
        protected boolean containsSymbol(LLVMSymbol localSymbol) {
            return this.symbol.equals(localSymbol);
        }

        @Fallback
        LLVMPointer allocateFromLocalScopeFallback(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context) {
            return null;
        }

        @ImportStatic(value={LLVMAlias.class})
        static abstract class AllocExistingGlobalSymbolsNode
        extends AllocExistingLocalSymbolsNode {
            AllocExistingGlobalSymbolsNode(LLVMSymbol symbol) {
                super(symbol);
            }

            @Specialization(guards={"localScope.get(symbol.getName()) == null", "cachedGlobalSymbol != null", "globalScope.get(symbol.getName()) == cachedGlobalSymbol", "!(containsSymbol(cachedGlobalSymbol))"})
            LLVMPointer allocateFromGlobalScopeCached(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context, @Cached(value="resolveAlias(globalScope.get(symbol.getName()))") LLVMSymbol cachedGlobalSymbol) {
                LLVMPointer pointer = context.getSymbol(cachedGlobalSymbol);
                context.registerSymbol(this.symbol, pointer);
                return pointer;
            }

            @Specialization(replaces={"allocateFromGlobalScopeCached"}, guards={"localScope.get(symbol.getName()) == null", "globalScope.get(symbol.getName()) != null", "!(containsSymbol(globalScope.get(symbol.getName())))"})
            LLVMPointer allocateFromGlobalScope(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context) {
                LLVMSymbol function = LLVMAlias.resolveAlias(globalScope.get(this.symbol.getName()));
                assert (function.isFunction());
                LLVMPointer pointer = context.getSymbol(function);
                context.registerSymbol(this.symbol, pointer);
                return pointer;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            protected boolean containsSymbol(LLVMSymbol globalSymbol) {
                return this.symbol.equals(globalSymbol);
            }

            @Override
            public abstract LLVMPointer execute(LLVMLocalScope var1, LLVMScope var2, LLVMIntrinsicProvider var3, NativeContextExtension var4, LLVMContext var5);

            static abstract class AllocExternalFunctionNode
            extends AllocExistingGlobalSymbolsNode {
                private final NodeFactory nodeFactory;
                private final LLVMFunctionCode functionCode;

                AllocExternalFunctionNode(LLVMSymbol symbol, LLVMFunctionCode functionCode, NodeFactory nodeFactory) {
                    super(symbol);
                    this.functionCode = functionCode;
                    this.nodeFactory = nodeFactory;
                }

                @CompilerDirectives.TruffleBoundary
                @Specialization(guards={"intrinsicProvider != null", "localScope.get(symbol.getName()) == null", "globalScope.get(symbol.getName()) == null", "intrinsicProvider.isIntrinsified(symbol.getName())", "symbol.isFunction()"})
                LLVMPointer allocateIntrinsicFunction(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context) {
                    LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction(), this.functionCode);
                    functionDescriptor.getFunctionCode().define(intrinsicProvider, this.nodeFactory);
                    return LLVMManagedPointer.create(functionDescriptor);
                }

                @CompilerDirectives.TruffleBoundary
                @Specialization(guards={"localScope.get(symbol.getName()) == null", "globalScope.get(symbol.getName()) == null", "!intrinsicProvider.isIntrinsified(symbol.getName())", "nativeContextExtension != null", "symbol.isFunction()"})
                LLVMPointer allocateNativeFunction(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context) {
                    NativeContextExtension.NativeLookupResult nativeFunction = nativeContextExtension.getNativeFunctionOrNull(this.symbol.getName());
                    if (nativeFunction != null) {
                        LLVMFunctionDescriptor functionDescriptor = context.createFunctionDescriptor(this.symbol.asFunction(), new LLVMFunctionCode(this.symbol.asFunction()));
                        functionDescriptor.getFunctionCode().define(new LLVMFunctionCode.NativeFunction(nativeFunction.getObject()));
                        return LLVMManagedPointer.create(functionDescriptor);
                    }
                    return null;
                }
            }

            static abstract class AllocExternalGlobalNode
            extends AllocExistingGlobalSymbolsNode {
                AllocExternalGlobalNode(LLVMSymbol symbol) {
                    super(symbol);
                }

                @CompilerDirectives.TruffleBoundary
                @Specialization(guards={"localScope.get(symbol.getName()) == null", "globalScope.get(symbol.getName()) == null", "!intrinsicProvider.isIntrinsified(symbol.getName())", "nativeContextExtension != null", "symbol.isGlobalVariable()"})
                LLVMPointer allocateNativeGlobal(LLVMLocalScope localScope, LLVMScope globalScope, LLVMIntrinsicProvider intrinsicProvider, NativeContextExtension nativeContextExtension, LLVMContext context) {
                    NativeContextExtension.NativePointerIntoLibrary pointer = nativeContextExtension.getNativeHandle(this.symbol.getName());
                    if (pointer != null) {
                        return LLVMNativePointer.create(pointer.getAddress());
                    }
                    return null;
                }
            }
        }
    }
}

