/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer;

import javax.swing.Icon;
import org.graalvm.visualvm.lib.profiler.snaptracer.PackageStateHandler;
import org.graalvm.visualvm.lib.profiler.snaptracer.Positionable;
import org.graalvm.visualvm.lib.profiler.snaptracer.SessionInitializationException;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbe;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProbeDescriptor;
import org.graalvm.visualvm.lib.profiler.snaptracer.TracerProgressObject;
import org.graalvm.visualvm.lib.profiler.snaptracer.impl.IdeSnapshot;

public abstract class TracerPackage
implements Positionable {
    private final String name;
    private final String description;
    private final Icon icon;
    private final int preferredPosition;

    public TracerPackage(String name, String description, Icon icon, int preferredPosition) {
        this.name = name;
        this.description = description;
        this.icon = icon;
        this.preferredPosition = preferredPosition;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Icon getIcon() {
        return this.icon;
    }

    @Override
    public final int getPreferredPosition() {
        return this.preferredPosition;
    }

    public abstract TracerProbeDescriptor[] getProbeDescriptors();

    public abstract TracerProbe getProbe(TracerProbeDescriptor var1);

    public PackageStateHandler getStateHandler() {
        return null;
    }

    public static abstract class SessionAware
    extends TracerPackage {
        private PackageStateHandler stateHandler;

        public SessionAware(String name, String description, Icon icon, int preferredPosition) {
            super(name, description, icon, preferredPosition);
        }

        @Override
        public final synchronized PackageStateHandler getStateHandler() {
            if (this.stateHandler == null) {
                this.stateHandler = new PackageStateHandler(){

                    @Override
                    public void probeAdded(TracerProbe probe, IdeSnapshot snapshot) {
                        SessionAware.this.probeAdded(probe, snapshot);
                    }

                    @Override
                    public void probeRemoved(TracerProbe probe, IdeSnapshot snapshot) {
                        SessionAware.this.probeRemoved(probe, snapshot);
                    }

                    @Override
                    public TracerProgressObject sessionInitializing(TracerProbe[] probes, IdeSnapshot snapshot, int refresh) {
                        return SessionAware.this.sessionInitializing(probes, snapshot, refresh);
                    }

                    @Override
                    public void sessionStarting(TracerProbe[] probes, IdeSnapshot snapshot) throws SessionInitializationException {
                        SessionAware.this.sessionStarting(probes, snapshot);
                    }

                    @Override
                    public void sessionRunning(TracerProbe[] probes, IdeSnapshot snapshot) {
                        SessionAware.this.sessionRunning(probes, snapshot);
                    }

                    @Override
                    public void sessionStopping(TracerProbe[] probes, IdeSnapshot snapshot) {
                        SessionAware.this.sessionStopping(probes, snapshot);
                    }

                    @Override
                    public void sessionFinished(TracerProbe[] probes, IdeSnapshot snapshot) {
                        SessionAware.this.sessionFinished(probes, snapshot);
                    }

                    @Override
                    public void refreshRateChanged(TracerProbe[] probes, IdeSnapshot snapshot, int refresh) {
                        SessionAware.this.refreshRateChanged(probes, snapshot, refresh);
                    }
                };
            }
            return this.stateHandler;
        }

        protected void probeAdded(TracerProbe probe, IdeSnapshot snapshot) {
        }

        protected void probeRemoved(TracerProbe probe, IdeSnapshot snapshot) {
        }

        protected TracerProgressObject sessionInitializing(TracerProbe[] probes, IdeSnapshot snapshot, int refresh) {
            return null;
        }

        protected void sessionStarting(TracerProbe[] probes, IdeSnapshot snapshot) throws SessionInitializationException {
        }

        protected void sessionRunning(TracerProbe[] probes, IdeSnapshot snapshot) {
        }

        protected void sessionStopping(TracerProbe[] probes, IdeSnapshot snapshot) {
        }

        protected void sessionFinished(TracerProbe[] probes, IdeSnapshot snapshot) {
        }

        protected void refreshRateChanged(TracerProbe[] probes, IdeSnapshot snapshot, int refresh) {
        }
    }
}

