/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal.jni;

import org.graalvm.libgraal.jni.HSObject;
import org.graalvm.libgraal.jni.JNI;
import org.graalvm.libgraal.jni.JNIUtil;

public class JNILibGraalScope<T extends Enum<T>>
implements AutoCloseable {
    private static final ThreadLocal<JNILibGraalScope<?>> topScope = new ThreadLocal();
    private final JNI.JNIEnv env;
    private final JNILibGraalScope<?> parent;
    private JNILibGraalScope<?> leaf;
    HSObject locals;
    private final Enum<T> id;
    private JNI.JObject objResult;

    public static JNI.JNIEnv env() {
        return JNILibGraalScope.scope().env;
    }

    public JNI.JNIEnv getEnv() {
        return this.env;
    }

    public static JNILibGraalScope<?> scopeOrNull() {
        JNILibGraalScope<?> scope = topScope.get();
        if (scope == null) {
            return null;
        }
        return scope.leaf;
    }

    public static JNILibGraalScope<?> scope() {
        JNILibGraalScope<?> scope = topScope.get();
        if (scope == null) {
            throw new IllegalStateException("Not in the scope of an libgraal call");
        }
        return scope.leaf;
    }

    public <P extends Enum<P>> JNILibGraalScope<P> narrow(Class<P> scopeIdType) {
        if (this.id == null) {
            throw new ClassCastException("Expected ToLibGraalScope type is " + scopeIdType + " but the type is null.");
        }
        if (this.id.getClass() != scopeIdType) {
            throw new ClassCastException("Expected ToLibGraalScope type is " + scopeIdType + " but actual type is " + this.id.getClass());
        }
        return this;
    }

    public JNILibGraalScope(Enum<T> id, JNI.JNIEnv env) {
        JNIUtil.trace(1, "HS->LIBGRAAL[enter]: %s", this.idString(id));
        this.id = id;
        JNILibGraalScope top = topScope.get();
        this.env = env;
        if (top == null) {
            JNIUtil.PushLocalFrame(env, 64);
            top = this;
            this.parent = null;
            topScope.set(this);
        } else {
            if (top.env != this.env) {
                throw new IllegalStateException("Cannot mix JNI scopes: " + this + " and " + top);
            }
            this.parent = top.leaf;
        }
        top.leaf = this;
    }

    private String idString(Enum<T> v) {
        return v != null ? v.toString() : "<called from VM>";
    }

    public void setObjectResult(JNI.JObject obj) {
        this.objResult = obj;
    }

    public <R extends JNI.JObject> R getObjectResult() {
        return (R)this.objResult;
    }

    @Override
    public void close() {
        HSObject.invalidate(this.locals);
        if (this.parent == null) {
            if (topScope.get() != this) {
                throw new IllegalStateException("Unexpected JNI scope: " + topScope.get());
            }
            topScope.set(null);
            this.objResult = JNIUtil.PopLocalFrame(this.env, this.objResult);
        } else {
            JNILibGraalScope<?> top = this.parent;
            while (top.parent != null) {
                top = top.parent;
            }
            top.leaf = this.parent;
        }
        JNIUtil.trace(1, "HS->LIBGRAAL[ exit]: %s", this.idString(this.id));
    }

    int depth() {
        int depth = 0;
        JNILibGraalScope<?> ancestor = this.parent;
        while (ancestor != null) {
            ++depth;
            ancestor = ancestor.parent;
        }
        return depth;
    }

    public String toString() {
        return "JNILibGraalScope[" + this.depth() + "]@" + Long.toHexString(this.env.rawValue());
    }
}

