/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal;

import java.lang.reflect.Method;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.libgraal.LibGraalScope;

public class LibGraal {
    private static final Method attachCurrentThread = LibGraalScope.method(HotSpotJVMCIRuntime.class, "attachCurrentThread", LibGraalScope.sig(Boolean.TYPE), LibGraalScope.sig(Boolean.TYPE, long[].class));
    private static final Method detachCurrentThread = LibGraalScope.method(HotSpotJVMCIRuntime.class, "detachCurrentThread", LibGraalScope.sig(new Class[0]), LibGraalScope.sig(Boolean.TYPE));
    static final long initialIsolate = Services.IS_BUILDING_NATIVE_IMAGE ? 0L : LibGraal.initializeLibgraal();
    static final boolean available = initialIsolate != 0L;

    public static boolean isAvailable() {
        return LibGraal.inLibGraal() || available;
    }

    public static boolean isSupported() {
        return true;
    }

    public static boolean inLibGraal() {
        return Services.IS_IN_NATIVE_IMAGE;
    }

    public static void registerNativeMethods(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (LibGraal.inLibGraal() || !LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        HotSpotJVMCIRuntime.runtime().registerNativeMethods(clazz);
    }

    public static long translate(Object obj) {
        if (!LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        return HotSpotJVMCIRuntime.runtime().translate(obj);
    }

    public static <T> T unhand(Class<T> type, long handle) {
        if (!LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        return (T)HotSpotJVMCIRuntime.runtime().unhand(type, handle);
    }

    private static long initializeLibgraal() {
        try {
            long[] javaVMInfo = HotSpotJVMCIRuntime.runtime().registerNativeMethods(LibGraalScope.class);
            long isolate = javaVMInfo[1];
            return isolate;
        }
        catch (UnsupportedOperationException e) {
            return 0L;
        }
    }

    static boolean isCurrentThreadAttached() {
        return HotSpotJVMCIRuntime.runtime().isCurrentThreadAttached();
    }

    public static boolean attachCurrentThread(boolean isDaemon, long[] isolate) {
        try {
            if (attachCurrentThread.getParameterCount() == 2) {
                long[] javaVMInfo = isolate != null ? new long[4] : null;
                boolean res = (Boolean)attachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), isDaemon, javaVMInfo);
                if (isolate != null) {
                    isolate[0] = javaVMInfo[1];
                }
                return res;
            }
            if (isolate != null) {
                isolate[0] = initialIsolate;
            }
            return (Boolean)attachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), isDaemon);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static boolean detachCurrentThread(boolean release) {
        try {
            if (detachCurrentThread.getParameterCount() == 1) {
                return (Boolean)detachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), release);
            }
            detachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), new Object[0]);
            return false;
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static long getFailedSpeculationsAddress(HotSpotSpeculationLog log) {
        return log.getFailedSpeculationsAddress();
    }
}

