/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.graphio;

import org.graalvm.graphio.GraphTypes;

final class DefaultGraphTypes
implements GraphTypes {
    static final GraphTypes DEFAULT = new DefaultGraphTypes();

    private DefaultGraphTypes() {
    }

    @Override
    public Class<?> enumClass(Object enumValue) {
        if (enumValue instanceof Enum) {
            Class<?> enumClass = enumValue.getClass();
            Enum[] constants = (Enum[])enumClass.getEnumConstants();
            if (constants == null && enumClass.isAnonymousClass()) {
                enumClass = enumClass.getSuperclass();
            }
            return enumClass;
        }
        return null;
    }

    @Override
    public int enumOrdinal(Object obj) {
        if (obj instanceof Enum) {
            return ((Enum)obj).ordinal();
        }
        return -1;
    }

    @Override
    public String[] enumTypeValues(Object clazz) {
        Class enumClass;
        Enum[] constants;
        if (clazz instanceof Class && (constants = (Enum[])(enumClass = (Class)clazz).getEnumConstants()) != null) {
            String[] names = new String[constants.length];
            for (int i = 0; i < constants.length; ++i) {
                names[i] = constants[i].name();
            }
            return names;
        }
        return null;
    }

    @Override
    public String typeName(Object clazz) {
        if (clazz instanceof Class) {
            return ((Class)clazz).getName();
        }
        return null;
    }
}

