/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.ArrayList;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.debug.DynamicCounterNode;
import org.graalvm.compiler.nodes.debug.WeakCounterNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.virtual.EscapeObjectState;
import org.graalvm.compiler.virtual.phases.ea.EffectList;

public final class GraphEffectList
extends EffectList {
    private int virtualizationDelta;

    public GraphEffectList(DebugContext debug) {
        super(debug);
    }

    @Override
    public void clear() {
        super.clear();
        this.virtualizationDelta = 0;
    }

    public void addCounterBefore(String group, String name, int increment, boolean addContext, FixedNode position) {
        this.add("add counter", (StructuredGraph graph) -> DynamicCounterNode.addCounterBefore(group, name, increment, addContext, position));
    }

    public void addCounterAfter(String group, String name, int increment, boolean addContext, FixedWithNextNode position) {
        FixedNode nextPosition = position.next();
        this.add("add counter after", (StructuredGraph graph) -> DynamicCounterNode.addCounterBefore(group, name, increment, addContext, nextPosition));
    }

    public void addWeakCounterCounterBefore(String group, String name, int increment, boolean addContext, ValueNode checkedValue, FixedNode position) {
        this.add("add weak counter", (StructuredGraph graph) -> WeakCounterNode.addCounterBefore(group, name, increment, addContext, checkedValue, position));
    }

    public void addFixedNodeBefore(FixedWithNextNode node, FixedNode position) {
        this.add("add fixed node", (StructuredGraph graph) -> {
            assert (!node.isAlive() && !node.isDeleted() && position.isAlive());
            graph.addBeforeFixed(position, graph.add(node));
        });
    }

    public void ensureAdded(ValueNode node, FixedNode position) {
        this.add("ensure added", (StructuredGraph graph) -> {
            assert (position.isAlive());
            assert (node instanceof FixedNode);
            if (!node.isAlive()) {
                graph.addOrUniqueWithInputs(node);
                if (node instanceof FixedWithNextNode) {
                    graph.addBeforeFixed(position, (FixedWithNextNode)node);
                }
            }
        });
    }

    public void addVirtualizationDelta(int delta) {
        this.virtualizationDelta += delta;
    }

    public int getVirtualizationDelta() {
        return this.virtualizationDelta;
    }

    public void addFloatingNode(ValueNode node, String cause) {
        this.add("add floating node", (StructuredGraph graph) -> graph.addWithoutUniqueWithInputs(node));
    }

    public void initializePhiInput(PhiNode node, int index, ValueNode value) {
        this.add("set phi input", (StructuredGraph graph, ArrayList<Node> obsoleteNodes) -> {
            assert (node.isAlive() && index >= 0) : node;
            node.initializeValueAt(index, graph.addOrUniqueWithInputs(value));
        });
    }

    public void addVirtualMapping(final FrameState node, final EscapeObjectState state) {
        this.add("add virtual mapping", new EffectList.Effect(){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node.isAlive()) {
                    assert (!state.isDeleted());
                    FrameState stateAfter = node;
                    for (int i = 0; i < stateAfter.virtualObjectMappingCount(); ++i) {
                        if (stateAfter.virtualObjectMappingAt(i).object() != state.object()) continue;
                        stateAfter.virtualObjectMappings().remove(i);
                    }
                    stateAfter.addVirtualObjectMapping(graph.addOrUniqueWithInputs(state));
                }
            }

            @Override
            public boolean isVisible() {
                return false;
            }
        });
    }

    public void deleteNode(final Node node) {
        this.add("delete fixed node", new EffectList.Effect(){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node instanceof FixedWithNextNode) {
                    GraphUtil.unlinkFixedNode((FixedWithNextNode)node);
                } else if (node instanceof WithExceptionNode && node.isAlive()) {
                    WithExceptionNode withExceptionNode = (WithExceptionNode)node;
                    AbstractBeginNode next = withExceptionNode.next();
                    GraphUtil.unlinkAndKillExceptionEdge(withExceptionNode);
                    if (next.hasNoUsages() && next instanceof MemoryKill) {
                        graph.replaceFixedWithFixed(next, graph.add(new BeginNode()));
                    }
                    obsoleteNodes.add(withExceptionNode);
                }
                obsoleteNodes.add(node);
            }

            @Override
            public boolean isCfgKill() {
                return node instanceof WithExceptionNode;
            }
        });
    }

    public void killIfBranch(final IfNode ifNode, final boolean constantCondition) {
        this.add("kill if branch", new EffectList.Effect(){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (ifNode.isAlive()) {
                    graph.removeSplitPropagate(ifNode, ifNode.getSuccessor(constantCondition));
                }
            }

            @Override
            public boolean isCfgKill() {
                return true;
            }
        });
    }

    public void replaceWithSink(final FixedWithNextNode node, final ControlSinkNode sink) {
        this.add("replace with sink", new EffectList.Effect(){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                try (DebugCloseable position = graph.withNodeSourcePosition(node);){
                    graph.addWithoutUnique(sink);
                    node.replaceAtPredecessor(sink);
                    GraphUtil.killCFG(node);
                }
            }

            @Override
            public boolean isCfgKill() {
                return true;
            }
        });
    }

    public void replaceAtUsages(ValueNode node, ValueNode replacement, FixedNode insertBefore) {
        assert (node != null && replacement != null) : node + " " + replacement;
        assert (!node.hasUsages() || node.stamp(NodeView.DEFAULT).isCompatible(replacement.stamp(NodeView.DEFAULT))) : "Replacement node stamp not compatible " + node.stamp(NodeView.DEFAULT) + " vs " + replacement.stamp(NodeView.DEFAULT);
        this.add("replace at usages", (StructuredGraph graph, ArrayList<Node> obsoleteNodes) -> {
            try (DebugCloseable position = graph.withNodeSourcePosition(node);){
                assert (node.isAlive());
                ValueNode replacementNode = graph.addOrUniqueWithInputs(replacement);
                assert (replacementNode.isAlive());
                assert (insertBefore != null);
                if (replacementNode instanceof FixedWithNextNode && ((FixedWithNextNode)replacementNode).next() == null) {
                    graph.addBeforeFixed(insertBefore, (FixedWithNextNode)replacementNode);
                }
                if (node.hasUsages() && !node.stamp(NodeView.DEFAULT).equals(replacementNode.stamp(NodeView.DEFAULT))) {
                    replacementNode = graph.unique(new PiNode(replacementNode, node.stamp(NodeView.DEFAULT)));
                }
                node.replaceAtUsages(replacementNode);
                if (node instanceof FixedWithNextNode) {
                    GraphUtil.unlinkFixedNode((FixedWithNextNode)node);
                }
                obsoleteNodes.add(node);
            }
        });
    }

    public void replaceFirstInput(final Node node, final Node oldInput, final Node newInput) {
        assert (node.isAlive() && oldInput.isAlive() && !newInput.isDeleted());
        this.add("replace first input", new EffectList.Effect(){

            @Override
            public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
                if (node.isAlive()) {
                    assert (oldInput.isAlive() && newInput.isAlive());
                    node.replaceFirstInput(oldInput, newInput);
                }
            }

            @Override
            public boolean isVisible() {
                return !(node instanceof FrameState);
            }
        });
    }
}

