/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.Iterator;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public abstract class EffectsBlockState<T extends EffectsBlockState<T>> {
    private boolean dead;

    public EffectsBlockState() {
    }

    public EffectsBlockState(EffectsBlockState<T> other) {
        this.dead = other.dead;
    }

    public String toString() {
        return "";
    }

    protected abstract boolean equivalentTo(T var1);

    public boolean isDead() {
        return this.dead;
    }

    public void markAsDead() {
        this.dead = true;
    }

    protected static <K, V> boolean isSubMapOf(EconomicMap<K, V> superMap, EconomicMap<K, V> subMap) {
        if (superMap == subMap) {
            return true;
        }
        MapCursor cursor = subMap.getEntries();
        while (cursor.advance()) {
            Object key = cursor.getKey();
            Object value = cursor.getValue();
            assert (value != null);
            Object otherValue = superMap.get(key);
            if (otherValue == value || value.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    protected static <U, V> void meetMaps(Map<U, V> target, Map<U, V> source) {
        Iterator<Map.Entry<U, V>> iter = target.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<U, V> entry = iter.next();
            if (source.containsKey(entry.getKey())) {
                assert (source.get(entry.getKey()) == entry.getValue());
                continue;
            }
            iter.remove();
        }
    }
}

