/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;

public class EffectList
implements Iterable<Effect> {
    private static final Effect[] EMPTY_ARRAY = new Effect[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final DebugContext debug;
    private Effect[] effects = EMPTY_ARRAY;
    private String[] names = EMPTY_STRING_ARRAY;
    private int size;

    public EffectList(DebugContext debug) {
        this.debug = debug;
    }

    private void enlarge(int elements) {
        int length = this.effects.length;
        if (this.size + elements > length) {
            while (this.size + elements > length) {
                length = Math.max(length * 2, 4);
            }
            this.effects = Arrays.copyOf(this.effects, length);
            if (this.debug.isLogEnabled()) {
                this.names = Arrays.copyOf(this.names, length);
            }
        }
    }

    public void add(String name, SimpleEffect effect) {
        this.add(name, (Effect)effect);
    }

    public void add(String name, Effect effect) {
        assert (effect != null);
        this.enlarge(1);
        if (this.debug.isLogEnabled()) {
            this.names[this.size] = name;
        }
        this.effects[this.size++] = effect;
    }

    public void addAll(EffectList list) {
        this.enlarge(list.size);
        System.arraycopy(list.effects, 0, this.effects, this.size, list.size);
        if (this.debug.isLogEnabled()) {
            System.arraycopy(list.names, 0, this.names, this.size, list.size);
        }
        this.size += list.size;
    }

    public void insertAll(EffectList list, int position) {
        assert (position >= 0 && position <= this.size);
        this.enlarge(list.size);
        System.arraycopy(this.effects, position, this.effects, position + list.size, this.size - position);
        System.arraycopy(list.effects, 0, this.effects, position, list.size);
        if (this.debug.isLogEnabled()) {
            System.arraycopy(this.names, position, this.names, position + list.size, this.size - position);
            System.arraycopy(list.names, 0, this.names, position, list.size);
        }
        this.size += list.size;
    }

    public int checkpoint() {
        return this.size;
    }

    public int size() {
        return this.size;
    }

    public void backtrack(int checkpoint) {
        assert (checkpoint <= this.size);
        this.size = checkpoint;
    }

    @Override
    public Iterator<Effect> iterator() {
        return new Iterator<Effect>(){
            int index;
            final int listSize;
            {
                this.listSize = EffectList.this.size;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.listSize;
            }

            @Override
            public Effect next() {
                return EffectList.this.effects[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Effect get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.effects[index];
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes, boolean cfgKills) {
        boolean message = false;
        for (int i = 0; i < this.size(); ++i) {
            Effect effect = this.effects[i];
            if (effect.isCfgKill() != cfgKills) continue;
            if (!message) {
                message = true;
                this.debug.log(cfgKills ? " ==== cfg kill effects" : " ==== effects");
            }
            try {
                effect.apply(graph, obsoleteNodes);
            }
            catch (Throwable t) {
                StringBuilder str = new StringBuilder();
                this.toString(str, i);
                throw new GraalError(t).addContext("effect", str);
            }
            if (!effect.isVisible() || !this.debug.isLogEnabled()) continue;
            StringBuilder str = new StringBuilder();
            this.toString(str, i);
            this.debug.log("    %s", str);
        }
    }

    private void toString(StringBuilder str, int i) {
        Effect effect = this.effects[i];
        str.append(this.getName(i)).append(" [");
        boolean first = true;
        for (Field field : effect.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object object = field.get(effect);
                if (object == this) continue;
                str.append(first ? "" : ", ").append(field.getName()).append("=").append(EffectList.format(object));
                first = false;
            }
            catch (IllegalAccessException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        str.append(']');
    }

    private static String format(Object object) {
        if (object != null && Object[].class.isAssignableFrom(object.getClass())) {
            return Arrays.toString((Object[])object);
        }
        return "" + object;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            Effect effect = this.get(i);
            if (!effect.isVisible()) continue;
            this.toString(str, i);
            str.append('\n');
        }
        return str.toString();
    }

    private String getName(int i) {
        if (this.debug.isLogEnabled()) {
            return this.names[i];
        }
        return "";
    }

    public static interface SimpleEffect
    extends Effect {
        @Override
        default public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
            this.apply(graph);
        }

        public void apply(StructuredGraph var1);
    }

    public static interface Effect {
        default public boolean isVisible() {
            return true;
        }

        default public boolean isCfgKill() {
            return false;
        }

        public void apply(StructuredGraph var1, ArrayList<Node> var2);
    }
}

