/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.AbstractHotSpotTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalHotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.TruffleToLibGraalCalls;
import org.graalvm.libgraal.LibGraal;
import org.graalvm.libgraal.LibGraalObject;
import org.graalvm.libgraal.LibGraalScope;

final class LibGraalTruffleRuntime
extends AbstractHotSpotTruffleRuntime {
    LibGraalTruffleRuntime() {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            HotSpotJVMCIRuntime.runtime().registerNativeMethods(TruffleToLibGraalCalls.class);
        }
    }

    long handle() {
        try (LibGraalScope scope = new LibGraalScope();){
            long l = scope.getIsolate().getSingleton(Handle.class, () -> {
                MetaAccessProvider metaAccess = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getMetaAccess();
                HotSpotResolvedJavaType type = (HotSpotResolvedJavaType)metaAccess.lookupJavaType(this.getClass());
                long classLoaderDelegate = LibGraal.translate(type);
                return new Handle(TruffleToLibGraalCalls.initializeRuntime(LibGraalScope.getIsolateThread(), this, classLoaderDelegate));
            }).getHandle();
            return l;
        }
    }

    @Override
    public HotSpotTruffleCompiler newTruffleCompiler() {
        return new LibGraalHotSpotTruffleCompiler(this);
    }

    @Override
    protected String initLazyCompilerConfigurationName() {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            String string = TruffleToLibGraalCalls.getCompilerConfigurationFactoryName(LibGraalScope.getIsolateThread(), this.handle());
            return string;
        }
    }

    @Override
    protected AutoCloseable openCompilerThreadScope() {
        return new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);
    }

    @Override
    protected boolean isPrintGraphEnabled() {
        try (LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);){
            boolean bl = TruffleToLibGraalCalls.isPrintGraphEnabled(LibGraalScope.getIsolateThread(), this.handle());
            return bl;
        }
    }

    static final class Handle
    extends LibGraalObject {
        Handle(long handle) {
            super(handle);
        }
    }
}

