/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalHotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.TruffleToLibGraalCalls;
import org.graalvm.libgraal.LibGraalObject;
import org.graalvm.libgraal.LibGraalScope;

final class LibGraalTruffleCompilation
extends LibGraalObject
implements TruffleCompilation {
    private final LibGraalHotSpotTruffleCompiler owner;
    private volatile CompilableTruffleAST cachedCompilableTruffleAST;
    private volatile String cachedId;
    private final LibGraalScope scope;

    LibGraalTruffleCompilation(LibGraalHotSpotTruffleCompiler owner, long handle, LibGraalScope scope) {
        super(handle);
        this.owner = owner;
        this.scope = scope;
    }

    @Override
    public CompilableTruffleAST getCompilable() {
        CompilableTruffleAST compilable = this.cachedCompilableTruffleAST;
        if (compilable == null) {
            this.cachedCompilableTruffleAST = compilable = TruffleToLibGraalCalls.getTruffleCompilationTruffleAST(LibGraalScope.getIsolateThread(), this.getHandle());
        }
        return compilable;
    }

    @Override
    public void close() {
        try {
            this.owner.closeCompilation(this);
            this.cachedCompilableTruffleAST = null;
        }
        finally {
            TruffleToLibGraalCalls.closeCompilation(LibGraalScope.getIsolateThread(), this.getHandle());
            this.scope.close();
        }
    }

    String getId() {
        String id = this.cachedId;
        if (id == null) {
            this.cachedId = id = TruffleToLibGraalCalls.getTruffleCompilationId(LibGraalScope.getIsolateThread(), this.getHandle());
        }
        return id;
    }
}

