/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot.libgraal;

import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalHotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.LibGraalTruffleCompilation;
import org.graalvm.compiler.truffle.runtime.hotspot.libgraal.TruffleToLibGraalCalls;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.libgraal.LibGraalObject;
import org.graalvm.libgraal.LibGraalScope;
import org.graalvm.util.OptionsEncoder;

final class IgvSupport
extends LibGraalObject
implements TruffleDebugContext {
    private static volatile Map<Object, Object> versionProperties;
    private static volatile String executionId;
    private final LibGraalHotSpotTruffleCompiler owner;
    private final LibGraalScope scope;
    private GraphOutput<?, ?> parentOutput;
    private IgvDumpChannel sharedChannel;

    private IgvSupport(LibGraalScope scope, LibGraalHotSpotTruffleCompiler owner, long handle) {
        super(handle);
        Objects.requireNonNull(owner, "Owner must be non null.");
        this.owner = owner;
        this.scope = scope;
    }

    @Override
    public <G, N, M> GraphOutput<G, M> buildOutput(GraphOutput.Builder<G, N, M> builder) throws IOException {
        GraphOutput<?, ?> parent = this.parentOutput;
        if (parent != null) {
            return builder.build(parent);
        }
        if (this.sharedChannel == null) {
            this.sharedChannel = new IgvDumpChannel(TruffleToLibGraalCalls.getDumpChannel(LibGraalScope.getIsolateThread(), this.getHandle()));
        }
        GraphOutput<G, M> res = builder.attr("vm.uuid", IgvSupport.getExecutionID()).embedded(true).build(this.sharedChannel);
        this.parentOutput = res;
        return res;
    }

    @Override
    public boolean isDumpEnabled() {
        return TruffleToLibGraalCalls.isBasicDumpEnabled(LibGraalScope.getIsolateThread(), this.getHandle());
    }

    @Override
    public Map<Object, Object> getVersionProperties() {
        Map<Object, Object> res = versionProperties;
        if (res == null) {
            byte[] serializedProperties = TruffleToLibGraalCalls.getVersionProperties(LibGraalScope.getIsolateThread());
            versionProperties = res = Collections.unmodifiableMap(OptionsEncoder.decode(serializedProperties));
        }
        return res;
    }

    @Override
    public Closeable scope(String name) {
        return this.scope(name, null);
    }

    @Override
    public Closeable scope(String name, Object context) {
        long compilationHandle;
        CompilableTruffleAST compilable;
        CompilableTruffleAST compilableTruffleAST = compilable = context instanceof TruffleDebugJavaMethod ? ((TruffleDebugJavaMethod)context).getCompilable() : null;
        if (compilable == null) {
            compilationHandle = 0L;
        } else {
            LibGraalTruffleCompilation compilation = this.owner.getActiveCompilation();
            assert (compilation != null) : compilable;
            compilationHandle = compilation.getHandle();
        }
        long scopeHandle = TruffleToLibGraalCalls.openDebugContextScope(LibGraalScope.getIsolateThread(), this.getHandle(), name, compilationHandle);
        return scopeHandle == 0L ? null : new Scope(scopeHandle);
    }

    @Override
    public void close() {
        try {
            TruffleToLibGraalCalls.closeDebugContext(LibGraalScope.getIsolateThread(), this.getHandle());
        }
        finally {
            this.scope.close();
        }
    }

    @Override
    public void closeDebugChannels() {
    }

    private static String getExecutionID() {
        String res = executionId;
        if (res == null) {
            executionId = res = TruffleToLibGraalCalls.getExecutionID(LibGraalScope.getIsolateThread());
        }
        return res;
    }

    static IgvSupport create(LibGraalHotSpotTruffleCompiler compiler, Map<String, Object> options, LibGraalTruffleCompilation compilation) {
        byte[] encodedOptions = OptionsEncoder.encode(options);
        LibGraalScope scope = new LibGraalScope(LibGraalScope.DetachAction.DETACH_RUNTIME_AND_RELEASE);
        return new IgvSupport(scope, compiler, TruffleToLibGraalCalls.openDebugContext(LibGraalScope.getIsolateThread(), compiler.handle(options, compilation), compilation == null ? 0L : compilation.getHandle(), encodedOptions));
    }

    private static final class Scope
    extends LibGraalObject
    implements Closeable {
        Scope(long handle) {
            super(handle);
        }

        @Override
        public void close() {
            TruffleToLibGraalCalls.closeDebugContextScope(LibGraalScope.getIsolateThread(), this.getHandle());
        }
    }

    private static final class IgvDumpChannel
    extends LibGraalObject
    implements WritableByteChannel {
        IgvDumpChannel(long handle) {
            super(handle);
        }

        static Buffer asBaseBuffer(Buffer obj) {
            return obj;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            if (src.hasArray()) {
                throw new IllegalArgumentException("Only direct ByteBuffer is supported.");
            }
            int capacity = src.capacity();
            int pos = src.position();
            int limit = src.limit();
            int written = TruffleToLibGraalCalls.dumpChannelWrite(LibGraalScope.getIsolateThread(), this.getHandle(), src, capacity, pos, limit);
            if (written > 0) {
                IgvDumpChannel.asBaseBuffer(src).position(pos + written);
            }
            return written;
        }

        @Override
        public boolean isOpen() {
            return TruffleToLibGraalCalls.isDumpChannelOpen(LibGraalScope.getIsolateThread(), this.getHandle());
        }

        @Override
        public void close() throws IOException {
            TruffleToLibGraalCalls.dumpChannelClose(LibGraalScope.getIsolateThread(), this.getHandle());
        }
    }
}

