/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.code.InstalledCode;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompiler;
import org.graalvm.compiler.truffle.common.hotspot.HotSpotTruffleCompilerRuntime;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.CompilationTask;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.compiler.truffle.runtime.hotspot.HotSpotOptimizedCallTarget;
import sun.misc.Unsafe;

public abstract class AbstractHotSpotTruffleRuntime
extends GraalTruffleRuntime
implements HotSpotTruffleCompilerRuntime {
    private static final Unsafe UNSAFE = AbstractHotSpotTruffleRuntime.getUnsafe();
    private volatile boolean traceTransferToInterpreter;
    private Boolean profilingEnabled;
    private volatile Lazy lazy;
    private volatile String lazyConfigurationName;
    private final List<ResolvedJavaMethod> truffleCallBoundaryMethods;
    private volatile CompilationTask initializationTask;
    private volatile boolean truffleCompilerInitialized;
    private volatile Throwable truffleCompilerInitializationException;

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lazy lazy() {
        if (this.lazy == null) {
            AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = this;
            synchronized (abstractHotSpotTruffleRuntime) {
                if (this.lazy == null) {
                    this.lazy = new Lazy(this);
                }
            }
        }
        return this.lazy;
    }

    public AbstractHotSpotTruffleRuntime() {
        super(Arrays.asList(HotSpotOptimizedCallTarget.class, InstalledCode.class));
        ArrayList<ResolvedJavaMethod> boundaryMethods = new ArrayList<ResolvedJavaMethod>();
        MetaAccessProvider metaAccess = AbstractHotSpotTruffleRuntime.getMetaAccess();
        ResolvedJavaType type = metaAccess.lookupJavaType(OptimizedCallTarget.class);
        for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
            if (method.getAnnotation(TruffleCallBoundary.class) == null) continue;
            boundaryMethods.add(method);
        }
        this.truffleCallBoundaryMethods = boundaryMethods;
        AbstractHotSpotTruffleRuntime.setDontInlineCallBoundaryMethod(boundaryMethods);
    }

    @Override
    public final Iterable<ResolvedJavaMethod> getTruffleCallBoundaryMethods() {
        return this.truffleCallBoundaryMethods;
    }

    @Override
    protected StackIntrospection getStackIntrospection() {
        Lazy l = this.lazy();
        if (l.stackIntrospection == null) {
            l.stackIntrospection = HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getStackIntrospection();
        }
        return l.stackIntrospection;
    }

    @Override
    public HotSpotTruffleCompiler getTruffleCompiler(CompilableTruffleAST compilable) {
        Objects.requireNonNull(compilable, "Compilable must be non null.");
        if (this.truffleCompiler == null) {
            this.initializeTruffleCompiler((OptimizedCallTarget)compilable);
            this.rethrowTruffleCompilerInitializationException();
            assert (this.truffleCompiler != null) : "TruffleCompiler must be non null";
        }
        return (HotSpotTruffleCompiler)this.truffleCompiler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized(final OptimizedCallTarget firstCallTarget) {
        if (this.truffleCompilerInitialized) {
            return;
        }
        CompilationTask localTask = this.initializationTask;
        if (localTask == null) {
            AbstractHotSpotTruffleRuntime lock;
            AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = lock = this;
            synchronized (abstractHotSpotTruffleRuntime) {
                localTask = this.initializationTask;
                if (localTask == null && !this.truffleCompilerInitialized) {
                    this.rethrowTruffleCompilerInitializationException();
                    this.initializationTask = localTask = this.getCompileQueue().submitInitialization(firstCallTarget, new Consumer<CompilationTask>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void accept(CompilationTask task) {
                            Object object = lock;
                            synchronized (object) {
                                AbstractHotSpotTruffleRuntime.this.initializeTruffleCompiler(firstCallTarget);
                                assert (AbstractHotSpotTruffleRuntime.this.truffleCompilerInitialized || AbstractHotSpotTruffleRuntime.this.truffleCompilerInitializationException != null);
                                assert (AbstractHotSpotTruffleRuntime.this.initializationTask != null);
                                AbstractHotSpotTruffleRuntime.this.initializationTask = null;
                            }
                        }
                    });
                }
            }
        }
        if (localTask != null) {
            firstCallTarget.maybeWaitForTask(localTask);
            this.rethrowTruffleCompilerInitializationException();
        } else assert (this.truffleCompilerInitialized || this.truffleCompilerInitializationException != null);
    }

    public final void resetCompiler() {
        this.truffleCompiler = null;
        this.truffleCompilerInitialized = false;
        this.truffleCompilerInitializationException = null;
    }

    private synchronized void initializeTruffleCompiler(OptimizedCallTarget callTarget) {
        if (!this.truffleCompilerInitialized) {
            this.rethrowTruffleCompilerInitializationException();
            try {
                EngineData engineData = callTarget.engine;
                this.profilingEnabled = engineData.profilingEnabled;
                TruffleCompiler compiler = this.newTruffleCompiler();
                compiler.initialize(AbstractHotSpotTruffleRuntime.getOptionsForCompiler(callTarget), callTarget, true);
                this.truffleCompiler = compiler;
                this.traceTransferToInterpreter = engineData.traceTransferToInterpreter;
                this.truffleCompilerInitialized = true;
            }
            catch (Throwable e) {
                this.truffleCompilerInitializationException = e;
            }
        }
    }

    private void rethrowTruffleCompilerInitializationException() {
        if (this.truffleCompilerInitializationException != null) {
            throw AbstractHotSpotTruffleRuntime.sthrow(RuntimeException.class, this.truffleCompilerInitializationException);
        }
    }

    private static <T extends Throwable> T sthrow(Class<T> type, Throwable t) throws T {
        throw t;
    }

    @Override
    public final OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget source, RootNode rootNode) {
        HotSpotOptimizedCallTarget target = new HotSpotOptimizedCallTarget(source, rootNode);
        this.ensureInitialized(target);
        return target;
    }

    @Override
    public void onCodeInstallation(CompilableTruffleAST compilable, InstalledCode installedCode) {
        HotSpotOptimizedCallTarget callTarget = (HotSpotOptimizedCallTarget)compilable;
        callTarget.setInstalledCode(installedCode);
    }

    @Override
    public SpeculationLog createSpeculationLog() {
        return new HotSpotSpeculationLog();
    }

    public static void setDontInlineCallBoundaryMethod(List<ResolvedJavaMethod> callBoundaryMethods) {
        for (ResolvedJavaMethod method : callBoundaryMethods) {
            AbstractHotSpotTruffleRuntime.setNotInlinableOrCompilable(method);
        }
    }

    static MetaAccessProvider getMetaAccess() {
        return JVMCI.getRuntime().getHostJVMCIBackend().getMetaAccess();
    }

    private static void setNotInlinableOrCompilable(ResolvedJavaMethod method) {
        Method[] methods;
        for (Method m : methods = HotSpotResolvedJavaMethod.class.getMethods()) {
            if (!m.getName().equals("setNotInlineable") && !m.getName().equals("setNotInlinableOrCompilable") && !m.getName().equals("setNotInlineableOrCompileable")) continue;
            try {
                m.invoke((Object)method, new Object[0]);
                return;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new InternalError(e);
            }
        }
        throw new InternalError(String.format("Could not find setNotInlineable, setNotInlinableOrCompilable or setNotInlineableOrCompileable in %s", HotSpotResolvedJavaMethod.class));
    }

    @Override
    public BackgroundCompileQueue getCompileQueue() {
        return this.lazy();
    }

    @Override
    protected String getCompilerConfigurationName() {
        TruffleCompiler compiler = this.truffleCompiler;
        String compilerConfig = compiler != null ? compiler.getCompilerConfigurationName() : this.getLazyCompilerConfigurationName();
        return compilerConfig;
    }

    private boolean verifyCompilerConfiguration(String name) {
        String lazyName = this.getLazyCompilerConfigurationName();
        if (!name.equals(lazyName)) {
            throw new AssertionError((Object)("Expected compiler configuration name " + name + " but was " + lazyName + "."));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLazyCompilerConfigurationName() {
        String compilerConfig = this.lazyConfigurationName;
        if (compilerConfig == null) {
            AbstractHotSpotTruffleRuntime abstractHotSpotTruffleRuntime = this;
            synchronized (abstractHotSpotTruffleRuntime) {
                compilerConfig = this.lazyConfigurationName;
                if (compilerConfig == null) {
                    this.lazyConfigurationName = compilerConfig = this.initLazyCompilerConfigurationName();
                }
            }
        }
        return compilerConfig;
    }

    protected abstract String initLazyCompilerConfigurationName();

    @Override
    public void bypassedInstalledCode(OptimizedCallTarget target) {
        if (!this.truffleCompilerInitialized) {
            return;
        }
        this.getTruffleCompiler(target).installTruffleCallBoundaryMethods(target);
    }

    @Override
    protected GraalTruffleRuntime.CallMethods getCallMethods() {
        if (this.callMethods == null) {
            this.lookupCallMethods(AbstractHotSpotTruffleRuntime.getMetaAccess());
        }
        return this.callMethods;
    }

    public void notifyTransferToInterpreter() {
        CompilerAsserts.neverPartOfCompilation();
        if (this.traceTransferToInterpreter) {
            TruffleCompiler compiler = this.truffleCompiler;
            assert (compiler != null);
            TraceTransferToInterpreterHelper.traceTransferToInterpreter(this, (HotSpotTruffleCompiler)compiler);
        }
    }

    public final boolean isProfilingEnabled() {
        if (this.profilingEnabled == null) {
            return true;
        }
        return this.profilingEnabled;
    }

    @Override
    protected JavaConstant forObject(Object object) {
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)HotSpotJVMCIRuntime.runtime().getHostJVMCIBackend().getConstantReflection();
        return constantReflection.forObject(object);
    }

    @Override
    protected <T> T asObject(Class<T> type, JavaConstant constant) {
        if (constant.isNull()) {
            return null;
        }
        HotSpotObjectConstant hsConstant = (HotSpotObjectConstant)constant;
        return (T)hsConstant.asObject(type);
    }

    private static class TraceTransferToInterpreterHelper {
        private static final long THREAD_EETOP_OFFSET;

        private TraceTransferToInterpreterHelper() {
        }

        static void traceTransferToInterpreter(AbstractHotSpotTruffleRuntime runtime, HotSpotTruffleCompiler compiler) {
            boolean deoptimized;
            FrameInstance currentFrame = runtime.getCurrentFrame();
            if (currentFrame == null) {
                return;
            }
            OptimizedCallTarget callTarget = (OptimizedCallTarget)currentFrame.getCallTarget();
            long thread = UNSAFE.getLong(Thread.currentThread(), THREAD_EETOP_OFFSET);
            long pendingTransferToInterpreterAddress = thread + (long)compiler.pendingTransferToInterpreterOffset(callTarget);
            boolean bl = deoptimized = UNSAFE.getByte(pendingTransferToInterpreterAddress) != 0;
            if (deoptimized) {
                TraceTransferToInterpreterHelper.logTransferToInterpreter(runtime, callTarget);
                UNSAFE.putByte(pendingTransferToInterpreterAddress, (byte)0);
            }
        }

        private static String formatStackFrame(FrameInstance frameInstance, CallTarget target) {
            StringBuilder builder = new StringBuilder();
            if (target instanceof RootCallTarget) {
                OptimizedCallTarget callTarget;
                RootNode root = ((RootCallTarget)target).getRootNode();
                String name = root.getName();
                if (name == null) {
                    builder.append("unnamed-root");
                } else {
                    builder.append(name);
                }
                Node callNode = frameInstance.getCallNode();
                SourceSection sourceSection = null;
                if (callNode != null) {
                    sourceSection = callNode.getEncapsulatingSourceSection();
                }
                if (sourceSection == null) {
                    sourceSection = root.getSourceSection();
                }
                if (sourceSection == null || sourceSection.getSource() == null) {
                    builder.append("(Unknown)");
                } else {
                    builder.append("(").append(TraceTransferToInterpreterHelper.formatPath(sourceSection)).append(":").append(sourceSection.getStartLine()).append(")");
                }
                if (target instanceof OptimizedCallTarget && (callTarget = (OptimizedCallTarget)target).getSourceCallTarget() != null) {
                    builder.append(" <split-" + Integer.toHexString(callTarget.hashCode()) + ">");
                }
            } else {
                builder.append(target.toString());
            }
            return builder.toString();
        }

        private static String formatPath(SourceSection sourceSection) {
            if (sourceSection.getSource().getPath() != null) {
                Path path = FileSystems.getDefault().getPath(".", new String[0]).toAbsolutePath();
                Path filePath = FileSystems.getDefault().getPath(sourceSection.getSource().getPath(), new String[0]).toAbsolutePath();
                try {
                    return path.relativize(filePath).toString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return sourceSection.getSource().getName();
        }

        private static void logTransferToInterpreter(AbstractHotSpotTruffleRuntime runtime, OptimizedCallTarget callTarget) {
            final int limit = callTarget.getOptionValue(PolyglotCompilerOptions.TraceStackTraceLimit);
            final StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append("transferToInterpreter at\n");
            runtime.iterateFrames(new FrameInstanceVisitor<Object>(){
                int frameIndex = 0;

                public Object visitFrame(FrameInstance frameInstance) {
                    CallTarget target = frameInstance.getCallTarget();
                    StringBuilder line = new StringBuilder("  ");
                    if (this.frameIndex > 0) {
                        line.append("  ");
                    }
                    line.append(TraceTransferToInterpreterHelper.formatStackFrame(frameInstance, target)).append("\n");
                    ++this.frameIndex;
                    messageBuilder.append((CharSequence)line);
                    if (this.frameIndex < limit) {
                        return null;
                    }
                    messageBuilder.append("    ...\n");
                    return frameInstance;
                }
            });
            int skip = 3;
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            String suffix = stackTrace.length > 3 + limit ? "\n    ..." : "";
            messageBuilder.append(Arrays.stream(stackTrace).skip(3L).limit(limit).map(StackTraceElement::toString).collect(Collectors.joining("\n    ", "  ", suffix)));
            runtime.log(callTarget, messageBuilder.toString());
        }

        static {
            try {
                THREAD_EETOP_OFFSET = UNSAFE.objectFieldOffset(Thread.class.getDeclaredField("eetop"));
            }
            catch (Exception e) {
                throw new InternalError(e);
            }
        }
    }

    static final class Lazy
    extends BackgroundCompileQueue {
        StackIntrospection stackIntrospection;

        Lazy(AbstractHotSpotTruffleRuntime runtime) {
            super(runtime);
            runtime.installDefaultListeners();
        }

        @Override
        protected void compilerThreadIdled() {
            TruffleCompiler compiler = ((AbstractHotSpotTruffleRuntime)this.runtime).truffleCompiler;
            if (compiler != null) {
                ((HotSpotTruffleCompiler)compiler).purgeCaches();
            }
        }
    }
}

