/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.NodeVisitor;
import java.util.LinkedHashMap;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

public final class TraceCompilationPolymorphismListener
extends AbstractGraalTruffleRuntimeListener {
    private TraceCompilationPolymorphismListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceCompilationPolymorphismListener(runtime));
    }

    @Override
    public void onCompilationSuccess(final OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        if (target.getOptionValue(PolyglotCompilerOptions.TraceCompilationPolymorphism).booleanValue()) {
            target.accept(new NodeVisitor(){

                public boolean visit(Node node) {
                    if (node != null && (node.getCost() == NodeCost.MEGAMORPHIC || node.getCost() == NodeCost.POLYMORPHIC)) {
                        NodeCost cost = node.getCost();
                        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
                        props.put("simpleName", node.getClass().getSimpleName());
                        props.put("subtree", "\n" + NodeUtil.printCompactTreeToString((Node)node));
                        String msg = cost == NodeCost.MEGAMORPHIC ? "megamorphic" : "polymorphic";
                        TraceCompilationPolymorphismListener.this.runtime.logEvent(target, 0, msg, node.toString(), props, null);
                    }
                    return true;
                }
            });
        }
    }
}

