/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.SourceSection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

public final class TraceCompilationListener
extends AbstractGraalTruffleRuntimeListener {
    private final ThreadLocal<Times> currentCompilation = new ThreadLocal();
    private long startTime = System.nanoTime();

    private TraceCompilationListener(GraalTruffleRuntime runtime) {
        super(runtime);
    }

    public static void install(GraalTruffleRuntime runtime) {
        runtime.addListener(new TraceCompilationListener(runtime));
    }

    private static Map<String, Object> defaultProperties(OptimizedCallTarget target) {
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        properties.putAll(target.getDebugProperties());
        properties.put("Src", TraceCompilationListener.formatSourceSection(target.getRootNode().getSourceSection()));
        return properties;
    }

    private Map<String, Object> queueProperties(OptimizedCallTarget target) {
        Map<String, Object> properties = TraceCompilationListener.defaultProperties(target);
        properties.put("Queue", this.runtime.getCompilationQueueSize());
        properties.put("Time", System.nanoTime() - this.startTime);
        return properties;
    }

    @Override
    public void onCompilationQueued(OptimizedCallTarget target) {
        if (target.engine.traceCompilationDetails) {
            this.runtime.logEvent(target, 0, "opt queued", this.queueProperties(target));
        }
    }

    @Override
    public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason) {
        if (target.engine.traceCompilationDetails) {
            Map<String, Object> properties = this.queueProperties(target);
            properties.put("Reason", reason);
            this.runtime.logEvent(target, 0, "opt unqueued", properties);
        }
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            if (!TraceCompilationListener.isPermanentFailure(bailout, permanentBailout)) {
                this.onCompilationDequeued(target, null, "Non permanent bailout: " + reason);
            } else {
                Map<String, Object> properties = TraceCompilationListener.defaultProperties(target);
                properties.put("Reason", reason);
                this.runtime.logEvent(target, 0, "opt failed", properties);
            }
            this.currentCompilation.set(null);
        }
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target) {
        if (target.engine.traceCompilationDetails) {
            this.runtime.logEvent(target, 0, "opt start", TraceCompilationListener.defaultProperties(target));
        }
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            this.currentCompilation.set(new Times());
        }
    }

    @Override
    public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            this.runtime.logEvent(target, 0, "opt deopt", TraceCompilationListener.defaultProperties(target));
        }
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            Times current = this.currentCompilation.get();
            current.timePartialEvaluationFinished = System.nanoTime();
            current.nodeCountPartialEval = graph.getNodeCount();
        }
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        int inlinedCalls;
        if (!target.engine.traceCompilation && !target.engine.traceCompilationDetails) {
            return;
        }
        long timeCompilationFinished = System.nanoTime();
        int nodeCountLowered = graph.getNodeCount();
        Times compilation = this.currentCompilation.get();
        int calls = 0;
        if (inliningDecision == null) {
            CallCountVisitor visitor = new CallCountVisitor();
            target.accept(visitor);
            calls = visitor.calls;
            inlinedCalls = 0;
        } else {
            calls = inliningDecision.countCalls();
            inlinedCalls = inliningDecision.countInlinedCalls();
        }
        int dispatchedCalls = calls - inlinedCalls;
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        GraalTruffleRuntimeListener.addASTSizeProperty(target, properties);
        properties.put("Time", String.format("%4.0f(%4.0f+%-4.0f)ms", (double)(timeCompilationFinished - compilation.timeCompilationStarted) / 1000000.0, (double)(compilation.timePartialEvaluationFinished - compilation.timeCompilationStarted) / 1000000.0, (double)(timeCompilationFinished - compilation.timePartialEvaluationFinished) / 1000000.0));
        properties.put("Tier", target.isValidLastTier() ? "2" : "1");
        properties.put("Inlined", String.format("%3dY %3dN", inlinedCalls, dispatchedCalls));
        properties.put("IR", String.format("%5d/%5d", compilation.nodeCountPartialEval, nodeCountLowered));
        properties.put("CodeSize", result.getTargetCodeSize());
        if (target.getCodeAddress() != 0L) {
            properties.put("Addr", "0x" + Long.toHexString(target.getCodeAddress()));
        } else {
            properties.put("Addr", "N/A");
        }
        properties.put("Src", TraceCompilationListener.formatSourceSection(target.getRootNode().getSourceSection()));
        this.runtime.logEvent(target, 0, "opt done", properties);
        this.currentCompilation.set(null);
    }

    private static String formatSourceSection(SourceSection sourceSection) {
        if (sourceSection == null || sourceSection.getSource() == null) {
            return "n/a";
        }
        return String.format("%s:%d", sourceSection.getSource().getName(), sourceSection.getStartLine());
    }

    @Override
    public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        if (target.engine.traceCompilation || target.engine.traceCompilationDetails) {
            Map<String, Object> properties = TraceCompilationListener.defaultProperties(target);
            properties.put("Reason", reason);
            this.runtime.logEvent(target, 0, "opt inv.", properties);
        }
    }

    private static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }

    static final class CallCountVisitor
    implements NodeVisitor {
        int calls = 0;

        CallCountVisitor() {
        }

        public boolean visit(Node node) {
            if (node instanceof OptimizedDirectCallNode) {
                ++this.calls;
            }
            return true;
        }
    }

    private static final class Times {
        final long timeCompilationStarted = System.nanoTime();
        long timePartialEvaluationFinished;
        long nodeCountPartialEval;

        private Times() {
        }
    }
}

