/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.debug;

import com.oracle.truffle.api.frame.Frame;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.jfr.CompilationEvent;
import org.graalvm.compiler.truffle.jfr.CompilationStatisticsEvent;
import org.graalvm.compiler.truffle.jfr.DeoptimizationEvent;
import org.graalvm.compiler.truffle.jfr.EventFactory;
import org.graalvm.compiler.truffle.jfr.InvalidationEvent;
import org.graalvm.compiler.truffle.runtime.AbstractGraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.debug.CompilerDebugAccessor;
import org.graalvm.compiler.truffle.runtime.debug.TraceCompilationListener;
import org.graalvm.compiler.truffle.runtime.serviceprovider.TruffleRuntimeServices;
import org.graalvm.nativeimage.ImageInfo;

public final class JFRListener
extends AbstractGraalTruffleRuntimeListener {
    private static final EventFactory factory;
    private static final Set<InstrumentedMethodPattern> instrumentedMethodPatterns;
    private static final AtomicReference<InstrumentedFilterState> instrumentedFilterState;
    private static volatile Class<? extends Annotation> requiredAnnotation;
    private static volatile ResolvedJavaType resolvedJfrEventClass;
    private final ThreadLocal<CompilationData> currentCompilation = new ThreadLocal();
    private final Statistics statistics = new Statistics();

    private JFRListener(GraalTruffleRuntime runtime) {
        super(runtime);
        factory.addPeriodicEvent(CompilationStatisticsEvent.class, this.statistics);
    }

    public static void install(GraalTruffleRuntime runtime) {
        if (factory != null) {
            runtime.addListener(new JFRListener(runtime));
        }
    }

    public static boolean isInstrumented(ResolvedJavaMethod method) {
        InstrumentedFilterState currentState = instrumentedFilterState.get();
        if (currentState == InstrumentedFilterState.INACTIVE) {
            return false;
        }
        return JFRListener.isInstrumentedImpl(method, currentState);
    }

    @Override
    public void onCompilationStarted(OptimizedCallTarget target) {
        CompilationEvent event = null;
        if (factory != null) {
            event = factory.createCompilationEvent();
            if (event.isEnabled()) {
                event.setRootFunction(target);
                event.compilationStarted();
            } else {
                event = null;
            }
        }
        this.currentCompilation.set(new CompilationData(event));
    }

    @Override
    public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
        DeoptimizationEvent event;
        if (factory != null && (event = factory.createDeoptimizationEvent()).isEnabled()) {
            event.setRootFunction(target);
            event.publish();
        }
    }

    @Override
    public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
        CompilationData data = this.getCurrentData();
        if (data.event != null) {
            data.partialEvalNodeCount = graph.getNodeCount();
            data.timePartialEvaluationFinished = System.nanoTime();
        }
    }

    @Override
    public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout) {
        CompilationData data = this.getCurrentData();
        this.statistics.finishCompilation(data.finish(), bailout, 0);
        if (data.event != null) {
            data.event.failed(JFRListener.isPermanentFailure(bailout, permanentBailout), reason);
            data.event.publish();
        }
        this.currentCompilation.remove();
    }

    @Override
    public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
        CompilationData data = this.getCurrentData();
        int compiledCodeSize = result.getTargetCodeSize();
        this.statistics.finishCompilation(data.finish(), false, compiledCodeSize);
        if (data.event != null) {
            int inlinedCalls;
            CompilationEvent event = data.event;
            event.succeeded();
            event.setCompiledCodeSize(compiledCodeSize);
            if (target.getCodeAddress() != 0L) {
                event.setCompiledCodeAddress(target.getCodeAddress());
            }
            int calls = 0;
            if (inliningDecision == null) {
                TraceCompilationListener.CallCountVisitor visitor = new TraceCompilationListener.CallCountVisitor();
                target.accept(visitor);
                calls = visitor.calls;
                inlinedCalls = 0;
            } else {
                calls = inliningDecision.countCalls();
                inlinedCalls = inliningDecision.countInlinedCalls();
            }
            int dispatchedCalls = calls - inlinedCalls;
            event.setInlinedCalls(inlinedCalls);
            event.setDispatchedCalls(dispatchedCalls);
            event.setGraalNodeCount(graph.getNodeCount());
            event.setPartialEvaluationNodeCount(data.partialEvalNodeCount);
            event.setPartialEvaluationTime((data.timePartialEvaluationFinished - data.timeCompilationStarted) / 1000000L);
            event.publish();
            this.currentCompilation.remove();
        }
    }

    @Override
    public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
        InvalidationEvent event;
        this.statistics.invalidations.incrementAndGet();
        if (factory != null && (event = factory.createInvalidationEvent()).isEnabled()) {
            event.setRootFunction(target);
            event.setReason(reason);
            event.publish();
        }
    }

    private CompilationData getCurrentData() {
        return this.currentCompilation.get();
    }

    private static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }

    private static boolean isInstrumentedImpl(ResolvedJavaMethod method, InstrumentedFilterState state) {
        InstrumentedFilterState currentState = state;
        if (currentState == InstrumentedFilterState.NEW) {
            currentState = JFRListener.initializeInstrumentedFilter();
        }
        if (currentState == InstrumentedFilterState.NEW || currentState == InstrumentedFilterState.INACTIVE) {
            return false;
        }
        if (!method.isSynthetic() || method.isBridge() || method.isStatic()) {
            return false;
        }
        ResolvedJavaType methodOwner = method.getDeclaringClass();
        if (JFRListener.getAnnotation(requiredAnnotation, (AnnotatedElement)methodOwner) == null) {
            return false;
        }
        if (!instrumentedMethodPatterns.contains(new InstrumentedMethodPattern(method))) {
            return false;
        }
        ResolvedJavaType patternOwner = JFRListener.getJFREventClass(methodOwner);
        return patternOwner != null && patternOwner.isAssignableFrom(methodOwner);
    }

    private static InstrumentedFilterState initializeInstrumentedFilter() {
        if (!ImageInfo.inImageBuildtimeCode()) {
            if (factory != null) {
                requiredAnnotation = factory.getRequiredAnnotation();
                factory.addInitializationListener(() -> instrumentedFilterState.set(InstrumentedFilterState.ACTIVE));
                InstrumentedFilterState currentState = factory.isInitialized() ? InstrumentedFilterState.ACTIVE : InstrumentedFilterState.INACTIVE;
                instrumentedFilterState.compareAndSet(InstrumentedFilterState.NEW, currentState);
            } else {
                instrumentedFilterState.set(InstrumentedFilterState.INACTIVE);
            }
        }
        return instrumentedFilterState.get();
    }

    private static ResolvedJavaType getJFREventClass(ResolvedJavaType accessingClass) {
        if (resolvedJfrEventClass == null) {
            try {
                resolvedJfrEventClass = UnresolvedJavaType.create((String)"Ljdk/jfr/Event;").resolve(accessingClass);
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return resolvedJfrEventClass;
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, AnnotatedElement element) {
        try {
            return (T)((Annotation)annotationClass.cast(element.getAnnotation(annotationClass)));
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    private static Set<InstrumentedMethodPattern> createInstrumentedPatterns() {
        HashSet<InstrumentedMethodPattern> patterns = new HashSet<InstrumentedMethodPattern>();
        patterns.add(new InstrumentedMethodPattern("begin", "()V"));
        patterns.add(new InstrumentedMethodPattern("commit", "()V"));
        patterns.add(new InstrumentedMethodPattern("end", "()V"));
        patterns.add(new InstrumentedMethodPattern("isEnabled", "()Z"));
        patterns.add(new InstrumentedMethodPattern("set", "(ILjava/lang/Object;)V"));
        patterns.add(new InstrumentedMethodPattern("shouldCommit", "()Z"));
        return patterns;
    }

    static {
        if (ImageInfo.inImageCode()) {
            factory = null;
        } else {
            EventFactory.Provider provider;
            Iterator<EventFactory.Provider> it = TruffleRuntimeServices.load(EventFactory.Provider.class).iterator();
            EventFactory.Provider provider2 = provider = it.hasNext() ? it.next() : null;
            if (provider == null) {
                factory = null;
            } else {
                CompilerDebugAccessor.jdkServicesAccessor().exportTo(provider.getClass());
                factory = provider == null ? null : provider.getEventFactory();
            }
        }
        instrumentedMethodPatterns = JFRListener.createInstrumentedPatterns();
        instrumentedFilterState = new AtomicReference<InstrumentedFilterState>(InstrumentedFilterState.NEW);
    }

    private static final class InstrumentedMethodPattern {
        private final String name;
        private final String signature;

        private InstrumentedMethodPattern(ResolvedJavaMethod method) {
            this(method.getName(), method.getSignature().toMethodDescriptor());
        }

        private InstrumentedMethodPattern(String name, String signature) {
            this.name = name;
            this.signature = signature;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            InstrumentedMethodPattern otherPattern = (InstrumentedMethodPattern)other;
            return this.name.equals(otherPattern.name) && this.signature.equals(otherPattern.signature);
        }
    }

    private static enum InstrumentedFilterState {
        NEW,
        ACTIVE,
        INACTIVE;

    }

    private static final class Statistics
    implements Runnable {
        private long compiledMethods;
        private long bailouts;
        private long compiledCodeSize;
        private long totalTime;
        private int peakTime;
        final AtomicLong invalidations = new AtomicLong();

        Statistics() {
        }

        synchronized void finishCompilation(int time, boolean bailout, int codeSize) {
            ++this.compiledMethods;
            if (bailout) {
                ++this.bailouts;
            }
            this.compiledCodeSize += (long)codeSize;
            this.totalTime += (long)time;
            this.peakTime = Math.max(this.peakTime, time);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompilationStatisticsEvent event = factory.createCompilationStatisticsEvent();
            if (event.isEnabled()) {
                Statistics statistics = this;
                synchronized (statistics) {
                    event.setCompiledMethods(this.compiledMethods);
                    event.setBailouts(this.bailouts);
                    event.setInvalidations(this.invalidations.get());
                    event.setCompiledCodeSize(this.compiledCodeSize);
                    event.setTotalTime(this.totalTime);
                    event.setPeakTime(this.peakTime);
                    event.publish();
                }
            }
        }
    }

    private static final class CompilationData {
        final CompilationEvent event;
        final long timeCompilationStarted;
        int partialEvalNodeCount;
        long timePartialEvaluationFinished;

        CompilationData(CompilationEvent event) {
            this.event = event;
            this.timeCompilationStarted = System.nanoTime();
        }

        int finish() {
            return (int)(System.nanoTime() - this.timeCompilationStarted) / 1000000;
        }
    }
}

