/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.RootNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleSourceLanguagePosition;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleNodeSources;
import org.graalvm.graphio.GraphBlocks;
import org.graalvm.graphio.GraphOutput;
import org.graalvm.graphio.GraphStructure;

public final class TruffleTreeDumper {
    private static final ASTDumpStructure AST_DUMP_STRUCTURE = new ASTDumpStructure();
    private static final String AFTER_PROFILING = "After Profiling";

    private TruffleTreeDumper() {
    }

    public static void dump(TruffleDebugContext debug, OptimizedCallTarget callTarget) {
        if (GraalTruffleRuntime.getRuntime().isPrintGraphEnabled()) {
            try {
                TruffleTreeDumper.dumpASTAndCallTrees(debug, callTarget, new TruffleNodeSources());
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to dump AST: " + callTarget, ex);
            }
        }
    }

    private static void dumpASTAndCallTrees(TruffleDebugContext debug, OptimizedCallTarget callTarget, TruffleNodeSources nodeSources) throws IOException {
        if (callTarget.getRootNode() != null) {
            AST ast = new AST(callTarget, nodeSources);
            GraphOutput<AST, ?> astOutput = debug.buildOutput(GraphOutput.newBuilder(AST_DUMP_STRUCTURE).blocks(AST_DUMP_STRUCTURE));
            astOutput.beginGroup(ast, "AST", "AST", null, 0, debug.getVersionProperties());
            astOutput.print(ast, Collections.emptyMap(), 0, AFTER_PROFILING, new Object[0]);
            astOutput.endGroup();
            astOutput.close();
        }
    }

    private static void readNodeProperties(ASTNode astNode, Node node) {
        NodeClass nodeClass = NodeClass.get((Node)node);
        for (NodeFieldAccessor field : TruffleTreeDumper.findNodeFields(nodeClass)) {
            if (!TruffleTreeDumper.isDataField(nodeClass, field)) continue;
            String key = TruffleTreeDumper.findFieldName(nodeClass, field);
            Object value = TruffleTreeDumper.findFieldValue(nodeClass, field, node);
            astNode.properties.put(key, value);
        }
    }

    private static void copyDebugProperties(ASTNode astNode, Node node) {
        Map debugProperties = node.getDebugProperties();
        for (Map.Entry property : debugProperties.entrySet()) {
            astNode.properties.put((String)property.getKey(), property.getValue());
        }
    }

    private static LinkedHashMap<String, Node> findNamedNodeChildren(Node node) {
        LinkedHashMap<String, Node> nodes = new LinkedHashMap<String, Node>();
        NodeClass nodeClass = NodeClass.get((Node)node);
        for (NodeFieldAccessor field : TruffleTreeDumper.findNodeFields(nodeClass)) {
            Object value;
            if (TruffleTreeDumper.isChildField(nodeClass, field)) {
                value = TruffleTreeDumper.findFieldObject(nodeClass, field, node);
                if (value == null) continue;
                nodes.put(TruffleTreeDumper.findFieldName(nodeClass, field), (Node)value);
                continue;
            }
            if (!TruffleTreeDumper.isChildrenField(nodeClass, field) || (value = TruffleTreeDumper.findFieldObject(nodeClass, field, node)) == null) continue;
            Object[] children = (Object[])value;
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null) continue;
                nodes.put(TruffleTreeDumper.findFieldName(nodeClass, field) + "[" + i + "]", (Node)children[i]);
            }
        }
        return nodes;
    }

    private static Object findFieldValue(NodeClass nodeClass, NodeFieldAccessor field, Node node) {
        return field.loadValue(node);
    }

    private static Iterable<NodeFieldAccessor> findNodeFields(NodeClass nodeClass) {
        return Arrays.asList(nodeClass.getFields());
    }

    private static boolean isChildField(NodeClass nodeClass, NodeFieldAccessor field) {
        return field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD;
    }

    private static boolean isChildrenField(NodeClass nodeClass, NodeFieldAccessor field) {
        return field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN;
    }

    private static Object findFieldObject(NodeClass nodeClass, NodeFieldAccessor field, Node node) {
        return field.getObject(node);
    }

    private static String findFieldName(NodeClass nodeClass, NodeFieldAccessor field) {
        return field.getName();
    }

    private static boolean isDataField(NodeClass nodeClass, NodeFieldAccessor field) {
        return !TruffleTreeDumper.isChildField(nodeClass, field) && !TruffleTreeDumper.isChildrenField(nodeClass, field);
    }

    static class ASTDumpStructure
    implements GraphStructure<AST, ASTNode, ASTNodeClass, List<ASTEdge>>,
    GraphBlocks<AST, ASTBlock, ASTNode> {
        ASTDumpStructure() {
        }

        @Override
        public AST graph(AST currentGraph, Object obj) {
            return obj instanceof AST ? (AST)obj : null;
        }

        @Override
        public Iterable<? extends ASTNode> nodes(AST graph) {
            return graph.nodes.getValues();
        }

        @Override
        public int nodesCount(AST graph) {
            return graph.nodes.size();
        }

        @Override
        public int nodeId(ASTNode node) {
            return node.id;
        }

        @Override
        public boolean nodeHasPredecessor(ASTNode node) {
            return false;
        }

        @Override
        public void nodeProperties(AST graph, ASTNode node, Map<String, ? super Object> properties) {
            properties.putAll(node.properties);
        }

        @Override
        public ASTNode node(Object obj) {
            return obj instanceof ASTNode ? (ASTNode)obj : null;
        }

        @Override
        public ASTNodeClass nodeClass(Object obj) {
            return obj instanceof ASTNodeClass ? (ASTNodeClass)obj : null;
        }

        @Override
        public ASTNodeClass classForNode(ASTNode node) {
            return node.nodeClass;
        }

        @Override
        public String nameTemplate(ASTNodeClass nodeClass) {
            return "{p#label}";
        }

        @Override
        public Object nodeClassType(ASTNodeClass nodeClass) {
            return nodeClass.node.source.getClass();
        }

        @Override
        public List<ASTEdge> portInputs(ASTNodeClass nodeClass) {
            return Collections.emptyList();
        }

        @Override
        public List<ASTEdge> portOutputs(ASTNodeClass nodeClass) {
            return nodeClass.node.edges;
        }

        @Override
        public int portSize(List<ASTEdge> port) {
            return port.size();
        }

        @Override
        public boolean edgeDirect(List<ASTEdge> port, int index) {
            return true;
        }

        @Override
        public String edgeName(List<ASTEdge> port, int index) {
            return port.get((int)index).label;
        }

        @Override
        public Object edgeType(List<ASTEdge> port, int index) {
            return EdgeType.EDGE_TYPE;
        }

        @Override
        public Collection<? extends ASTNode> edgeNodes(AST graph, ASTNode node, List<ASTEdge> port, int index) {
            ArrayList<ASTNode> singleton = new ArrayList<ASTNode>(1);
            singleton.add(port.get((int)index).node);
            return singleton;
        }

        @Override
        public Collection<? extends ASTBlock> blocks(AST graph) {
            return graph.blocks;
        }

        @Override
        public int blockId(ASTBlock block) {
            return block.id;
        }

        @Override
        public Collection<? extends ASTNode> blockNodes(AST info, ASTBlock block) {
            return block.nodes;
        }

        @Override
        public Collection<? extends ASTBlock> blockSuccessors(ASTBlock block) {
            return block.successors;
        }
    }

    static class ASTBlock {
        final int id;
        final List<ASTBlock> successors = new ArrayList<ASTBlock>();
        final List<ASTNode> nodes = new ArrayList<ASTNode>();

        ASTBlock(int id) {
            this.id = id;
        }
    }

    static class ASTNodeClass {
        final ASTNode node;

        ASTNodeClass(ASTNode node) {
            this.node = node;
        }
    }

    static enum EdgeType {
        EDGE_TYPE;

    }

    static class ASTEdge {
        final ASTNode node;
        final String label;

        ASTEdge(ASTNode node, String label) {
            this.node = node;
            this.label = label;
        }
    }

    static class ASTNode {
        Node source;
        List<ASTEdge> edges = new ArrayList<ASTEdge>();
        final int id;
        Map<String, ? super Object> properties = new LinkedHashMap<String, Object>();
        ASTNodeClass nodeClass;

        ASTNode(Node source, TruffleSourceLanguagePosition sourcePosition) {
            this.source = source;
            this.id = sourcePosition.getNodeId();
            this.setNewClass();
            ASTNode.setBasicProperties(this.properties, source);
            TruffleTreeDumper.readNodeProperties(this, source);
            TruffleTreeDumper.copyDebugProperties(this, source);
        }

        private static void setBasicProperties(Map<String, ? super Object> properties, Node source) {
            String className = ASTNode.className(source.getClass());
            properties.put("label", ASTNode.dropNodeSuffix(className));
            properties.put("cost", source.getCost());
            NodeInfo nodeInfo = source.getClass().getAnnotation(NodeInfo.class);
            if (nodeInfo != null && !nodeInfo.shortName().isEmpty()) {
                properties.put("shortName", nodeInfo.shortName());
            }
            if (Introspection.isIntrospectable((Node)source)) {
                List specializations = Introspection.getSpecializations((Node)source);
                for (Introspection.SpecializationInfo specialization : specializations) {
                    String methodName = "specialization." + specialization.getMethodName();
                    String state = specialization.isActive() ? "active" : (specialization.isExcluded() ? "excluded" : "inactive");
                    properties.put(methodName, state);
                    if (specialization.getInstances() <= 1 && (specialization.getInstances() != 1 || specialization.getCachedData(0).size() <= 0)) continue;
                    properties.put(methodName + ".instances", (Object)specialization.getInstances());
                    for (int instance = 0; instance < specialization.getInstances(); ++instance) {
                        List cachedData = specialization.getCachedData(instance);
                        int cachedIndex = 0;
                        for (Object o : cachedData) {
                            properties.put(methodName + ".instance[" + instance + "].cached[" + cachedIndex + "]", o);
                            ++cachedIndex;
                        }
                    }
                }
            }
        }

        static String className(Class<?> clazz) {
            String name = clazz.getName();
            return name.substring(name.lastIndexOf(46) + 1);
        }

        private static String dropNodeSuffix(String className) {
            return className.replaceFirst("Node$", "");
        }

        void setNewClass() {
            this.nodeClass = new ASTNodeClass(this);
        }
    }

    static class AST {
        final ASTNode root;
        final EconomicMap<Node, ASTNode> nodes = EconomicMap.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
        final List<ASTBlock> blocks = new ArrayList<ASTBlock>();

        AST(RootCallTarget target, TruffleNodeSources nodeSources) {
            ASTBlock astBlock = this.makeASTBlock();
            RootNode rootNode = target.getRootNode();
            this.root = this.makeASTNode((Node)rootNode, nodeSources);
            astBlock.nodes.add(this.root);
            AST.traverseNodes((Node)rootNode, this.root, this, null, nodeSources, astBlock);
        }

        ASTNode makeASTNode(Node source, TruffleNodeSources nodeSources) {
            ASTNode seen = (ASTNode)this.nodes.get((Object)source);
            if (seen != null) {
                return seen;
            }
            ASTNode astNode = new ASTNode(source, nodeSources.getSourceLocation(source));
            this.nodes.put((Object)source, (Object)astNode);
            return astNode;
        }

        ASTNode findASTNode(Node source) {
            return (ASTNode)this.nodes.get((Object)source);
        }

        ASTBlock makeASTBlock() {
            ASTBlock astBlock = new ASTBlock(this.blocks.size());
            this.blocks.add(astBlock);
            return astBlock;
        }

        private static void traverseNodes(Node parent, ASTNode astParent, AST ast, TruffleInlining inliningDecisions, TruffleNodeSources nodeSources, ASTBlock currentBlock) {
            for (Map.Entry entry : TruffleTreeDumper.findNamedNodeChildren(parent).entrySet()) {
                String label = (String)entry.getKey();
                Node node = (Node)entry.getValue();
                ASTNode astNode = ast.makeASTNode(node, nodeSources);
                currentBlock.nodes.add(astNode);
                astParent.edges.add(new ASTEdge(astNode, label));
                AST.traverseNodes(node, astNode, ast, inliningDecisions, nodeSources, currentBlock);
            }
        }
    }
}

