/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.ValueProfile;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

@NodeInfo
public final class OptimizedIndirectCallNode
extends IndirectCallNode {
    @CompilerDirectives.CompilationFinal
    private ValueProfile exceptionProfile;
    @CompilerDirectives.CompilationFinal
    private boolean seenInInterpreter;

    OptimizedIndirectCallNode() {
    }

    public Object call(CallTarget target, Object ... arguments) {
        try {
            OptimizedCallTarget optimizedTarget = (OptimizedCallTarget)target;
            if (CompilerDirectives.inInterpreter() && !this.seenInInterpreter) {
                this.seenInInterpreter = true;
            }
            if (this.seenInInterpreter) {
                optimizedTarget.stopProfilingArguments();
            } else {
                OptimizedIndirectCallNode.profileIndirectArguments(optimizedTarget, arguments);
            }
            return optimizedTarget.callIndirect((Node)this, arguments);
        }
        catch (Throwable t) {
            if (this.exceptionProfile == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.exceptionProfile = ValueProfile.createClassProfile();
            }
            Throwable profiledT = (Throwable)this.exceptionProfile.profile((Object)t);
            GraalRuntimeAccessor.LANGUAGE.onThrowable((Node)this, null, profiledT, null);
            throw OptimizedCallTarget.rethrow(profiledT);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void profileIndirectArguments(OptimizedCallTarget optimizedTarget, Object ... arguments) {
        optimizedTarget.profileArguments(arguments);
    }
}

