/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.frame.Frame;
import java.util.Map;
import org.graalvm.compiler.truffle.common.TruffleCompilerListener;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;

public interface GraalTruffleRuntimeListener {
    default public void onCompilationSplit(OptimizedDirectCallNode callNode) {
    }

    default public void onCompilationSplitFailed(OptimizedDirectCallNode callNode, CharSequence reason) {
    }

    default public void onCompilationQueued(OptimizedCallTarget target) {
    }

    default public void onCompilationDequeued(OptimizedCallTarget target, Object source, CharSequence reason) {
    }

    default public void onCompilationStarted(OptimizedCallTarget target) {
    }

    default public void onCompilationTruffleTierFinished(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph) {
    }

    default public void onCompilationGraalTierFinished(OptimizedCallTarget target, TruffleCompilerListener.GraphInfo graph) {
    }

    default public void onCompilationSuccess(OptimizedCallTarget target, TruffleInlining inliningDecision, TruffleCompilerListener.GraphInfo graph, TruffleCompilerListener.CompilationResultInfo result) {
    }

    default public void onCompilationFailed(OptimizedCallTarget target, String reason, boolean bailout, boolean permanentBailout) {
    }

    default public void onCompilationInvalidated(OptimizedCallTarget target, Object source, CharSequence reason) {
    }

    default public void onCompilationDeoptimized(OptimizedCallTarget target, Frame frame) {
    }

    default public void onShutdown() {
    }

    default public void onEngineClosed(EngineData runtimeData) {
    }

    public static void addASTSizeProperty(OptimizedCallTarget target, Map<String, Object> properties) {
        int nodeCount = target.getNonTrivialNodeCount();
        properties.put("AST", String.format("%4d", nodeCount));
    }

    public static boolean isPermanentFailure(boolean bailout, boolean permanentBailout) {
        return !bailout || permanentBailout;
    }
}

