/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.ArrayUtils;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.OptimizationFailedException;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.AbstractAssumption;
import com.oracle.truffle.api.impl.TVMCI;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.LayoutFactory;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.stack.InspectedFrame;
import jdk.vm.ci.code.stack.InspectedFrameVisitor;
import jdk.vm.ci.code.stack.StackIntrospection;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.OptimizedAssumptionDependency;
import org.graalvm.compiler.truffle.common.TruffleCompilation;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.common.TruffleCompiler;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.TruffleDebugJavaMethod;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.common.TruffleOutputGroup;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.CompilationTask;
import org.graalvm.compiler.truffle.runtime.EngineCacheSupport;
import org.graalvm.compiler.truffle.runtime.EngineData;
import org.graalvm.compiler.truffle.runtime.FloodControlHandler;
import org.graalvm.compiler.truffle.runtime.FrameWithoutBoxing;
import org.graalvm.compiler.truffle.runtime.GraalCompilerDirectives;
import org.graalvm.compiler.truffle.runtime.GraalCompilerOptions;
import org.graalvm.compiler.truffle.runtime.GraalFrameInstance;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeServiceProvider;
import org.graalvm.compiler.truffle.runtime.GraalTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTestTVMCI;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListener;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntimeListenerDispatcher;
import org.graalvm.compiler.truffle.runtime.InlineDecision;
import org.graalvm.compiler.truffle.runtime.LoopNodeFactory;
import org.graalvm.compiler.truffle.runtime.OptimizedAssumption;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.OptimizedDirectCallNode;
import org.graalvm.compiler.truffle.runtime.OptimizedIndirectCallNode;
import org.graalvm.compiler.truffle.runtime.TruffleCallBoundary;
import org.graalvm.compiler.truffle.runtime.TruffleInlining;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;
import org.graalvm.compiler.truffle.runtime.TruffleTreeDumper;
import org.graalvm.compiler.truffle.runtime.TruffleTypes;
import org.graalvm.compiler.truffle.runtime.debug.JFRListener;
import org.graalvm.compiler.truffle.runtime.debug.StatisticsListener;
import org.graalvm.compiler.truffle.runtime.debug.TraceASTCompilationListener;
import org.graalvm.compiler.truffle.runtime.debug.TraceCompilationListener;
import org.graalvm.compiler.truffle.runtime.debug.TraceCompilationPolymorphismListener;
import org.graalvm.compiler.truffle.runtime.debug.TraceSplittingListener;
import org.graalvm.compiler.truffle.runtime.serviceprovider.TruffleRuntimeServices;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.options.OptionKey;
import org.graalvm.options.OptionValues;

public abstract class GraalTruffleRuntime
implements TruffleRuntime,
TruffleCompilerRuntime {
    private static final int JAVA_SPECIFICATION_VERSION = GraalTruffleRuntime.getJavaSpecificationVersion();
    private static final boolean Java8OrEarlier = JAVA_SPECIFICATION_VERSION <= 8;
    private final GraalTruffleRuntimeListenerDispatcher listeners = new GraalTruffleRuntimeListenerDispatcher();
    protected volatile TruffleCompiler truffleCompiler;
    protected CallMethods callMethods;
    private final GraalTVMCI tvmci = new GraalTVMCI();
    private volatile GraalTestTVMCI testTvmci;
    private final LoopNodeFactory loopNodeFactory;
    private final EngineCacheSupport engineCacheSupport;
    private final UnmodifiableEconomicMap<String, Class<?>> lookupTypes;
    private final OptionDescriptors engineOptions;
    private final FloodControlHandler floodControlHandler;

    protected void clearState() {
        assert (TruffleOptions.AOT) : "Must be called only in AOT mode.";
        this.callMethods = null;
    }

    public static GraalTruffleRuntime getRuntime() {
        return (GraalTruffleRuntime)Truffle.getRuntime();
    }

    public GraalTruffleRuntime(Iterable<Class<?>> extraLookupTypes) {
        this.lookupTypes = GraalTruffleRuntime.initLookupTypes(extraLookupTypes);
        ArrayList<OptionDescriptors> options = new ArrayList<OptionDescriptors>();
        this.loopNodeFactory = GraalTruffleRuntime.loadGraalRuntimeServiceProvider(LoopNodeFactory.class, options, true);
        EngineCacheSupport support = GraalTruffleRuntime.loadGraalRuntimeServiceProvider(EngineCacheSupport.class, options, false);
        this.engineCacheSupport = support == null ? new EngineCacheSupport.Disabled() : support;
        options.add(PolyglotCompilerOptions.getDescriptors());
        this.engineOptions = OptionDescriptors.createUnion((OptionDescriptors[])options.toArray(new OptionDescriptors[options.size()]));
        this.floodControlHandler = GraalTruffleRuntime.loadGraalRuntimeServiceProvider(FloodControlHandler.class, null, false);
    }

    @Override
    public TruffleMetaAccessProvider createInliningPlan() {
        return new TruffleInlining();
    }

    public String getName() {
        String suffix;
        String compilerConfigurationName = this.getCompilerConfigurationName();
        assert (compilerConfigurationName != null);
        if (compilerConfigurationName == null) {
            suffix = "Unknown";
        } else if (compilerConfigurationName.equals("community")) {
            suffix = "CE";
        } else if (compilerConfigurationName.equals("enterprise")) {
            suffix = "EE";
        } else {
            assert (false) : "unexpected compiler configuration name: " + compilerConfigurationName;
            suffix = compilerConfigurationName;
        }
        return "GraalVM " + suffix;
    }

    protected abstract String getCompilerConfigurationName();

    protected GraalTVMCI getTvmci() {
        return this.tvmci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TVMCI.Test<?, ?> getTestTvmci() {
        if (this.testTvmci == null) {
            GraalTruffleRuntime graalTruffleRuntime = this;
            synchronized (graalTruffleRuntime) {
                if (this.testTvmci == null) {
                    this.testTvmci = new GraalTestTVMCI(this);
                }
            }
        }
        return this.testTvmci;
    }

    @Override
    public CompilableTruffleAST asCompilableTruffleAST(JavaConstant constant) {
        return this.asObject(OptimizedCallTarget.class, constant);
    }

    @Override
    public JavaConstant getCallTargetForCallNode(JavaConstant callNodeConstant) {
        OptimizedDirectCallNode callNode = this.asObject(OptimizedDirectCallNode.class, callNodeConstant);
        return this.forObject(callNode.getCallTarget());
    }

    @Override
    public Consumer<OptimizedAssumptionDependency> registerOptimizedAssumptionDependency(JavaConstant optimizedAssumptionConstant) {
        OptimizedAssumption optimizedAssumption = this.asObject(OptimizedAssumption.class, optimizedAssumptionConstant);
        return optimizedAssumption.registerDependency();
    }

    protected abstract JavaConstant forObject(Object var1);

    protected abstract <T> T asObject(Class<T> var1, JavaConstant var2);

    protected abstract boolean isPrintGraphEnabled();

    public abstract TruffleCompiler newTruffleCompiler();

    private static <T> T loadServiceProvider(Class<T> clazz, boolean failIfNotFound) {
        Iterable<T> providers = ImageInfo.inImageBuildtimeCode() ? ServiceLoader.load(clazz) : TruffleRuntimeServices.load(clazz);
        boolean priorityService = GraalRuntimeServiceProvider.class.isAssignableFrom(clazz);
        T bestFactory = null;
        int bestPriority = 0;
        for (T factory : providers) {
            int currentPriority = priorityService ? ((GraalRuntimeServiceProvider)factory).getPriority() : 0;
            if (bestFactory != null && currentPriority <= bestPriority) continue;
            bestFactory = factory;
            bestPriority = currentPriority;
        }
        if (bestFactory == null && failIfNotFound) {
            throw new IllegalStateException("Unable to load a factory for " + clazz.getName());
        }
        return bestFactory;
    }

    private static <T extends GraalRuntimeServiceProvider> T loadGraalRuntimeServiceProvider(Class<T> clazz, List<OptionDescriptors> descriptors, boolean failIfNotFound) {
        OptionDescriptors serviceOptions;
        GraalRuntimeServiceProvider bestFactory = (GraalRuntimeServiceProvider)GraalTruffleRuntime.loadServiceProvider(clazz, failIfNotFound);
        if (descriptors != null && bestFactory != null && (serviceOptions = bestFactory.getEngineOptions()) != null) {
            descriptors.add(serviceOptions);
        }
        return (T)bestFactory;
    }

    @Override
    public TruffleCompilerRuntime.ConstantFieldInfo getConstantFieldInfo(ResolvedJavaField field) {
        for (Annotation a : GraalTruffleRuntime.getAnnotations(field)) {
            if (a.annotationType() == Node.Child.class) {
                return TruffleCompilerRuntime.ConstantFieldInfo.CHILD;
            }
            if (a.annotationType() == Node.Children.class) {
                return TruffleCompilerRuntime.ConstantFieldInfo.CHILDREN;
            }
            if (a.annotationType() != CompilerDirectives.CompilationFinal.class) continue;
            CompilerDirectives.CompilationFinal cf = (CompilerDirectives.CompilationFinal)a;
            int dimensions = GraalTruffleRuntime.actualStableDimensions(field, cf.dimensions());
            return TruffleCompilerRuntime.ConstantFieldInfo.forDimensions(dimensions);
        }
        return null;
    }

    private static int actualStableDimensions(ResolvedJavaField field, int dimensions) {
        if (dimensions == 0) {
            return 0;
        }
        int arrayDim = GraalTruffleRuntime.getArrayDimensions(field.getType());
        if (dimensions < 0) {
            if (dimensions != -1) {
                throw new IllegalArgumentException("Negative @CompilationFinal dimensions");
            }
            return arrayDim;
        }
        if (dimensions > arrayDim) {
            throw new IllegalArgumentException(String.format("@CompilationFinal(dimensions=%d) exceeds declared array dimensions (%d) of field %s", dimensions, arrayDim, field));
        }
        return dimensions;
    }

    private static int getArrayDimensions(JavaType type) {
        int dimensions = 0;
        JavaType componentType = type;
        while (componentType.isArray()) {
            ++dimensions;
            componentType = componentType.getComponentType();
        }
        return dimensions;
    }

    @Override
    public TruffleCompilerRuntime.LoopExplosionKind getLoopExplosionKind(ResolvedJavaMethod method) {
        ExplodeLoop explodeLoop = GraalTruffleRuntime.getAnnotation(ExplodeLoop.class, method);
        if (explodeLoop == null) {
            return TruffleCompilerRuntime.LoopExplosionKind.NONE;
        }
        switch (explodeLoop.kind()) {
            case FULL_UNROLL: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_UNROLL;
            }
            case FULL_UNROLL_UNTIL_RETURN: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN;
            }
            case FULL_EXPLODE: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_EXPLODE;
            }
            case FULL_EXPLODE_UNTIL_RETURN: {
                return TruffleCompilerRuntime.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN;
            }
            case MERGE_EXPLODE: {
                return TruffleCompilerRuntime.LoopExplosionKind.MERGE_EXPLODE;
            }
        }
        throw new InternalError(String.format("Unknown Truffle LoopExplosionKind %s", explodeLoop.kind()));
    }

    private static UnmodifiableEconomicMap<String, Class<?>> initLookupTypes(Iterable<Class<?>> extraTypes) {
        EconomicMap m = EconomicMap.create();
        for (Class c : new Class[]{Node.class, UnexpectedResultException.class, SlowPathException.class, OptimizedCallTarget.class, OptimizedDirectCallNode.class, OptimizedAssumption.class, CompilerDirectives.class, GraalCompilerDirectives.class, InlineDecision.class, CompilerAsserts.class, ExactMath.class, ArrayUtils.class, FrameDescriptor.class, FrameSlot.class, FrameSlotKind.class, MethodHandle.class, ArrayList.class, FrameSlotKind.class, AbstractAssumption.class, MaterializedFrame.class, FrameWithoutBoxing.class, BranchProfile.class, ConditionProfile.class, Objects.class}) {
            m.put((Object)c.getName(), (Object)c);
        }
        for (Class clazz : extraTypes) {
            m.put((Object)clazz.getName(), (Object)clazz);
        }
        for (TruffleTypes truffleTypes : TruffleRuntimeServices.load(TruffleTypes.class)) {
            for (Class<?> c : truffleTypes.getTypes()) {
                m.put((Object)c.getName(), c);
            }
        }
        if (JAVA_SPECIFICATION_VERSION >= 15) {
            String className = "jdk.internal.access.foreign.MemorySegmentProxy";
            try {
                Class<?> clazz = Class.forName(className);
                m.put((Object)clazz.getName(), clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(className);
            }
        }
        return m;
    }

    @Override
    public ResolvedJavaType resolveType(MetaAccessProvider metaAccess, String className, boolean required) {
        Class c = (Class)this.lookupTypes.get((Object)className);
        if (c == null) {
            if (!required) {
                return null;
            }
            throw new NoClassDefFoundError(className);
        }
        return metaAccess.lookupJavaType(c);
    }

    protected void installDefaultListeners() {
        TraceCompilationListener.install(this);
        TraceCompilationPolymorphismListener.install(this);
        TraceSplittingListener.install(this);
        StatisticsListener.install(this);
        TraceASTCompilationListener.install(this);
        JFRListener.install(this);
        TruffleSplittingStrategy.installListener(this);
        Runtime.getRuntime().addShutdownHook(new Thread(this::shutdown));
    }

    protected void lookupCallMethods(MetaAccessProvider metaAccess) {
        this.callMethods = CallMethods.lookup(metaAccess);
    }

    public void markFrameMaterializeCalled(FrameDescriptor descriptor) {
        GraalRuntimeAccessor.FRAME.markMaterializeCalled(descriptor);
    }

    public boolean getFrameMaterializeCalled(FrameDescriptor descriptor) {
        return GraalRuntimeAccessor.FRAME.getMaterializeCalled(descriptor);
    }

    public LoopNode createLoopNode(RepeatingNode repeatingNode) {
        if (!(repeatingNode instanceof Node)) {
            throw new IllegalArgumentException("Repeating node must be of type Node.");
        }
        return this.getLoopNodeFactory().create(repeatingNode);
    }

    protected final LoopNodeFactory getLoopNodeFactory() {
        return this.loopNodeFactory;
    }

    public final EngineCacheSupport getEngineCacheSupport() {
        return this.engineCacheSupport;
    }

    public DirectCallNode createDirectCallNode(CallTarget target) {
        if (target instanceof OptimizedCallTarget) {
            OptimizedCallTarget optimizedTarget = (OptimizedCallTarget)target;
            OptimizedDirectCallNode directCallNode = new OptimizedDirectCallNode(optimizedTarget);
            optimizedTarget.addDirectCallNode(directCallNode);
            return directCallNode;
        }
        throw new IllegalStateException(String.format("Unexpected call target class %s!", target.getClass()));
    }

    public IndirectCallNode createIndirectCallNode() {
        return new OptimizedIndirectCallNode();
    }

    public VirtualFrame createVirtualFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return OptimizedCallTarget.createFrame(frameDescriptor, arguments);
    }

    public MaterializedFrame createMaterializedFrame(Object[] arguments) {
        return this.createMaterializedFrame(arguments, new FrameDescriptor());
    }

    public MaterializedFrame createMaterializedFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return new FrameWithoutBoxing(frameDescriptor, arguments);
    }

    public CompilerOptions createCompilerOptions() {
        return new GraalCompilerOptions();
    }

    public Assumption createAssumption() {
        return this.createAssumption(null);
    }

    public Assumption createAssumption(String name) {
        return new OptimizedAssumption(name);
    }

    public GraalTruffleRuntimeListener getListener() {
        return this.listeners;
    }

    @CompilerDirectives.TruffleBoundary
    public <T> T iterateFrames(FrameInstanceVisitor<T> visitor) {
        return this.iterateImpl(visitor, 0);
    }

    private <T> T iterateImpl(FrameInstanceVisitor<T> visitor, int skip) {
        CallMethods methods = this.getCallMethods();
        FrameVisitor<T> jvmciVisitor = new FrameVisitor<T>(visitor, methods, skip);
        return (T)this.getStackIntrospection().iterateFrames(methods.anyFrameMethod, methods.anyFrameMethod, 0, jvmciVisitor);
    }

    protected abstract StackIntrospection getStackIntrospection();

    public FrameInstance getCallerFrame() {
        return (FrameInstance)this.iterateImpl(frame -> frame, 1);
    }

    @CompilerDirectives.TruffleBoundary
    public FrameInstance getCurrentFrame() {
        return (FrameInstance)this.iterateImpl(frame -> frame, 0);
    }

    public <T> T getCapability(Class<T> capability) {
        if (capability == TVMCI.class) {
            return capability.cast((Object)this.tvmci);
        }
        if (capability == LayoutFactory.class) {
            LayoutFactory layoutFactory = GraalTruffleRuntime.loadObjectLayoutFactory();
            GraalRuntimeAccessor.JDK.exportTo(layoutFactory.getClass());
            return capability.cast(layoutFactory);
        }
        if (capability == TVMCI.Test.class) {
            return capability.cast(this.getTestTvmci());
        }
        try {
            return GraalTruffleRuntime.loadServiceProvider(capability, false);
        }
        catch (ServiceConfigurationError e) {
            return null;
        }
    }

    public abstract SpeculationLog createSpeculationLog();

    public final RootCallTarget createCallTarget(RootNode rootNode) {
        CompilerAsserts.neverPartOfCompilation();
        OptimizedCallTarget newCallTarget = this.createClonedCallTarget(rootNode, null);
        TruffleSplittingStrategy.newTargetCreated(newCallTarget);
        return newCallTarget;
    }

    public final OptimizedCallTarget createClonedCallTarget(RootNode rootNode, OptimizedCallTarget source) {
        CompilerAsserts.neverPartOfCompilation();
        OptimizedCallTarget target = this.createOptimizedCallTarget(source, rootNode);
        GraalRuntimeAccessor.INSTRUMENT.onLoad(target.getRootNode());
        return target;
    }

    public final OptimizedCallTarget createOSRCallTarget(RootNode rootNode) {
        CompilerAsserts.neverPartOfCompilation();
        OptimizedCallTarget target = this.createOptimizedCallTarget(null, rootNode);
        GraalRuntimeAccessor.INSTRUMENT.onLoad(target.getRootNode());
        return target;
    }

    public abstract OptimizedCallTarget createOptimizedCallTarget(OptimizedCallTarget var1, RootNode var2);

    public void addListener(GraalTruffleRuntimeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(GraalTruffleRuntimeListener listener) {
        this.listeners.remove(listener);
    }

    private void shutdown() {
        this.getListener().onShutdown();
        TruffleCompiler tcp = this.truffleCompiler;
        if (tcp != null) {
            tcp.shutdown();
        }
    }

    protected final void doCompile(OptimizedCallTarget callTarget, TruffleCompilationTask task) {
        this.doCompile(null, callTarget, task);
    }

    protected final void doCompile(TruffleDebugContext debug, OptimizedCallTarget callTarget, TruffleCompilationTask task) {
        List<OptimizedCallTarget> oldBlockCompilations = callTarget.blockCompilations;
        if (oldBlockCompilations != null) {
            for (OptimizedCallTarget blockTarget : oldBlockCompilations) {
                if (blockTarget.isValid()) continue;
                this.listeners.onCompilationQueued(blockTarget);
                int nodeCount = blockTarget.getNonTrivialNodeCount();
                if (nodeCount > (Integer)callTarget.engine.getEngineOptions().get(PolyglotCompilerOptions.PartialBlockMaximumSize)) {
                    this.listeners.onCompilationDequeued(blockTarget, null, "Partial block is too big to be compiled.");
                    continue;
                }
                this.compileImpl(debug, blockTarget, task);
            }
        }
        this.compileImpl(debug, callTarget, task);
        if (oldBlockCompilations == null && callTarget.blockCompilations != null) {
            ((CompilationTask)task).reset();
            this.listeners.onCompilationQueued(callTarget);
            this.doCompile(callTarget, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileImpl(TruffleDebugContext initialDebug, OptimizedCallTarget callTarget, TruffleCompilationTask task) {
        boolean compilationStarted = false;
        try {
            TruffleCompiler compiler = this.getTruffleCompiler(callTarget);
            try (TruffleCompilation compilation = compiler.openCompilation(callTarget);){
                Map<String, Object> optionsMap = GraalTruffleRuntime.getOptionsForCompiler(callTarget);
                TruffleDebugContext debug = initialDebug;
                if (debug == null) {
                    debug = compiler.openDebugContext(optionsMap, compilation);
                }
                try {
                    compilationStarted = true;
                    this.listeners.onCompilationStarted(callTarget);
                    TruffleInlining inlining = new TruffleInlining();
                    try (AutoCloseable s = debug.scope("Truffle", new TruffleDebugJavaMethod(callTarget));
                         TruffleOutputGroup o = !this.isPrintGraphEnabled() ? null : TruffleOutputGroup.open(debug, callTarget, Collections.singletonMap("truffle.compilation.id", compilation));){
                        GraalTruffleRuntime.maybeDumpTruffleTree(debug, callTarget);
                        compiler.doCompile(debug, compilation, optionsMap, inlining, task, this.listeners.isEmpty() ? null : this.listeners);
                    }
                    finally {
                        if (debug != null) {
                            debug.closeDebugChannels();
                        }
                    }
                    inlining.dequeueTargets();
                }
                finally {
                    if (initialDebug == null) {
                        debug.close();
                    }
                }
            }
        }
        catch (OptimizationFailedException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.notifyCompilationFailure(callTarget, e, compilationStarted);
            throw e;
        }
        catch (Throwable e) {
            this.notifyCompilationFailure(callTarget, e, compilationStarted);
            throw new InternalError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCompilationFailure(OptimizedCallTarget callTarget, Throwable t, boolean compilationStarted) {
        try {
            if (compilationStarted) {
                this.listeners.onCompilationFailed(callTarget, t.toString(), false, false);
            } else {
                this.listeners.onCompilationDequeued(callTarget, this, String.format("Failed to create Truffle compiler due to %s.", t.getMessage()));
            }
        }
        finally {
            Supplier<String> serializedException = () -> CompilableTruffleAST.serializeException(t);
            callTarget.onCompilationFailed(serializedException, this.isSuppressedFailure(callTarget, serializedException), false, false, false);
        }
    }

    private static void maybeDumpTruffleTree(TruffleDebugContext debug, OptimizedCallTarget callTarget) throws Exception {
        try (AutoCloseable c = debug.scope("TruffleTree");){
            if (debug.isDumpEnabled()) {
                TruffleTreeDumper.dump(debug, callTarget);
            }
        }
    }

    public abstract BackgroundCompileQueue getCompileQueue();

    public CompilationTask submitForCompilation(OptimizedCallTarget optimizedCallTarget, boolean lastTierCompilation) {
        BackgroundCompileQueue.Priority priority = new BackgroundCompileQueue.Priority(optimizedCallTarget.getCallAndLoopCount(), lastTierCompilation ? BackgroundCompileQueue.Priority.Tier.LAST : BackgroundCompileQueue.Priority.Tier.FIRST);
        return this.getCompileQueue().submitCompilation(priority, optimizedCallTarget);
    }

    private static boolean assertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public void finishCompilation(OptimizedCallTarget optimizedCallTarget, CompilationTask task, boolean mayBeAsynchronous) {
        block4: {
            if (!mayBeAsynchronous) {
                try {
                    GraalTruffleRuntime.uninterruptibleWaitForCompilation(task);
                }
                catch (ExecutionException e) {
                    if (optimizedCallTarget.engine.compilationFailureAction == PolyglotCompilerOptions.ExceptionAction.Throw) {
                        throw new RuntimeException(e.getCause());
                    }
                    if (!GraalTruffleRuntime.assertionsEnabled()) break block4;
                    e.printStackTrace();
                }
            }
        }
    }

    private static void uninterruptibleWaitForCompilation(CompilationTask task) throws ExecutionException {
        boolean interrupted = false;
        try {
            while (true) {
                try {
                    task.awaitCompletion();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitForCompilation(OptimizedCallTarget optimizedCallTarget, long timeout) throws ExecutionException, TimeoutException {
        CompilationTask task = optimizedCallTarget.getCompilationTask();
        if (task != null) {
            try {
                task.awaitCompletion(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public int getCompilationQueueSize() {
        return this.getCompileQueue().getQueueSize();
    }

    public void bypassedInstalledCode(OptimizedCallTarget target) {
    }

    protected CallMethods getCallMethods() {
        return this.callMethods;
    }

    protected static EngineData getEngineData(RootNode rootNode) {
        return GraalTVMCI.getEngineData(rootNode);
    }

    private static LayoutFactory loadObjectLayoutFactory() {
        return GraalTruffleRuntime.selectObjectLayoutFactory(GraalTruffleRuntime.loadService(LayoutFactory.class));
    }

    private static <T> List<ServiceLoader<T>> loadService(Class<T> service) {
        ServiceLoader<T> graalLoader = ServiceLoader.load(service, GraalTruffleRuntime.class.getClassLoader());
        if (Java8OrEarlier) {
            return Collections.singletonList(graalLoader);
        }
        ServiceLoader<T> appLoader = ServiceLoader.load(service, service.getClassLoader());
        return Arrays.asList(graalLoader, appLoader);
    }

    private static LayoutFactory selectObjectLayoutFactory(Iterable<? extends Iterable<LayoutFactory>> availableLayoutFactories) {
        String layoutFactoryImplName = (String)Services.getSavedProperties().get("truffle.object.LayoutFactory");
        LayoutFactory bestLayoutFactory = null;
        for (Iterable<LayoutFactory> iterable : availableLayoutFactories) {
            for (LayoutFactory currentLayoutFactory : iterable) {
                if (layoutFactoryImplName != null) {
                    if (!currentLayoutFactory.getClass().getName().equals(layoutFactoryImplName)) continue;
                    return currentLayoutFactory;
                }
                if (bestLayoutFactory == null) {
                    bestLayoutFactory = currentLayoutFactory;
                    continue;
                }
                if (currentLayoutFactory.getPriority() < bestLayoutFactory.getPriority()) continue;
                assert (currentLayoutFactory.getPriority() != bestLayoutFactory.getPriority());
                bestLayoutFactory = currentLayoutFactory;
            }
        }
        return bestLayoutFactory;
    }

    protected String printStackTraceToString(Throwable e) {
        CharArrayWriter caw = new CharArrayWriter();
        e.printStackTrace(new PrintWriter(caw));
        return caw.toString();
    }

    private static int getJavaSpecificationVersion() {
        String value = (String)Services.getSavedProperties().get("java.specification.version");
        if (value.startsWith("1.")) {
            value = value.substring(2);
        }
        return Integer.parseInt(value);
    }

    @Override
    public boolean isValueType(ResolvedJavaType type) {
        return GraalTruffleRuntime.getAnnotation(CompilerDirectives.ValueType.class, type) != null;
    }

    @Override
    public JavaKind getJavaKindForFrameSlotKind(int frameSlotKindTag) {
        if (frameSlotKindTag == FrameSlotKind.Boolean.tag) {
            return JavaKind.Boolean;
        }
        if (frameSlotKindTag == FrameSlotKind.Byte.tag) {
            return JavaKind.Byte;
        }
        if (frameSlotKindTag == FrameSlotKind.Int.tag) {
            return JavaKind.Int;
        }
        if (frameSlotKindTag == FrameSlotKind.Float.tag) {
            return JavaKind.Float;
        }
        if (frameSlotKindTag == FrameSlotKind.Long.tag) {
            return JavaKind.Long;
        }
        if (frameSlotKindTag == FrameSlotKind.Double.tag) {
            return JavaKind.Double;
        }
        if (frameSlotKindTag == FrameSlotKind.Object.tag) {
            return JavaKind.Object;
        }
        if (frameSlotKindTag == FrameSlotKind.Illegal.tag) {
            return JavaKind.Illegal;
        }
        return JavaKind.Illegal;
    }

    @Override
    public int getFrameSlotKindTagForJavaKind(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return FrameSlotKind.Boolean.tag;
            }
            case Byte: {
                return FrameSlotKind.Byte.tag;
            }
            case Int: {
                return FrameSlotKind.Int.tag;
            }
            case Float: {
                return FrameSlotKind.Float.tag;
            }
            case Long: {
                return FrameSlotKind.Long.tag;
            }
            case Double: {
                return FrameSlotKind.Double.tag;
            }
            case Object: {
                return FrameSlotKind.Object.tag;
            }
            case Illegal: {
                return FrameSlotKind.Illegal.tag;
            }
        }
        return FrameSlotKind.Illegal.tag;
    }

    @Override
    public int getFrameSlotKindTagsCount() {
        return FrameSlotKind.values().length;
    }

    @Override
    public TruffleCompilerRuntime.InlineKind getInlineKind(ResolvedJavaMethod original, boolean duringPartialEvaluation) {
        CompilerDirectives.TruffleBoundary truffleBoundary = GraalTruffleRuntime.getAnnotation(CompilerDirectives.TruffleBoundary.class, original);
        if (truffleBoundary != null) {
            if (duringPartialEvaluation) {
                if (truffleBoundary.transferToInterpreterOnException()) {
                    return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_SPECULATIVE_EXCEPTION;
                }
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (!truffleBoundary.allowInlining()) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
        } else {
            if (GraalTruffleRuntime.getAnnotation(TruffleCallBoundary.class, original) != null) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
            if (JFRListener.isInstrumented(original)) {
                return TruffleCompilerRuntime.InlineKind.DO_NOT_INLINE_WITH_EXCEPTION;
            }
        }
        return TruffleCompilerRuntime.InlineKind.INLINE;
    }

    @Override
    public boolean isTruffleBoundary(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(CompilerDirectives.TruffleBoundary.class, method) != null;
    }

    @Override
    public boolean isSpecializationMethod(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(Specialization.class, method) != null;
    }

    @Override
    public boolean isBytecodeInterpreterSwitch(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(HostCompilerDirectives.BytecodeInterpreterSwitch.class, method) != null;
    }

    @Override
    public boolean isBytecodeInterpreterSwitchBoundary(ResolvedJavaMethod method) {
        return GraalTruffleRuntime.getAnnotation(HostCompilerDirectives.BytecodeInterpreterSwitchBoundary.class, method) != null;
    }

    @Override
    public void log(String loggerId, CompilableTruffleAST compilable, String message) {
        ((OptimizedCallTarget)compilable).engine.getLogger(loggerId).log(Level.INFO, message);
    }

    @Override
    public boolean isSuppressedFailure(CompilableTruffleAST compilable, Supplier<String> serializedException) {
        return this.floodControlHandler != null && this.floodControlHandler.isSuppressedFailure(compilable, serializedException);
    }

    private static BailoutException handleAnnotationFailure(NoClassDefFoundError e, String attemptedAction) {
        throw new BailoutException((Throwable)e, "Error while %s. This usually means that the unresolved type is in the signature of some other method or field in the same class. This can be resolved by modifying the relevant class path or module path such that it includes the missing type.", new Object[]{attemptedAction});
    }

    private static Annotation[] getAnnotations(ResolvedJavaField element) {
        try {
            return element.getAnnotations();
        }
        catch (NoClassDefFoundError e) {
            throw GraalTruffleRuntime.handleAnnotationFailure(e, String.format("querying %s for annotations", element.format("%H.%n:%t")));
        }
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, ResolvedJavaMethod method) {
        try {
            return (T)((Annotation)annotationClass.cast(method.getAnnotation(annotationClass)));
        }
        catch (NoClassDefFoundError e) {
            throw GraalTruffleRuntime.handleAnnotationFailure(e, String.format("querying %s for presence of a %s annotation", method.format("%H.%n(%p)"), annotationClass.getName()));
        }
    }

    private static <T extends Annotation> T getAnnotation(Class<T> annotationClass, ResolvedJavaType type) {
        try {
            return (T)((Annotation)annotationClass.cast(type.getAnnotation(annotationClass)));
        }
        catch (NoClassDefFoundError e) {
            throw GraalTruffleRuntime.handleAnnotationFailure(e, String.format("querying %s for presence of a %s annotation", type.toJavaName(), annotationClass.getName()));
        }
    }

    protected AutoCloseable openCompilerThreadScope() {
        return null;
    }

    protected long getCompilerIdleDelay(OptimizedCallTarget callTarget) {
        OptionValues options = callTarget.engine.getEngineOptions();
        if (!((Set)options.get(PolyglotCompilerOptions.MethodExpansionStatistics)).isEmpty() || !((Set)options.get(PolyglotCompilerOptions.NodeExpansionStatistics)).isEmpty() || ((Boolean)options.get(PolyglotCompilerOptions.InstrumentBranches)).booleanValue() || ((Boolean)options.get(PolyglotCompilerOptions.InstrumentBoundaries)).booleanValue()) {
            return 0L;
        }
        return callTarget.getOptionValue(PolyglotCompilerOptions.CompilerIdleDelay);
    }

    final OptionDescriptors getEngineOptionDescriptors() {
        return this.engineOptions;
    }

    public static Map<String, Object> getOptionsForCompiler(OptimizedCallTarget callTarget) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        OptionValues values = callTarget == null ? null : callTarget.getOptionValues();
        for (OptionDescriptor desc : PolyglotCompilerOptions.getDescriptors()) {
            OptionKey key = desc.getKey();
            if (!values.hasBeenSet(key)) continue;
            Object value = values.get(key);
            if (!GraalTruffleRuntime.isPrimitiveType(value)) {
                value = GraalRuntimeAccessor.ENGINE.getUnparsedOptionValue(values, key);
            }
            if (value == null) continue;
            map.put(desc.getName(), value);
        }
        return map;
    }

    private static boolean isPrimitiveType(Object value) {
        Class<?> valueClass = value.getClass();
        return valueClass == Boolean.class || valueClass == Byte.class || valueClass == Short.class || valueClass == Character.class || valueClass == Integer.class || valueClass == Long.class || valueClass == Float.class || valueClass == Double.class || valueClass == String.class;
    }

    protected static final class CallMethods {
        public final ResolvedJavaMethod callDirectMethod;
        public final ResolvedJavaMethod callInlinedMethod;
        public final ResolvedJavaMethod callIndirectMethod;
        public final ResolvedJavaMethod callTargetMethod;
        public final ResolvedJavaMethod callOSRMethod;
        public final ResolvedJavaMethod callInlinedCallMethod;
        public final ResolvedJavaMethod[] anyFrameMethod;

        private CallMethods(MetaAccessProvider metaAccess) {
            this.callDirectMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_DIRECT);
            this.callIndirectMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_INDIRECT);
            this.callInlinedMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_INLINED);
            this.callInlinedCallMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_INLINED_CALL);
            this.callTargetMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_TARGET_METHOD);
            this.callOSRMethod = metaAccess.lookupJavaMethod((Executable)GraalFrameInstance.CALL_OSR_METHOD);
            this.anyFrameMethod = new ResolvedJavaMethod[]{this.callDirectMethod, this.callIndirectMethod, this.callInlinedMethod, this.callTargetMethod, this.callOSRMethod, this.callInlinedCallMethod};
        }

        public static CallMethods lookup(MetaAccessProvider metaAccess) {
            return new CallMethods(metaAccess);
        }
    }

    private static final class FrameVisitor<T>
    implements InspectedFrameVisitor<T> {
        private final FrameInstanceVisitor<T> visitor;
        private final CallMethods methods;
        private int skipFrames;
        private InspectedFrame callNodeFrame;

        FrameVisitor(FrameInstanceVisitor<T> visitor, CallMethods methods, int skip) {
            this.visitor = visitor;
            this.methods = methods;
            this.skipFrames = skip;
        }

        public T visitFrame(InspectedFrame frame) {
            if (frame.isMethod(this.methods.callOSRMethod)) {
                ++this.skipFrames;
                return null;
            }
            if (frame.isMethod(this.methods.callTargetMethod)) {
                if (this.skipFrames == 0) {
                    try {
                        Object object = this.visitor.visitFrame((FrameInstance)new GraalFrameInstance(frame, this.callNodeFrame));
                        return (T)object;
                    }
                    finally {
                        this.callNodeFrame = null;
                    }
                }
                --this.skipFrames;
            } else if (frame.isMethod(this.methods.callDirectMethod) || frame.isMethod(this.methods.callIndirectMethod) || frame.isMethod(this.methods.callInlinedMethod) || frame.isMethod(this.methods.callInlinedCallMethod)) {
                this.callNodeFrame = frame;
            }
            return null;
        }
    }
}

