/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import sun.misc.Unsafe;

public final class FrameWithoutBoxing
implements VirtualFrame,
MaterializedFrame {
    private final FrameDescriptor descriptor;
    private final Object[] arguments;
    private Object[] locals;
    private long[] primitiveLocals;
    private byte[] tags;
    public static final byte OBJECT_TAG = 0;
    public static final byte ILLEGAL_TAG = 1;
    public static final byte LONG_TAG = 2;
    public static final byte INT_TAG = 3;
    public static final byte DOUBLE_TAG = 4;
    public static final byte FLOAT_TAG = 5;
    public static final byte BOOLEAN_TAG = 6;
    public static final byte BYTE_TAG = 7;
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final long[] EMPTY_LONG_ARRAY = new long[0];
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final Unsafe UNSAFE = FrameWithoutBoxing.initUnsafe();

    private static Unsafe initUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe", e);
            }
        }
    }

    public FrameWithoutBoxing(FrameDescriptor descriptor, Object[] arguments) {
        this.descriptor = descriptor;
        this.arguments = arguments;
        int size = descriptor.getSize();
        if (size == 0) {
            this.locals = EMPTY_OBJECT_ARRAY;
            this.primitiveLocals = EMPTY_LONG_ARRAY;
            this.tags = EMPTY_BYTE_ARRAY;
        } else {
            this.locals = new Object[size];
            Object defaultValue = descriptor.getDefaultValue();
            if (defaultValue != null) {
                Arrays.fill(this.locals, defaultValue);
            }
            this.primitiveLocals = new long[size];
            this.tags = new byte[size];
        }
    }

    public Object[] getArguments() {
        return FrameWithoutBoxing.unsafeCast(this.arguments, Object[].class, true, true, true);
    }

    public MaterializedFrame materialize() {
        ((GraalTruffleRuntime)Truffle.getRuntime()).markFrameMaterializeCalled(this.descriptor);
        return this;
    }

    public Object getObject(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)0);
        return this.getObjectUnsafe(slotIndex, slot, condition);
    }

    private Object[] getLocals() {
        return FrameWithoutBoxing.unsafeCast(this.locals, Object[].class, true, true, true);
    }

    private long[] getPrimitiveLocals() {
        return FrameWithoutBoxing.unsafeCast(this.primitiveLocals, long[].class, true, true, true);
    }

    byte[] getTags() {
        return FrameWithoutBoxing.unsafeCast(this.tags, byte[].class, true, true, true);
    }

    Object getObjectUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        return FrameWithoutBoxing.unsafeGetObject(this.getLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slotIndex * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, condition, slot);
    }

    public void setObject(FrameSlot slot, Object value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)0);
        this.setObjectUnsafe(slotIndex, slot, value);
    }

    private void setObjectUnsafe(int slotIndex, FrameSlot slot, Object value) {
        FrameWithoutBoxing.unsafePutObject(this.getLocals(), (long)Unsafe.ARRAY_OBJECT_BASE_OFFSET + (long)slotIndex * (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE, value, slot);
    }

    public byte getByte(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)7);
        return this.getByteUnsafe(slotIndex, slot, condition);
    }

    byte getByteUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return (byte)FrameWithoutBoxing.unsafeGetInt(this.getPrimitiveLocals(), offset, condition, slot);
    }

    public void setByte(FrameSlot slot, byte value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)7);
        this.setByteUnsafe(slotIndex, slot, value);
    }

    private void setByteUnsafe(int slotIndex, FrameSlot slot, byte value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutInt(this.getPrimitiveLocals(), offset, value, slot);
    }

    public boolean getBoolean(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)6);
        return this.getBooleanUnsafe(slotIndex, slot, condition);
    }

    boolean getBooleanUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetInt(this.getPrimitiveLocals(), offset, condition, slot) != 0;
    }

    public void setBoolean(FrameSlot slot, boolean value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)6);
        this.setBooleanUnsafe(slotIndex, slot, value);
    }

    private void setBooleanUnsafe(int slotIndex, FrameSlot slot, boolean value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutInt(this.getPrimitiveLocals(), offset, value ? 1 : 0, slot);
    }

    public float getFloat(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)5);
        return this.getFloatUnsafe(slotIndex, slot, condition);
    }

    float getFloatUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetFloat(this.getPrimitiveLocals(), offset, condition, slot);
    }

    public void setFloat(FrameSlot slot, float value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)5);
        this.setFloatUnsafe(slotIndex, slot, value);
    }

    private void setFloatUnsafe(int slotIndex, FrameSlot slot, float value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutFloat(this.getPrimitiveLocals(), offset, value, slot);
    }

    public long getLong(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)2);
        return this.getLongUnsafe(slotIndex, slot, condition);
    }

    long getLongUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetLong(this.getPrimitiveLocals(), offset, condition, slot);
    }

    public void setLong(FrameSlot slot, long value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)2);
        this.setLongUnsafe(slotIndex, slot, value);
    }

    private void setLongUnsafe(int slotIndex, FrameSlot slot, long value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutLong(this.getPrimitiveLocals(), offset, value, slot);
    }

    public int getInt(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)3);
        return this.getIntUnsafe(slotIndex, slot, condition);
    }

    int getIntUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetInt(this.getPrimitiveLocals(), offset, condition, slot);
    }

    public void setInt(FrameSlot slot, int value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)3);
        this.setIntUnsafe(slotIndex, slot, value);
    }

    private void setIntUnsafe(int slotIndex, FrameSlot slot, int value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutInt(this.getPrimitiveLocals(), offset, value, slot);
    }

    public double getDouble(FrameSlot slot) throws FrameSlotTypeException {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        boolean condition = this.verifyGet(slotIndex, (byte)4);
        return this.getDoubleUnsafe(slotIndex, slot, condition);
    }

    double getDoubleUnsafe(int slotIndex, FrameSlot slot, boolean condition) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        return FrameWithoutBoxing.unsafeGetDouble(this.getPrimitiveLocals(), offset, condition, slot);
    }

    public void setDouble(FrameSlot slot, double value) {
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        this.verifySet(slotIndex, (byte)4);
        this.setDoubleUnsafe(slotIndex, slot, value);
    }

    private void setDoubleUnsafe(int slotIndex, FrameSlot slot, double value) {
        long offset = FrameWithoutBoxing.getPrimitiveOffset(slotIndex);
        FrameWithoutBoxing.unsafePutDouble(this.getPrimitiveLocals(), offset, value, slot);
    }

    public FrameDescriptor getFrameDescriptor() {
        return FrameWithoutBoxing.unsafeCast(this.descriptor, FrameDescriptor.class, true, true, false);
    }

    private void verifySet(int slotIndex, byte tag) {
        this.checkSlotIndex(slotIndex);
        this.getTags()[slotIndex] = tag;
    }

    private boolean verifyGet(int slotIndex, byte tag) throws FrameSlotTypeException {
        boolean condition;
        this.checkSlotIndex(slotIndex);
        boolean bl = condition = this.getTags()[slotIndex] == tag;
        if (!condition) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new FrameSlotTypeException();
        }
        return condition;
    }

    private void checkSlotIndex(int slotIndex) {
        if (CompilerDirectives.inInterpreter() && slotIndex >= this.getTags().length && !this.resize()) {
            throw new IllegalArgumentException(String.format("The frame slot '%s' is not known by the frame descriptor.", slotIndex));
        }
    }

    private static long getPrimitiveOffset(int slotIndex) {
        return (long)Unsafe.ARRAY_LONG_BASE_OFFSET + (long)slotIndex * (long)Unsafe.ARRAY_LONG_INDEX_SCALE;
    }

    public Object getValue(FrameSlot slot) {
        byte tag;
        boolean condition;
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        if (CompilerDirectives.inInterpreter() && slotIndex >= this.getTags().length) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.resize();
        }
        boolean bl = condition = (tag = this.getTags()[slotIndex]) == 6;
        if (condition) {
            return this.getBooleanUnsafe(slotIndex, slot, condition);
        }
        boolean bl2 = condition = tag == 7;
        if (condition) {
            return this.getByteUnsafe(slotIndex, slot, condition);
        }
        boolean bl3 = condition = tag == 3;
        if (condition) {
            return this.getIntUnsafe(slotIndex, slot, condition);
        }
        boolean bl4 = condition = tag == 4;
        if (condition) {
            return this.getDoubleUnsafe(slotIndex, slot, condition);
        }
        boolean bl5 = condition = tag == 2;
        if (condition) {
            return this.getLongUnsafe(slotIndex, slot, condition);
        }
        boolean bl6 = condition = tag == 5;
        if (condition) {
            return Float.valueOf(this.getFloatUnsafe(slotIndex, slot, condition));
        }
        boolean bl7 = condition = tag == 0;
        assert (condition);
        return this.getObjectUnsafe(slotIndex, slot, condition);
    }

    private boolean resize() {
        int oldSize = this.tags.length;
        int newSize = this.descriptor.getSize();
        if (newSize > oldSize) {
            this.locals = Arrays.copyOf(this.locals, newSize);
            Arrays.fill(this.locals, oldSize, newSize, this.descriptor.getDefaultValue());
            this.primitiveLocals = Arrays.copyOf(this.primitiveLocals, newSize);
            this.tags = Arrays.copyOf(this.tags, newSize);
            return true;
        }
        return false;
    }

    byte getTag(FrameSlot slot) {
        byte[] cachedTags;
        int slotIndex = FrameWithoutBoxing.getFrameSlotIndex(slot);
        if (slotIndex < (cachedTags = this.getTags()).length) {
            return cachedTags[slotIndex];
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.resize();
        return this.getTags()[slotIndex];
    }

    public boolean isObject(FrameSlot slot) {
        return this.getTag(slot) == 0;
    }

    public boolean isByte(FrameSlot slot) {
        return this.getTag(slot) == 7;
    }

    public boolean isBoolean(FrameSlot slot) {
        return this.getTag(slot) == 6;
    }

    public boolean isInt(FrameSlot slot) {
        return this.getTag(slot) == 3;
    }

    public boolean isLong(FrameSlot slot) {
        return this.getTag(slot) == 2;
    }

    public boolean isFloat(FrameSlot slot) {
        return this.getTag(slot) == 5;
    }

    public boolean isDouble(FrameSlot slot) {
        return this.getTag(slot) == 4;
    }

    private static <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return (T)value;
    }

    private static int unsafeGetInt(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getInt(receiver, offset);
    }

    private static long unsafeGetLong(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getLong(receiver, offset);
    }

    private static float unsafeGetFloat(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getFloat(receiver, offset);
    }

    private static double unsafeGetDouble(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getDouble(receiver, offset);
    }

    private static Object unsafeGetObject(Object receiver, long offset, boolean condition, Object locationIdentity) {
        return UNSAFE.getObject(receiver, offset);
    }

    private static void unsafePutInt(Object receiver, long offset, int value, Object locationIdentity) {
        UNSAFE.putInt(receiver, offset, value);
    }

    private static void unsafePutLong(Object receiver, long offset, long value, Object locationIdentity) {
        UNSAFE.putLong(receiver, offset, value);
    }

    private static void unsafePutFloat(Object receiver, long offset, float value, Object locationIdentity) {
        UNSAFE.putFloat(receiver, offset, value);
    }

    private static void unsafePutDouble(Object receiver, long offset, double value, Object locationIdentity) {
        UNSAFE.putDouble(receiver, offset, value);
    }

    private static void unsafePutObject(Object receiver, long offset, Object value, Object locationIdentity) {
        UNSAFE.putObject(receiver, offset, value);
    }

    private static int getFrameSlotIndex(FrameSlot slot) {
        return slot.getIndex();
    }

    static {
        assert (0 == FrameSlotKind.Object.tag);
        assert (1 == FrameSlotKind.Illegal.tag);
        assert (2 == FrameSlotKind.Long.tag);
        assert (3 == FrameSlotKind.Int.tag);
        assert (4 == FrameSlotKind.Double.tag);
        assert (5 == FrameSlotKind.Float.tag);
        assert (6 == FrameSlotKind.Boolean.tag);
        assert (7 == FrameSlotKind.Byte.tag);
    }
}

