/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.logging.Level;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.GraalRuntimeAccessor;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;
import org.graalvm.compiler.truffle.runtime.TruffleSplittingStrategy;
import org.graalvm.compiler.truffle.runtime.debug.StatisticsListener;
import org.graalvm.options.OptionValues;

public final class EngineData {
    private static final AtomicLong engineCounter = new AtomicLong();
    int splitLimit;
    int splitCount;
    public final long id;
    private Function<String, TruffleLogger> loggerFactory;
    @CompilerDirectives.CompilationFinal
    OptionValues engineOptions;
    final TruffleSplittingStrategy.SplitStatisticsData splittingStatistics;
    @CompilerDirectives.CompilationFinal
    public StatisticsListener statisticsListener;
    @CompilerDirectives.CompilationFinal
    public boolean splitting;
    @CompilerDirectives.CompilationFinal
    public boolean splittingAllowForcedSplits;
    @CompilerDirectives.CompilationFinal
    public boolean splittingDumpDecisions;
    @CompilerDirectives.CompilationFinal
    public boolean splittingTraceEvents;
    @CompilerDirectives.CompilationFinal
    public boolean traceSplittingSummary;
    @CompilerDirectives.CompilationFinal
    public boolean traceSplits;
    @CompilerDirectives.CompilationFinal
    public int splittingMaxCalleeSize;
    @CompilerDirectives.CompilationFinal
    public int splittingMaxPropagationDepth;
    @CompilerDirectives.CompilationFinal
    public double splittingGrowthLimit;
    @CompilerDirectives.CompilationFinal
    public boolean inlining;
    @CompilerDirectives.CompilationFinal
    public boolean compilation;
    @CompilerDirectives.CompilationFinal
    public boolean compileImmediately;
    @CompilerDirectives.CompilationFinal
    public boolean multiTier;
    @CompilerDirectives.CompilationFinal
    public boolean returnTypeSpeculation;
    @CompilerDirectives.CompilationFinal
    public boolean argumentTypeSpeculation;
    @CompilerDirectives.CompilationFinal
    public boolean traceCompilation;
    @CompilerDirectives.CompilationFinal
    public boolean traceCompilationDetails;
    @CompilerDirectives.CompilationFinal
    public boolean backgroundCompilation;
    @CompilerDirectives.CompilationFinal
    public PolyglotCompilerOptions.ExceptionAction compilationFailureAction;
    @CompilerDirectives.CompilationFinal
    public String compileOnly;
    @CompilerDirectives.CompilationFinal
    public boolean callTargetStatistics;
    @CompilerDirectives.CompilationFinal
    public boolean callTargetStatisticDetails;
    @CompilerDirectives.CompilationFinal
    public boolean profilingEnabled;
    @CompilerDirectives.CompilationFinal
    public boolean traceTransferToInterpreter;
    @CompilerDirectives.CompilationFinal
    public int callThresholdInInterpreter;
    @CompilerDirectives.CompilationFinal
    public int callAndLoopThresholdInInterpreter;
    @CompilerDirectives.CompilationFinal
    public int callThresholdInFirstTier;
    @CompilerDirectives.CompilationFinal
    public int callAndLoopThresholdInFirstTier;
    private volatile Pair<List<String>, List<String>> parsedCompileOnly;
    private Object polyglotEngine;
    private volatile Map<Class<?>, Object> engineLocals;

    EngineData(OptionValues options, Function<String, TruffleLogger> loggerFactory) {
        Objects.requireNonNull(options);
        this.id = engineCounter.incrementAndGet();
        this.loggerFactory = loggerFactory;
        this.loadOptions(options);
        this.splittingStatistics = new TruffleSplittingStrategy.SplitStatisticsData();
    }

    public void preinitializeContext() {
        GraalRuntimeAccessor.ENGINE.preinitializeContext(this.polyglotEngine);
    }

    public void finalizeStore() {
        GraalRuntimeAccessor.ENGINE.finalizeStore(this.polyglotEngine);
    }

    public Object getEngineLock() {
        return GraalRuntimeAccessor.ENGINE.getEngineLock(this.polyglotEngine);
    }

    public <T> T getEngineLocal(Class<T> symbol) {
        Map<Class<?>, Object> data = this.engineLocals;
        if (data == null) {
            return null;
        }
        return (T)data.get(symbol);
    }

    public void clearEngineLocal(Class<?> symbol) {
        Map<Class<?>, Object> data = this.engineLocals;
        if (data == null) {
            return;
        }
        data.remove(symbol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putEngineLocal(Class<T> symbol, T value) {
        Object prev;
        Map<Class<?>, Object> data = this.engineLocals;
        if (data == null) {
            EngineData engineData = this;
            synchronized (engineData) {
                data = this.engineLocals;
                if (data == null) {
                    data = new ConcurrentHashMap();
                    this.engineLocals = data;
                }
            }
        }
        if ((prev = data.putIfAbsent(symbol, symbol.cast(value))) != null) {
            throw new IllegalArgumentException("Cannot set engine local. Key " + symbol + " is already defined.");
        }
    }

    void onEngineCreated(Object engine) {
        assert (this.polyglotEngine == null);
        this.polyglotEngine = engine;
        GraalTruffleRuntime.getRuntime().getEngineCacheSupport().onEngineCreated(this);
    }

    void onEnginePatch(OptionValues newOptions, Function<String, TruffleLogger> newLoggerFactory) {
        this.loggerFactory = newLoggerFactory;
        this.loadOptions(newOptions);
        GraalTruffleRuntime.getRuntime().getEngineCacheSupport().onEnginePatch(this);
    }

    public Object getPolyglotEngine() {
        return this.polyglotEngine;
    }

    boolean onEngineClosing() {
        return GraalTruffleRuntime.getRuntime().getEngineCacheSupport().onEngineClosing(this);
    }

    void onEngineClosed() {
        GraalTruffleRuntime.getRuntime().getListener().onEngineClosed(this);
        GraalTruffleRuntime.getRuntime().getEngineCacheSupport().onEngineClosed(this);
        this.polyglotEngine = null;
    }

    private void loadOptions(OptionValues options) {
        this.engineOptions = options;
        this.splitting = (Boolean)options.get(PolyglotCompilerOptions.Splitting) != false && options.get(PolyglotCompilerOptions.Mode) != PolyglotCompilerOptions.EngineModeEnum.LATENCY;
        this.splittingAllowForcedSplits = (Boolean)options.get(PolyglotCompilerOptions.SplittingAllowForcedSplits);
        this.splittingDumpDecisions = (Boolean)options.get(PolyglotCompilerOptions.SplittingDumpDecisions);
        this.splittingMaxCalleeSize = (Integer)options.get(PolyglotCompilerOptions.SplittingMaxCalleeSize);
        this.splittingMaxPropagationDepth = (Integer)options.get(PolyglotCompilerOptions.SplittingMaxPropagationDepth);
        this.splittingTraceEvents = (Boolean)options.get(PolyglotCompilerOptions.SplittingTraceEvents);
        this.traceSplittingSummary = (Boolean)options.get(PolyglotCompilerOptions.TraceSplittingSummary);
        this.traceSplits = (Boolean)options.get(PolyglotCompilerOptions.TraceSplitting);
        this.splittingGrowthLimit = (Double)options.get(PolyglotCompilerOptions.SplittingGrowthLimit);
        this.inlining = (Boolean)options.get(PolyglotCompilerOptions.Inlining) != false && options.get(PolyglotCompilerOptions.Mode) != PolyglotCompilerOptions.EngineModeEnum.LATENCY;
        this.compilation = (Boolean)options.get(PolyglotCompilerOptions.Compilation);
        this.compileOnly = (String)options.get(PolyglotCompilerOptions.CompileOnly);
        this.compileImmediately = (Boolean)options.get(PolyglotCompilerOptions.CompileImmediately);
        this.multiTier = !this.compileImmediately && (Boolean)options.get(PolyglotCompilerOptions.MultiTier) != false;
        this.returnTypeSpeculation = (Boolean)options.get(PolyglotCompilerOptions.ReturnTypeSpeculation);
        this.argumentTypeSpeculation = (Boolean)options.get(PolyglotCompilerOptions.ArgumentTypeSpeculation);
        this.traceCompilation = (Boolean)options.get(PolyglotCompilerOptions.TraceCompilation);
        this.traceCompilationDetails = (Boolean)options.get(PolyglotCompilerOptions.TraceCompilationDetails);
        this.backgroundCompilation = (Boolean)options.get(PolyglotCompilerOptions.BackgroundCompilation);
        this.callThresholdInInterpreter = this.computeCallThresholdInInterpreter(options);
        this.callAndLoopThresholdInInterpreter = this.computeCallAndLoopThresholdInInterpreter(options);
        this.callThresholdInFirstTier = this.computeCallThresholdInFirstTier(options);
        this.callAndLoopThresholdInFirstTier = this.computeCallAndLoopThresholdInFirstTier(options);
        this.callTargetStatisticDetails = (Boolean)options.get(PolyglotCompilerOptions.CompilationStatisticDetails);
        this.callTargetStatistics = (Boolean)options.get(PolyglotCompilerOptions.CompilationStatistics) != false || this.callTargetStatisticDetails;
        this.statisticsListener = this.callTargetStatistics ? StatisticsListener.createEngineListener(GraalTruffleRuntime.getRuntime()) : null;
        this.profilingEnabled = (Boolean)options.get(PolyglotCompilerOptions.Profiling);
        this.traceTransferToInterpreter = (Boolean)options.get(PolyglotCompilerOptions.TraceTransferToInterpreter);
        this.compilationFailureAction = EngineData.computeCompilationFailureAction(options);
        this.validateOptions();
        this.parsedCompileOnly = null;
    }

    boolean acceptForCompilation(RootNode rootNode) {
        if (!this.compilation) {
            return false;
        }
        Pair<List<String>, List<String>> value = this.getCompileOnly();
        if (value != null) {
            String name = rootNode.getName();
            List includes = (List)value.getLeft();
            boolean included = includes.isEmpty();
            if (name != null) {
                for (int i = 0; !included && i < includes.size(); ++i) {
                    if (!name.contains((CharSequence)includes.get(i))) continue;
                    included = true;
                }
            }
            if (!included) {
                return false;
            }
            if (name != null) {
                for (String exclude : (List)value.getRight()) {
                    if (!name.contains(exclude)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private Pair<List<String>, List<String>> getCompileOnly() {
        if (this.compileOnly == null) {
            return null;
        }
        Pair result = this.parsedCompileOnly;
        if (result == null) {
            String[] items;
            ArrayList<String> includesList = new ArrayList<String>();
            ArrayList<String> excludesList = new ArrayList<String>();
            for (String item : items = this.compileOnly.split(",")) {
                if (item.startsWith("~")) {
                    excludesList.add(item.substring(1));
                    continue;
                }
                includesList.add(item);
            }
            this.parsedCompileOnly = result = Pair.create(includesList, excludesList);
        }
        return result;
    }

    public OptionValues getEngineOptions() {
        return this.engineOptions;
    }

    public Collection<OptimizedCallTarget> getCallTargets() {
        if (this.polyglotEngine == null) {
            throw new IllegalStateException("No polyglot engine initialized.");
        }
        return GraalRuntimeAccessor.ENGINE.findCallTargets(this.polyglotEngine);
    }

    private static PolyglotCompilerOptions.ExceptionAction computeCompilationFailureAction(OptionValues options) {
        PolyglotCompilerOptions.ExceptionAction action = (PolyglotCompilerOptions.ExceptionAction)((Object)options.get(PolyglotCompilerOptions.CompilationFailureAction));
        if (action.ordinal() < PolyglotCompilerOptions.ExceptionAction.Print.ordinal() && ((Boolean)options.get(PolyglotCompilerOptions.CompilationExceptionsArePrinted)).booleanValue()) {
            action = PolyglotCompilerOptions.ExceptionAction.Print;
        }
        if (action.ordinal() < PolyglotCompilerOptions.ExceptionAction.Throw.ordinal() && ((Boolean)options.get(PolyglotCompilerOptions.CompilationExceptionsAreThrown)).booleanValue()) {
            action = PolyglotCompilerOptions.ExceptionAction.Throw;
        }
        if (action.ordinal() < PolyglotCompilerOptions.ExceptionAction.ExitVM.ordinal() && ((Boolean)options.get(PolyglotCompilerOptions.CompilationExceptionsAreFatal)).booleanValue()) {
            action = PolyglotCompilerOptions.ExceptionAction.ExitVM;
        }
        if (action.ordinal() < PolyglotCompilerOptions.ExceptionAction.ExitVM.ordinal() && !((Set)options.get(PolyglotCompilerOptions.PerformanceWarningsAreFatal)).isEmpty()) {
            action = PolyglotCompilerOptions.ExceptionAction.ExitVM;
        }
        return action;
    }

    private void validateOptions() {
        if (this.compilationFailureAction == PolyglotCompilerOptions.ExceptionAction.Throw && this.backgroundCompilation) {
            this.getEngineLogger().log(Level.WARNING, "The 'Throw' value of the 'engine.CompilationFailureAction' option requires the 'engine.BackgroundCompilation' option to be set to 'false'.");
        }
    }

    private int computeCallThresholdInInterpreter(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        if (this.multiTier) {
            return Math.min((Integer)options.get(PolyglotCompilerOptions.FirstTierMinInvokeThreshold), (Integer)options.get(PolyglotCompilerOptions.FirstTierCompilationThreshold));
        }
        return Math.min((Integer)options.get(PolyglotCompilerOptions.MinInvokeThreshold), (Integer)options.get(PolyglotCompilerOptions.CompilationThreshold));
    }

    private int computeCallAndLoopThresholdInInterpreter(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        if (this.multiTier) {
            return (Integer)options.get(PolyglotCompilerOptions.FirstTierCompilationThreshold);
        }
        return (Integer)options.get(PolyglotCompilerOptions.CompilationThreshold);
    }

    private int computeCallThresholdInFirstTier(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        return Math.min((Integer)options.get(PolyglotCompilerOptions.MinInvokeThreshold), (Integer)options.get(PolyglotCompilerOptions.CompilationThreshold));
    }

    private int computeCallAndLoopThresholdInFirstTier(OptionValues options) {
        if (this.compileImmediately) {
            return 0;
        }
        return (Integer)options.get(PolyglotCompilerOptions.CompilationThreshold);
    }

    public TruffleLogger getEngineLogger() {
        return this.getLogger("engine");
    }

    public TruffleLogger getLogger(String loggerId) {
        return this.loggerFactory.apply(loggerId);
    }

    public void mergeLoadedSources(Source[] sources) {
        GraalRuntimeAccessor.SOURCE.mergeLoadedSources(sources);
    }
}

