/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime;

import com.oracle.truffle.api.Truffle;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.graalvm.compiler.truffle.common.TruffleCompilationTask;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.compiler.truffle.runtime.BackgroundCompileQueue;
import org.graalvm.compiler.truffle.runtime.GraalTruffleRuntime;
import org.graalvm.compiler.truffle.runtime.OptimizedCallTarget;

public final class CompilationTask
implements TruffleCompilationTask,
Callable<Void>,
Comparable<CompilationTask> {
    final WeakReference<OptimizedCallTarget> targetRef;
    private final BackgroundCompileQueue.Priority priority;
    private final boolean multiTier;
    private final boolean priorityQueue;
    private final long id;
    private final Consumer<CompilationTask> action;
    private volatile Future<?> future;
    private volatile boolean cancelled;
    private volatile boolean started;
    private static final Consumer<CompilationTask> compilationAction = new Consumer<CompilationTask>(){

        @Override
        public void accept(CompilationTask task) {
            OptimizedCallTarget callTarget = (OptimizedCallTarget)task.targetRef.get();
            if (callTarget != null && task.start()) {
                try {
                    ((GraalTruffleRuntime)Truffle.getRuntime()).doCompile(callTarget, task);
                }
                finally {
                    task.finished();
                }
            }
        }
    };

    static CompilationTask createInitializationTask(WeakReference<OptimizedCallTarget> targetRef, Consumer<CompilationTask> action) {
        return new CompilationTask(BackgroundCompileQueue.Priority.INITIALIZATION, targetRef, action, 0L);
    }

    static CompilationTask createCompilationTask(BackgroundCompileQueue.Priority priority, WeakReference<OptimizedCallTarget> targetRef, long id) {
        return new CompilationTask(priority, targetRef, compilationAction, id);
    }

    private CompilationTask(BackgroundCompileQueue.Priority priority, WeakReference<OptimizedCallTarget> targetRef, Consumer<CompilationTask> action, long id) {
        this.priority = priority;
        this.targetRef = targetRef;
        this.action = action;
        this.id = id;
        OptimizedCallTarget target = (OptimizedCallTarget)targetRef.get();
        this.priorityQueue = target != null && target.getOptionValue(PolyglotCompilerOptions.PriorityQueue) != false;
        this.multiTier = target != null && target.getOptionValue(PolyglotCompilerOptions.MultiTier) != false;
    }

    public void awaitCompletion(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.future.get(timeout, unit);
    }

    public void awaitCompletion() throws ExecutionException, InterruptedException {
        this.future.get();
    }

    public synchronized boolean cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            if (!this.started) {
                this.finished();
            }
            return true;
        }
        return false;
    }

    void reset() {
        this.cancelled = false;
    }

    public void finished() {
        OptimizedCallTarget target = (OptimizedCallTarget)this.targetRef.get();
        if (target != null) {
            target.resetCompilationTask();
        }
    }

    public synchronized boolean start() {
        assert (!this.started) : "Should not start a stared task";
        if (this.cancelled) {
            return false;
        }
        this.started = true;
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isLastTier() {
        return this.priority.tier == BackgroundCompileQueue.Priority.Tier.LAST;
    }

    public Future<?> getFuture() {
        return this.future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFuture(Future<?> future) {
        CompilationTask compilationTask = this;
        synchronized (compilationTask) {
            if (this.future != null) {
                throw new IllegalStateException("The future should not be re-set.");
            }
            this.future = future;
        }
    }

    public String toString() {
        return "CompilationTask[" + this.future + "]";
    }

    private boolean priorityQueueEnabled() {
        return this.priorityQueue && (this.multiTier && this.priority.tier == BackgroundCompileQueue.Priority.Tier.FIRST || !this.multiTier && this.priority.tier == BackgroundCompileQueue.Priority.Tier.LAST);
    }

    @Override
    public int compareTo(CompilationTask that) {
        int valueCompare;
        int tierCompare = this.priority.tier.compareTo(that.priority.tier);
        if (tierCompare != 0) {
            return tierCompare;
        }
        if (this.priorityQueueEnabled() && (valueCompare = -1 * Long.compare(this.priority.value, that.priority.value)) != 0) {
            return valueCompare;
        }
        return Long.compare(this.id, that.id);
    }

    @Override
    public Void call() throws Exception {
        this.action.accept(this);
        return null;
    }

    static class ExecutorServiceWrapper
    extends FutureTask<Void>
    implements Comparable<ExecutorServiceWrapper> {
        final CompilationTask compileTask;

        ExecutorServiceWrapper(CompilationTask compileTask) {
            super(compileTask);
            this.compileTask = compileTask;
        }

        @Override
        public int compareTo(ExecutorServiceWrapper that) {
            return this.compileTask.compareTo(that.compileTask);
        }

        @Override
        public String toString() {
            return "ExecutorServiceWrapper(" + this.compileTask + ")";
        }
    }
}

