/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases.inlining;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeSuccessorList;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleCallNode;
import org.graalvm.compiler.truffle.common.TruffleMetaAccessProvider;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.PerformanceInformationHandler;
import org.graalvm.compiler.truffle.compiler.phases.inlining.CallTree;
import org.graalvm.compiler.truffle.compiler.phases.inlining.GraphManager;
import org.graalvm.compiler.truffle.compiler.phases.inlining.InliningPolicy;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;

@NodeInfo(nameTemplate="{p#truffleAST}", cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class CallNode
extends Node
implements Comparable<CallNode> {
    private static final NodeClass<CallNode> TYPE = NodeClass.create(CallNode.class);
    private final TruffleCallNode truffleCaller;
    private final CompilableTruffleAST truffleAST;
    private final TruffleCallNode[] truffleCallees;
    private final double rootRelativeFrequency;
    private final int depth;
    private final int id;
    private boolean trivial;
    @Node.Successor
    private NodeSuccessorList<CallNode> children;
    private State state = State.Cutoff;
    private Object policyData;
    private int recursionDepth = -1;
    private StructuredGraph ir;
    private Invoke invoke;

    protected CallNode(TruffleCallNode truffleCaller, CompilableTruffleAST truffleAST, double rootRelativeFrequency, int depth, int id) {
        super(TYPE);
        this.rootRelativeFrequency = rootRelativeFrequency;
        this.truffleCaller = truffleCaller;
        this.truffleAST = truffleAST;
        this.truffleCallees = truffleAST == null ? new TruffleCallNode[]{} : truffleAST.getCallNodes();
        this.trivial = truffleAST != null && truffleAST.isTrivial();
        this.children = new NodeSuccessorList((Node)this, 0);
        this.depth = depth;
        this.id = id;
    }

    static CallNode makeRoot(CallTree callTree, PartialEvaluator.Request request) {
        Objects.requireNonNull(callTree);
        Objects.requireNonNull(request);
        CallNode root = new CallNode(null, request.compilable, 1.0, 0, callTree.nextId());
        callTree.add(root);
        root.ir = request.graph;
        root.policyData = callTree.getPolicy().newCallNodeData(root);
        GraphManager.Entry entry = callTree.getGraphManager().peRoot();
        EconomicMap<Invoke, TruffleCallNode> invokeToTruffleCallNode = entry.invokeToTruffleCallNode;
        root.verifyTrivial(entry);
        CallNode.addChildren(root, invokeToTruffleCallNode);
        root.state = State.Inlined;
        callTree.getPolicy().afterExpand(root);
        callTree.frontierSize = root.children.size();
        return root;
    }

    private static void addChildren(CallNode node, EconomicMap<Invoke, TruffleCallNode> invokeToTruffleCallNode) {
        for (Invoke invoke : invokeToTruffleCallNode.getKeys()) {
            if (!invoke.isAlive()) continue;
            TruffleCallNode childCallNode = (TruffleCallNode)invokeToTruffleCallNode.get((Object)invoke);
            double relativeFrequency = CallNode.calculateFrequency(node.truffleAST, childCallNode);
            double childFrequency = relativeFrequency * node.rootRelativeFrequency;
            CallNode callNode = new CallNode(childCallNode, childCallNode.getCurrentCallTarget(), childFrequency, node.depth + 1, node.getCallTree().nextId());
            node.getCallTree().add(callNode);
            node.children.add((Object)callNode);
            callNode.policyData = node.getPolicy().newCallNodeData(callNode);
            callNode.setInvokeOrRemove(invoke);
        }
        node.getPolicy().afterAddChildren(node);
    }

    private static double calculateFrequency(CompilableTruffleAST target, TruffleCallNode callNode) {
        return (double)Math.max(1, callNode.getCallCount()) / (double)Math.max(1, target.getCallCount());
    }

    public CompilableTruffleAST getTruffleAST() {
        return this.truffleAST;
    }

    private void putProperties(Map<Object, Object> properties) {
        if (this.state == State.Indirect) {
            return;
        }
        properties.put("Frequency", this.rootRelativeFrequency);
        properties.put("Recursion Depth", this.getRecursionDepth());
        properties.put("IR Nodes", this.ir == null ? 0 : this.ir.getNodeCount());
        properties.put("Truffle Callees", this.truffleCallees.length);
        properties.put("Explore/inline ratio", this.exploreInlineRatio());
        properties.put("Depth", this.depth);
        properties.put("Forced", this.isRoot() ? false : this.isForced());
        this.getPolicy().putProperties(this, properties);
    }

    private double exploreInlineRatio() {
        CallTree callTree = this.getCallTree();
        return this.isRoot() ? (double)callTree.expanded / (double)callTree.inlined : Double.NaN;
    }

    public int getRecursionDepth() {
        if (this.recursionDepth == -1) {
            this.recursionDepth = this.computeRecursionDepth();
        }
        return this.recursionDepth;
    }

    private int computeRecursionDepth() {
        return this.computeRecursionDepth(this.getParent(), this.truffleAST);
    }

    private int computeRecursionDepth(CallNode node, CompilableTruffleAST target) {
        if (node == null) {
            return 0;
        }
        int parentDepth = this.computeRecursionDepth(node.getParent(), target);
        if (node.truffleAST.isSameOrSplit(target)) {
            return parentDepth + 1;
        }
        return parentDepth;
    }

    public int getDepth() {
        return this.depth;
    }

    public InliningPolicy getPolicy() {
        return this.getCallTree().getPolicy();
    }

    private void setInvokeOrRemove(Invoke newInvoke) {
        if (newInvoke == null || !newInvoke.isAlive()) {
            this.remove();
        } else {
            this.invoke = newInvoke;
        }
    }

    public void remove() {
        this.state = State.Removed;
        this.getPolicy().removedNode(this);
    }

    private void addIndirectChildren(GraphManager.Entry entry) {
        for (Invoke indirectInvoke : entry.indirectInvokes) {
            if (indirectInvoke == null || !indirectInvoke.isAlive()) continue;
            CallNode child = new CallNode(null, null, 0.0, this.depth + 1, this.getCallTree().nextId());
            child.state = State.Indirect;
            child.invoke = indirectInvoke;
            this.getCallTree().add(child);
            this.children.add((Object)child);
        }
    }

    public void expand() {
        GraphManager.Entry entry;
        assert (this.state == State.Cutoff) : "Cannot expand a non-cutoff node. Node is " + (Object)((Object)this.state);
        assert (this.getParent() != null);
        this.state = State.Expanded;
        ++this.getCallTree().expanded;
        assert (this.state == State.Expanded);
        assert (this.ir == null);
        try {
            entry = this.getCallTree().getGraphManager().pe(this.truffleAST);
        }
        catch (PermanentBailoutException e) {
            this.state = State.BailedOut;
            return;
        }
        this.verifyTrivial(entry);
        this.ir = this.copyGraphAndAddChildren(entry);
        this.addIndirectChildren(entry);
        this.getPolicy().afterExpand(this);
    }

    private void verifyTrivial(GraphManager.Entry entry) {
        if (this.trivial && !entry.trivial) {
            this.trivial = false;
            PerformanceInformationHandler.logPerformanceWarning(PolyglotCompilerOptions.PerformanceWarningKind.TRIVIAL_FAIL, this.truffleAST, Collections.emptyList(), "Root node of target marked trivial but not trivial after PE", Collections.emptyMap());
        }
    }

    private StructuredGraph copyGraphAndAddChildren(final GraphManager.Entry entry) {
        StructuredGraph graph = entry.graph;
        return (StructuredGraph)graph.copy(new Consumer<UnmodifiableEconomicMap<Node, Node>>(){

            @Override
            public void accept(UnmodifiableEconomicMap<Node, Node> duplicates) {
                EconomicMap replacements = EconomicMap.create();
                for (Invoke original : entry.invokeToTruffleCallNode.getKeys()) {
                    TruffleCallNode truffleCallNode = (TruffleCallNode)entry.invokeToTruffleCallNode.get((Object)original);
                    Invoke replacement = (Invoke)duplicates.get((Object)((Node)((Object)original)));
                    replacements.put((Object)replacement, (Object)truffleCallNode);
                }
                CallNode.addChildren(CallNode.this, (EconomicMap<Invoke, TruffleCallNode>)replacements);
            }
        }, graph.getDebug());
    }

    public void inline() {
        assert (this.state == State.Expanded) : "Cannot inline node that is not expanded: " + (Object)((Object)this.state);
        assert (this.ir != null && this.getParent() != null);
        if (!this.invoke.isAlive()) {
            this.remove();
            return;
        }
        UnmodifiableEconomicMap<Node, Node> replacements = this.getCallTree().getGraphManager().doInline(this.invoke, this.ir, this.truffleAST);
        this.updateChildInvokes(replacements);
        this.state = State.Inlined;
        ++this.getCallTree().inlined;
        this.getCallTree().frontierSize += this.children.size() - 1;
    }

    private void updateChildInvokes(UnmodifiableEconomicMap<Node, Node> replacements) {
        for (CallNode child : this.children) {
            if (child.state == State.Removed) continue;
            Node childInvoke = (Node)((Object)child.invoke);
            if (childInvoke == null || !childInvoke.isAlive() || !replacements.containsKey((Object)childInvoke)) {
                child.remove();
                continue;
            }
            Invoke replacementInvoke = (Invoke)replacements.get((Object)childInvoke);
            child.setInvokeOrRemove(replacementInvoke);
        }
    }

    public boolean isForced() {
        return this.truffleCaller.isInliningForced();
    }

    public CallNode getParent() {
        return (CallNode)this.predecessor();
    }

    public Invoke getInvoke() {
        return this.invoke;
    }

    public State getState() {
        return this.state;
    }

    public boolean isRoot() {
        return this.truffleCaller == null && this.state == State.Inlined;
    }

    public String getName() {
        if (this.state == State.Indirect) {
            return "<indirect>";
        }
        return this.truffleAST.toString();
    }

    public List<CallNode> getChildren() {
        return this.children;
    }

    public StructuredGraph getIR() {
        return this.ir;
    }

    public CallTree getCallTree() {
        return (CallTree)this.graph();
    }

    @Override
    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        Map<Object, Object> debugProperties = super.getDebugProperties(map);
        this.putProperties(debugProperties);
        if (this.ir != null) {
            debugProperties.put("ir node count", this.ir.getNodeCount());
        }
        return debugProperties;
    }

    HashMap<String, Object> getStringProperties() {
        HashMap<Object, Object> properties = new HashMap<Object, Object>();
        this.putProperties(properties);
        HashMap<String, Object> stringProperties = new HashMap<String, Object>();
        for (Object key : properties.keySet()) {
            stringProperties.put(key.toString(), properties.get(key));
        }
        return stringProperties;
    }

    public double getRootRelativeFrequency() {
        return this.rootRelativeFrequency;
    }

    public boolean isTrivial() {
        return this.trivial;
    }

    public Object getPolicyData() {
        return this.policyData;
    }

    public TruffleCallNode[] getTruffleCallees() {
        return this.truffleCallees;
    }

    @Override
    public String toString(Verbosity v) {
        return "CallNode{state=" + (Object)((Object)this.state) + ", children=" + this.children + ", truffleCallNode=" + this.truffleCaller + ", truffleAST=" + this.truffleAST + '}';
    }

    @Override
    public int compareTo(CallNode o) {
        return Integer.compare(this.id, o.id);
    }

    public void finalizeGraph() {
        if (this.state == State.Inlined) {
            for (CallNode child : this.children) {
                child.finalizeGraph();
            }
        }
        if (this.state == State.Cutoff || this.state == State.Expanded || this.state == State.BailedOut) {
            if (this.invoke.isAlive()) {
                this.getCallTree().getGraphManager().finalizeGraph(this.invoke, this.truffleAST);
            } else {
                this.state = State.Removed;
            }
        }
    }

    void collectTargetsToDequeue(TruffleMetaAccessProvider provider) {
        if (this.state == State.Inlined) {
            if (this.truffleAST != this.getCallTree().getRoot().truffleAST && this.truffleAST.getKnownCallSiteCount() == 1) {
                provider.addTargetToDequeue(this.truffleAST);
            }
            for (CallNode child : this.children) {
                child.collectTargetsToDequeue(provider);
            }
        }
    }

    public void collectInlinedTargets(TruffleMetaAccessProvider inliningPlan) {
        if (this.state == State.Inlined) {
            inliningPlan.addInlinedTarget(this.truffleAST);
            for (CallNode child : this.children) {
                child.collectInlinedTargets(inliningPlan);
            }
        }
    }

    public static enum State {
        Cutoff,
        Expanded,
        Inlined,
        Removed,
        BailedOut,
        Indirect;

    }
}

