/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.phases;

import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.truffle.compiler.phases.InstrumentPhase;
import org.graalvm.options.OptionValues;

public class InstrumentBranchesPhase
extends InstrumentPhase {
    private final boolean isInstrumentPerInlineSite;

    public InstrumentBranchesPhase(OptionValues options, SnippetReflectionProvider snippetReflection, InstrumentPhase.Instrumentation instrumentation, boolean instrumentPerInlineSite) {
        super(options, snippetReflection, instrumentation);
        this.isInstrumentPerInlineSite = instrumentPerInlineSite;
    }

    @Override
    protected void instrumentGraph(StructuredGraph graph, CoreProviders context, JavaConstant tableConstant) {
        for (IfNode n : graph.getNodes().filter(IfNode.class)) {
            InstrumentPhase.Point p = this.getOrCreatePoint(n);
            if (p == null) continue;
            InstrumentBranchesPhase.insertCounter(graph, context, tableConstant, n.trueSuccessor(), p.slotIndex(0));
            InstrumentBranchesPhase.insertCounter(graph, context, tableConstant, n.falseSuccessor(), p.slotIndex(1));
        }
    }

    @Override
    protected int instrumentationPointSlotCount() {
        return 2;
    }

    @Override
    protected boolean instrumentPerInlineSite() {
        return this.isInstrumentPerInlineSite;
    }

    @Override
    protected InstrumentPhase.Point createPoint(int id, int startIndex, Node n) {
        return new IfPoint(id, startIndex, n.getNodeSourcePosition());
    }

    public class IfPoint
    extends InstrumentPhase.Point {
        IfPoint(int id, int rawIndex, NodeSourcePosition position) {
            super(id, rawIndex, position);
        }

        @Override
        public int slotCount() {
            return 2;
        }

        @Override
        public boolean isPrettified() {
            return InstrumentBranchesPhase.this.isInstrumentPerInlineSite;
        }

        public long ifVisits() {
            return InstrumentBranchesPhase.this.getInstrumentation().getAccessTable()[this.rawIndex];
        }

        public long elseVisits() {
            return InstrumentBranchesPhase.this.getInstrumentation().getAccessTable()[this.rawIndex + 1];
        }

        public BranchState getBranchState() {
            return BranchState.from(this.ifVisits() > 0L, this.elseVisits() > 0L);
        }

        public String getCounts() {
            return "if=" + this.ifVisits() + "#, else=" + this.elseVisits() + "#";
        }

        @Override
        public long getHotness() {
            return this.ifVisits() + this.elseVisits();
        }

        public String toString() {
            return "[" + this.id + "] state = " + (Object)((Object)this.getBranchState()) + "(" + this.getCounts() + ")";
        }
    }

    public static enum BranchState {
        NONE,
        IF,
        ELSE,
        BOTH;


        public static BranchState from(boolean ifVisited, boolean elseVisited) {
            if (ifVisited && elseVisited) {
                return BOTH;
            }
            if (ifVisited && !elseVisited) {
                return IF;
            }
            if (!ifVisited && elseVisited) {
                return ELSE;
            }
            return NONE;
        }
    }
}

