/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.hotspot;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.nodes.EncodedGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.truffle.compiler.PartialEvaluator;
import org.graalvm.compiler.truffle.compiler.TruffleCompilerConfiguration;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotKnownTruffleTypes;
import org.graalvm.compiler.truffle.compiler.hotspot.HotSpotTruffleGraphBuilderPlugins;
import org.graalvm.compiler.truffle.options.PolyglotCompilerOptions;
import org.graalvm.options.OptionValues;

public final class HotSpotPartialEvaluator
extends PartialEvaluator {
    private final AtomicReference<EconomicMap<ResolvedJavaMethod, EncodedGraph>> graphCacheRef = new AtomicReference();
    private int encodedGraphCacheCapacity;

    public boolean isEncodedGraphCacheEnabled() {
        return this.encodedGraphCacheCapacity != 0;
    }

    public HotSpotPartialEvaluator(TruffleCompilerConfiguration config, GraphBuilderConfiguration configForRoot) {
        super(config, configForRoot, new HotSpotKnownTruffleTypes(config.lastTier().providers().getMetaAccess()));
    }

    @Override
    protected void initialize(OptionValues options) {
        super.initialize(options);
        this.encodedGraphCacheCapacity = (Integer)options.get(PolyglotCompilerOptions.EncodedGraphCacheCapacity);
    }

    @Override
    protected void registerGraphBuilderInvocationPlugins(InvocationPlugins invocationPlugins, boolean canDelayIntrinsification) {
        super.registerGraphBuilderInvocationPlugins(invocationPlugins, canDelayIntrinsification);
        HotSpotTruffleGraphBuilderPlugins.registerCompilationFinalReferencePlugins(invocationPlugins, canDelayIntrinsification, (HotSpotKnownTruffleTypes)this.getKnownTruffleTypes());
    }

    private Map<ResolvedJavaMethod, EncodedGraph> createEncodedGraphMap() {
        if (this.encodedGraphCacheCapacity < 0) {
            return new ConcurrentHashMap<ResolvedJavaMethod, EncodedGraph>();
        }
        return Collections.synchronizedMap(new LinkedHashMap<ResolvedJavaMethod, EncodedGraph>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<ResolvedJavaMethod, EncodedGraph> eldest) {
                return HotSpotPartialEvaluator.this.encodedGraphCacheCapacity >= 0 && this.size() > HotSpotPartialEvaluator.this.encodedGraphCacheCapacity;
            }
        });
    }

    @Override
    public EconomicMap<ResolvedJavaMethod, EncodedGraph> getOrCreateEncodedGraphCache() {
        EconomicMap cache;
        if (this.encodedGraphCacheCapacity == 0) {
            return super.getOrCreateEncodedGraphCache();
        }
        while ((cache = this.graphCacheRef.get()) == null && !this.graphCacheRef.compareAndSet(null, (EconomicMap<ResolvedJavaMethod, EncodedGraph>)(cache = EconomicMap.wrapMap(this.createEncodedGraphMap())))) {
        }
        assert (cache != null);
        return cache;
    }

    public void purgeEncodedGraphCache() {
        this.graphCacheRef.set(null);
    }
}

