/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler.amd64.substitutions;

import java.lang.reflect.Type;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.serviceprovider.ServiceProvider;
import org.graalvm.compiler.truffle.common.TruffleCompilerRuntime;
import org.graalvm.compiler.truffle.compiler.amd64.substitutions.AMD64ArrayUtilsSubstitutions;
import org.graalvm.compiler.truffle.compiler.substitutions.GraphBuilderInvocationPluginProvider;

@ServiceProvider(value=GraphBuilderInvocationPluginProvider.class)
public class TruffleAMD64InvocationPlugins
implements GraphBuilderInvocationPluginProvider {
    @Override
    public void registerInvocationPlugins(Providers providers, Architecture architecture, InvocationPlugins plugins, boolean canDelayIntrinsification) {
        if (architecture instanceof AMD64) {
            TruffleAMD64InvocationPlugins.registerArrayUtilsPlugins(plugins, providers.getMetaAccess(), providers.getReplacements());
        }
    }

    private static void registerArrayUtilsPlugins(InvocationPlugins plugins, MetaAccessProvider metaAccess, Replacements replacements) {
        ResolvedJavaType arrayUtilsType = TruffleCompilerRuntime.getRuntime().resolveType(metaAccess, "com.oracle.truffle.api.ArrayUtils");
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, new InvocationPlugins.ResolvedJavaSymbol(arrayUtilsType), replacements);
        r.registerMethodSubstitution(AMD64ArrayUtilsSubstitutions.class, "runIndexOf", new Type[]{String.class, Integer.TYPE, Integer.TYPE, char[].class});
        r.registerMethodSubstitution(AMD64ArrayUtilsSubstitutions.class, "runIndexOf", new Type[]{char[].class, Integer.TYPE, Integer.TYPE, char[].class});
        r.registerMethodSubstitution(AMD64ArrayUtilsSubstitutions.class, "runIndexOf", new Type[]{byte[].class, Integer.TYPE, Integer.TYPE, byte[].class});
        r.registerMethodSubstitution(AMD64ArrayUtilsSubstitutions.class, "runRegionEquals", new Type[]{byte[].class, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64ArrayUtilsSubstitutions.class, "runRegionEquals", new Type[]{char[].class, Integer.TYPE, char[].class, Integer.TYPE, Integer.TYPE});
        r.registerMethodSubstitution(AMD64ArrayUtilsSubstitutions.class, "runRegionEquals", new Type[]{String.class, Integer.TYPE, String.class, Integer.TYPE, Integer.TYPE});
    }
}

