/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.compiler;

import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.lir.phases.LIRSuites;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.Suites;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.truffle.compiler.PartialEvaluatorConfiguration;

public final class TruffleTierConfiguration {
    private final PartialEvaluatorConfiguration configuration;
    private final Backend backend;
    private final Providers providers;
    private final Suites suites;
    private final LIRSuites lirSuites;

    public TruffleTierConfiguration(PartialEvaluatorConfiguration configuration, Backend backend, OptionValues options) {
        this(configuration, backend, backend.getProviders(), backend.getSuites().getDefaultSuites(options), backend.getSuites().getDefaultLIRSuites(options));
    }

    public TruffleTierConfiguration(PartialEvaluatorConfiguration configuration, Backend backend, Providers providers, Suites suites, LIRSuites lirSuites) {
        this.configuration = configuration;
        this.backend = backend;
        this.providers = providers;
        this.suites = suites;
        this.lirSuites = lirSuites;
    }

    public PartialEvaluatorConfiguration partialEvaluator() {
        return this.configuration;
    }

    public Backend backend() {
        return this.backend;
    }

    public Providers providers() {
        return this.providers;
    }

    public Suites suites() {
        return this.suites;
    }

    public LIRSuites lirSuites() {
        return this.lirSuites;
    }
}

