/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.graalvm.compiler.truffle.common.CompilableTruffleAST;
import org.graalvm.compiler.truffle.common.TruffleDebugContext;
import org.graalvm.compiler.truffle.common.VoidGraphStructure;
import org.graalvm.graphio.GraphOutput;

public final class TruffleOutputGroup
implements Closeable {
    public static final String GROUP_ID = "truffle.compilation.id";
    private final GraphOutput<Void, ?> output;

    private TruffleOutputGroup(TruffleDebugContext debug, CompilableTruffleAST compilable, Map<Object, Object> properties) throws IOException {
        String name = "Truffle::" + compilable.getName();
        GraphOutput<Void, ?> out = null;
        try {
            Map<Object, Object> effectiveProperties;
            out = debug.buildOutput(GraphOutput.newBuilder(VoidGraphStructure.INSTANCE));
            if (properties != null) {
                effectiveProperties = new HashMap<Object, Object>(properties);
                effectiveProperties.putAll(debug.getVersionProperties());
            } else {
                effectiveProperties = debug.getVersionProperties();
            }
            out.beginGroup(null, name, name, null, 0, effectiveProperties);
        }
        catch (Throwable e) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable closeException) {
                    e.addSuppressed(closeException);
                }
            }
            throw e;
        }
        this.output = out;
    }

    @Override
    public void close() throws IOException {
        try {
            this.output.endGroup();
        }
        finally {
            this.output.close();
        }
    }

    public static TruffleOutputGroup open(TruffleDebugContext debug, CompilableTruffleAST compilable, Map<Object, Object> properties) throws IOException {
        if (debug != null && debug.isDumpEnabled()) {
            return new TruffleOutputGroup(debug, compilable, properties);
        }
        return null;
    }
}

