/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.replacements.nodes.arithmetic;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.extended.GuardedNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.replacements.nodes.arithmetic.IntegerExactArithmeticNode;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerAddExactNode
extends AddNode
implements GuardedNode,
IntegerExactArithmeticNode,
IterableNodeType {
    public static final NodeClass<IntegerAddExactNode> TYPE = NodeClass.create(IntegerAddExactNode.class);
    @Node.Input(value=InputType.Guard)
    protected GuardingNode guard;

    public IntegerAddExactNode(ValueNode x, ValueNode y, GuardingNode guard) {
        super(TYPE, x, y);
        this.setStamp(x.stamp(NodeView.DEFAULT).unrestricted());
        assert (x.stamp(NodeView.DEFAULT).isCompatible(y.stamp(NodeView.DEFAULT)) && x.stamp(NodeView.DEFAULT) instanceof IntegerStamp);
        this.guard = guard;
    }

    @Override
    public boolean inferStamp() {
        return false;
    }

    @Override
    public Stamp foldStamp(Stamp stampX, Stamp stampY) {
        IntegerStamp a = (IntegerStamp)stampX;
        IntegerStamp b = (IntegerStamp)stampY;
        int bits = a.getBits();
        assert (bits == b.getBits());
        long defaultMask = CodeUtil.mask((int)bits);
        long variableBits = a.downMask() ^ a.upMask() | b.downMask() ^ b.upMask();
        long variableBitsWithCarry = variableBits | IntegerStamp.carryBits(a.downMask(), b.downMask()) ^ IntegerStamp.carryBits(a.upMask(), b.upMask());
        long newDownMask = a.downMask() + b.downMask() & (variableBitsWithCarry ^ 0xFFFFFFFFFFFFFFFFL);
        long newUpMask = a.downMask() + b.downMask() | variableBitsWithCarry;
        newDownMask &= defaultMask;
        newUpMask &= defaultMask;
        boolean lowerOverflowsPositively = IntegerStamp.addOverflowsPositively(a.lowerBound(), b.lowerBound(), bits);
        boolean upperOverflowsPositively = IntegerStamp.addOverflowsPositively(a.upperBound(), b.upperBound(), bits);
        boolean lowerOverflowsNegatively = IntegerStamp.addOverflowsNegatively(a.lowerBound(), b.lowerBound(), bits);
        boolean upperOverflowsNegatively = IntegerStamp.addOverflowsNegatively(a.upperBound(), b.upperBound(), bits);
        long newLowerBound = lowerOverflowsPositively ? CodeUtil.maxValue((int)bits) : (lowerOverflowsNegatively ? CodeUtil.minValue((int)bits) : CodeUtil.signExtend((long)(a.lowerBound() + b.lowerBound() & defaultMask), (int)bits));
        long newUpperBound = upperOverflowsPositively ? CodeUtil.maxValue((int)bits) : (upperOverflowsNegatively ? CodeUtil.minValue((int)bits) : CodeUtil.signExtend((long)(a.upperBound() + b.upperBound() & defaultMask), (int)bits));
        IntegerStamp limit = StampFactory.forInteger(bits, newLowerBound, newUpperBound);
        newUpperBound = CodeUtil.signExtend((long)(newUpperBound & (newUpMask &= limit.upMask())), (int)bits);
        return IntegerStamp.create(bits, newLowerBound |= (newDownMask |= limit.downMask()), newUpperBound, newDownMask, newUpMask);
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        long c;
        if (forX.isConstant() && !forY.isConstant()) {
            return (ValueNode)new IntegerAddExactNode(forY, forX, this.guard).canonical(tool);
        }
        if (forX.isConstant() && forY.isConstant()) {
            return this.canonicalXYconstant(forX, forY);
        }
        if (forY.isConstant() && (c = forY.asJavaConstant().asLong()) == 0L) {
            return forX;
        }
        if (!IntegerStamp.addCanOverflow((IntegerStamp)forX.stamp(NodeView.DEFAULT), (IntegerStamp)forY.stamp(NodeView.DEFAULT))) {
            return (ValueNode)new AddNode(forX, forY).canonical(tool);
        }
        if (this.getGuard() == null) {
            return (ValueNode)new AddNode(forX, forY).canonical(tool);
        }
        return this;
    }

    private ValueNode canonicalXYconstant(ValueNode forX, ValueNode forY) {
        JavaConstant xConst = forX.asJavaConstant();
        JavaConstant yConst = forY.asJavaConstant();
        assert (xConst.getJavaKind() == yConst.getJavaKind());
        try {
            if (xConst.getJavaKind() == JavaKind.Int) {
                return ConstantNode.forInt(Math.addExact(xConst.asInt(), yConst.asInt()));
            }
            assert (xConst.getJavaKind() == JavaKind.Long);
            return ConstantNode.forLong(Math.addExact(xConst.asLong(), yConst.asLong()));
        }
        catch (ArithmeticException arithmeticException) {
            return this;
        }
    }

    @Override
    public GuardingNode getGuard() {
        return this.guard;
    }

    @Override
    public void setGuard(GuardingNode guard) {
        this.updateUsagesInterface(this.guard, guard);
        this.guard = guard;
    }

    @Override
    protected boolean isExact() {
        return true;
    }
}

